/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class GraphicStyle
extends Style {
    private String backcolor;
    private String forecolor;
    private String style;
    private String width;
    private String hAlign;
    private String vAlign;

    public GraphicStyle(WriterHelper styleWriter, JRPrintGraphicElement element) {
        super(styleWriter);
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        }
        this.forecolor = JRColorUtil.getColorHexa(element.getLinePen().getLineColor());
        double doubleWidth = element.getLinePen().getLineWidth().doubleValue();
        if (doubleWidth < 0.0) {
            this.style = "none";
        } else {
            switch (element.getLinePen().getLineStyleValue()) {
                case DOTTED: 
                case DASHED: {
                    this.style = "dash";
                    break;
                }
                default: {
                    this.style = "solid";
                }
            }
        }
        this.width = String.valueOf(LengthUtil.inchNoRound(doubleWidth));
        HorizontalImageAlignEnum horizontalAlignment = HorizontalImageAlignEnum.LEFT;
        VerticalImageAlignEnum verticalAlignment = VerticalImageAlignEnum.TOP;
        if (element instanceof JRPrintImage) {
            JRPrintImage imageElement = (JRPrintImage)element;
            horizontalAlignment = imageElement.getHorizontalImageAlign();
            verticalAlignment = imageElement.getVerticalImageAlign();
        }
        switch (horizontalAlignment) {
            case RIGHT: {
                this.hAlign = "right";
                break;
            }
            case CENTER: {
                this.hAlign = "center";
                break;
            }
            default: {
                this.hAlign = "left";
            }
        }
        switch (verticalAlignment) {
            case BOTTOM: {
                this.vAlign = "bottom";
                break;
            }
            case MIDDLE: {
                this.vAlign = "middle";
                break;
            }
            default: {
                this.vAlign = "top";
            }
        }
    }

    @Override
    public String getId() {
        StringBuilder id = new StringBuilder();
        id.append(this.backcolor);
        id.append("|");
        id.append(this.forecolor);
        id.append("|");
        id.append(this.style);
        id.append("|");
        id.append(this.width);
        id.append("|");
        id.append(this.hAlign);
        id.append("|");
        id.append(this.vAlign);
        return id.toString();
    }

    @Override
    public void write(String lineStyleName) {
        this.styleWriter.write(" <style:style style:name=\"" + lineStyleName + "\"");
        this.styleWriter.write(" style:family=\"graphic\" style:parent-style-name=\"Graphics\">\n");
        this.styleWriter.write("   <style:graphic-properties");
        this.styleWriter.write(" draw:fill-color=\"#" + this.backcolor + "\"");
        this.styleWriter.write(" style:horizontal-pos=\"" + this.hAlign + "\" style:horizontal-rel=\"paragraph\"");
        this.styleWriter.write(" style:vertical-pos=\"" + this.vAlign + "\" style:vertical-rel=\"paragraph\"");
        this.styleWriter.write(" svg:stroke-color=\"#" + this.forecolor + "\"");
        this.styleWriter.write(" draw:stroke=\"" + this.style + "\"");
        this.styleWriter.write(" draw:stroke-dash=\"Dashed\"");
        this.styleWriter.write(" svg:stroke-width=\"" + this.width + "in\"");
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

