/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.BookmarkIterator;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.base.BasePrintBookmark;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BookmarkStack {
    private static final Log log = LogFactory.getLog(BookmarkStack.class);
    LinkedList<BasePrintBookmark> stack = new LinkedList();
    boolean isCollapseMissingBookmarkLevels;
    Map<PrintElementId, BasePrintBookmark> updateableBookmarks;

    public BookmarkStack(boolean isCollapseMissingBookmarkLevels) {
        this.isCollapseMissingBookmarkLevels = isCollapseMissingBookmarkLevels;
        BasePrintBookmark root = new BasePrintBookmark(null, 0, null, 0);
        this.push(root);
        this.updateableBookmarks = new HashMap<PrintElementId, BasePrintBookmark>();
    }

    public boolean hasBookmarks() {
        List<PrintBookmark> bookmarks = this.stack.getFirst().getBookmarks();
        return bookmarks != null && !bookmarks.isEmpty();
    }

    public void push(BasePrintBookmark bookmark) {
        this.stack.add(bookmark);
    }

    public BasePrintBookmark pop() {
        return this.stack.removeLast();
    }

    public BasePrintBookmark peek() {
        return this.stack.getLast();
    }

    protected BasePrintBookmark addBookmark(int level, String label, int pageIndex, String elementAddress) {
        BasePrintBookmark parent = this.peek();
        while (parent.getLevel() >= level) {
            this.pop();
            parent = this.peek();
        }
        if (!this.isCollapseMissingBookmarkLevels) {
            BasePrintBookmark parentPrintBookmark = parent;
            for (int i = parent.getLevel() + 1; i < level; ++i) {
                BasePrintBookmark emptyBookmark = this.createBookmark(parent, "", parentPrintBookmark.getPageIndex(), parentPrintBookmark.getElementAddress());
                this.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        BasePrintBookmark bookmark = this.createBookmark(parent, label, pageIndex, elementAddress);
        this.push(bookmark);
        return bookmark;
    }

    protected BasePrintBookmark createBookmark(BasePrintBookmark parent, String label, int pageIndex, String elementAddress) {
        int level = parent == null ? 0 : parent.getLevel() + 1;
        BasePrintBookmark printBookmark = new BasePrintBookmark(label, pageIndex, elementAddress, level);
        if (parent != null) {
            parent.addBookmark(printBookmark);
        }
        return printBookmark;
    }

    protected void addBookmarks(List<JRPrintElement> elements, int pageIndex, String elementAddress) {
        if (elements != null) {
            elementAddress = elementAddress == null ? "" : elementAddress;
            int i = 0;
            for (JRPrintElement element : elements) {
                JRPrintAnchor anchor;
                int level;
                if (element instanceof JRPrintFrame) {
                    this.addBookmarks(((JRPrintFrame)element).getElements(), pageIndex, elementAddress + (elementAddress.length() == 0 ? "" : "_") + i + "_");
                } else if (element instanceof JRPrintAnchor && (level = (anchor = (JRPrintAnchor)((Object)element)).getBookmarkLevel()) != 0) {
                    String anchorName = anchor.getAnchorName();
                    BasePrintBookmark bookmark = this.addBookmark(level, anchorName, pageIndex, elementAddress + i);
                    if (anchorName == null) {
                        PrintElementId elementId = PrintElementId.forElement(element);
                        this.updateableBookmarks.put(elementId, bookmark);
                    }
                }
                ++i;
            }
        }
    }

    public void updateBookmark(JRPrintElement element) {
        JRPrintAnchor anchor;
        int level;
        if (element instanceof JRPrintAnchor && (level = (anchor = (JRPrintAnchor)((Object)element)).getBookmarkLevel()) != 0) {
            PrintElementId elementId = PrintElementId.forElement(element);
            BasePrintBookmark bookmark = this.updateableBookmarks.get(elementId);
            if (bookmark == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cound not find bookmark for " + elementId + " to update"));
                }
            } else {
                String anchorName = anchor.getAnchorName();
                bookmark.setLabel(anchorName);
            }
        }
    }

    protected List<PrintBookmark> getRootBookmarks() {
        return this.stack.getFirst().getBookmarks();
    }

    protected void addBookmark(BasePrintBookmark bookmark, int pageOffset) {
        this.addBookmark(bookmark.getLevel(), bookmark.getLabel(), pageOffset + bookmark.getPageIndex(), bookmark.getElementAddress());
    }

    public void appendBookmarks(BookmarkStack bookmarkStack, int pageOffset) {
        BookmarkIterator iterator = bookmarkStack.bookmarkIterator();
        while (iterator.hasBookmark()) {
            BasePrintBookmark bookmark = iterator.bookmark();
            this.addBookmark(bookmark, pageOffset);
            iterator.next();
        }
    }

    public BookmarkIterator bookmarkIterator() {
        return new BookmarkIterator(this.stack.getFirst());
    }
}

