/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractHashingCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.MessageDigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDigestCacheKeyGenerator
extends AbstractHashingCacheKeyGenerator<MessageDigestOutputStream, String> {
    public static final String DEFAULT_BEAN_NAME = "com.googlecode.ehcache.annotations.key.MessageDigestCacheKeyGenerator.DEFAULT_BEAN_NAME";
    public static final String DEFAULT_ALGORITHM = "SHA-1";
    protected static final int DEFAULT_BYTE_BUFFER_SIZE = 64;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MessageDigest baseMessageDigest;
    private boolean cloneNotSupported;

    public MessageDigestCacheKeyGenerator() throws NoSuchAlgorithmException {
        this(DEFAULT_ALGORITHM);
    }

    public MessageDigestCacheKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        this.baseMessageDigest = MessageDigest.getInstance(algorithm);
    }

    public MessageDigestCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) throws NoSuchAlgorithmException {
        this(DEFAULT_ALGORITHM, includeMethod, includeParameterTypes);
    }

    public MessageDigestCacheKeyGenerator(String algorithm, boolean includeMethod, boolean includeParameterTypes) throws NoSuchAlgorithmException {
        super(includeMethod, includeParameterTypes);
        this.baseMessageDigest = MessageDigest.getInstance(algorithm);
    }

    @Override
    public MessageDigestOutputStream getGenerator(Object ... data) {
        MessageDigest messageDigest = this.getMessageDigest();
        return new MessageDigestOutputStream(messageDigest);
    }

    @Override
    public String generateKey(MessageDigestOutputStream generator) {
        MessageDigest messageDigest = generator.getMessageDigest();
        byte[] digest = messageDigest.digest();
        return this.encodeHash(digest);
    }

    protected String encodeHash(byte[] digest) {
        return Base64.encodeBase64URLSafeString((byte[])digest);
    }

    protected MessageDigest getMessageDigest() {
        if (this.cloneNotSupported) {
            String algorithm = this.baseMessageDigest.getAlgorithm();
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("MessageDigest algorithm '" + algorithm + "' was supported when " + this.getClass().getSimpleName() + " was created but is not now. This should not be possible.", e);
            }
        }
        try {
            return (MessageDigest)this.baseMessageDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            this.cloneNotSupported = true;
            this.logger.warn("Could not clone MessageDigest using algorithm '" + this.baseMessageDigest.getAlgorithm() + "'. MessageDigest.getInstance will be used from now on which will be much more expensive.", (Throwable)e);
            return this.getMessageDigest();
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, boolean[] a) {
        for (boolean element : a) {
            generator.writeBoolean(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, byte[] a) {
        generator.write(a);
    }

    @Override
    protected void append(MessageDigestOutputStream generator, char[] a) {
        for (char element : a) {
            generator.writeChar(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, double[] a) {
        for (double element : a) {
            generator.writeDouble(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, float[] a) {
        for (float element : a) {
            generator.writeFloat(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, int[] a) {
        for (int element : a) {
            generator.writeInt(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, long[] a) {
        for (long element : a) {
            generator.writeLong(element);
        }
    }

    @Override
    protected void append(MessageDigestOutputStream generator, short[] a) {
        for (short element : a) {
            generator.writeShort(element);
        }
    }

    @Override
    protected void appendGraphCycle(MessageDigestOutputStream generator, Object o) {
        generator.write(0);
    }

    @Override
    protected void appendNull(MessageDigestOutputStream generator) {
        generator.write(0);
    }

    @Override
    protected void appendHash(MessageDigestOutputStream generator, Object e) {
        if (e instanceof String) {
            generator.writeUTF((String)e);
        } else if (e instanceof Boolean) {
            generator.writeBoolean((Boolean)e);
        } else if (e instanceof Byte) {
            generator.writeByte(((Byte)e).byteValue());
        } else if (e instanceof Character) {
            generator.writeChar(((Character)e).charValue());
        } else if (e instanceof Double) {
            generator.writeDouble((Double)e);
        } else if (e instanceof Float) {
            generator.writeFloat(((Float)e).floatValue());
        } else if (e instanceof Integer) {
            generator.writeInt((Integer)e);
        } else if (e instanceof Long) {
            generator.writeLong((Long)e);
        } else if (e instanceof Short) {
            generator.writeShort(((Short)e).shortValue());
        } else {
            generator.writeInt(e.hashCode());
        }
    }
}

