/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations;

import com.google.common.collect.MapMaker;
import com.googlecode.ehcache.annotations.RefreshableCacheEntry;
import com.googlecode.ehcache.annotations.support.TaskSchedulerAdapter;
import com.googlecode.ehcache.annotations.support.TimerTaskSchedulerAdapter;
import java.io.Serializable;
import java.util.Timer;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;

public class RefreshingSelfPopulatingCache
extends SelfPopulatingCache {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<Serializable, Long> refreshQueue = new MapMaker().weakKeys().makeMap();
    private final TaskSchedulerAdapter scheduler;
    private final TaskExecutor executer;
    private final long refreshInterval;

    public RefreshingSelfPopulatingCache(Ehcache cache, CacheEntryFactory cacheEntryFactory, TaskSchedulerAdapter scheduler, TaskExecutor executer, long refreshInterval) {
        super(cache, cacheEntryFactory);
        Timer timer;
        if (scheduler == null) {
            timer = new Timer(cache.getName() + " Cache Refresh Timer", true);
            this.scheduler = new TimerTaskSchedulerAdapter(timer);
        } else {
            timer = null;
            this.scheduler = scheduler;
        }
        this.executer = executer;
        this.refreshInterval = refreshInterval;
        this.scheduleRefreshTask();
        this.getCacheManager().setCacheManagerEventListener(new CacheManagerEventListener(){

            public void notifyCacheRemoved(String cacheName) {
            }

            public void notifyCacheAdded(String cacheName) {
            }

            public void init() throws CacheException {
            }

            public Status getStatus() {
                return null;
            }

            public void dispose() throws CacheException {
                if (timer != null) {
                    timer.cancel();
                }
            }
        });
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    protected void scheduleRefreshTask() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    RefreshingSelfPopulatingCache.this.refresh();
                }
                catch (Throwable t) {
                    RefreshingSelfPopulatingCache.this.logger.error("An exception was thrown while refreshing the cache. Review the previous log statements for errors related to individual cache entries.", t);
                }
            }
        }, this.refreshInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element refreshElement(final Element element, final Ehcache backingCache, final boolean quiet) throws Exception {
        long now;
        final Serializable key = element.getKey();
        Long existingRefreshStart = this.refreshQueue.putIfAbsent(key, now = System.currentTimeMillis());
        if (existingRefreshStart != null) {
            this.logger.warn("Key {} in cache {} is already being refreshed started {}ms ago, it will be skipped for this refresh iteration.", new Object[]{key, backingCache.getName(), now - existingRefreshStart});
            return null;
        }
        boolean clearRefreshFlag = true;
        try {
            if (element.isExpired()) {
                this.logger.debug("Element for key {} has expired, this key will not be refreshed", (Object)key);
                Element element2 = null;
                return element2;
            }
            long age = now - element.getLatestOfCreationAndUpdateTime();
            if (age < this.refreshInterval) {
                this.logger.debug("Element for key {} is only {}ms old and will not be refreshed. Refresh age is {}", new Object[]{key, age, this.refreshInterval});
                Element element3 = null;
                return element3;
            }
            Object value = element.getObjectValue();
            if (!(value instanceof RefreshableCacheEntry)) {
                this.logger.warn("RefreshingSelfPopulatingCache contains an entry which is not a RefreshableCacheEntry for key {} this entry will be ignored during refresh.", (Object)key);
                Element element4 = null;
                return element4;
            }
            if (this.executer == null) {
                super.refreshElement(element, backingCache, quiet);
            } else {
                clearRefreshFlag = false;
                this.executer.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            RefreshingSelfPopulatingCache.super.refreshElement(element, backingCache, quiet);
                        }
                        catch (Throwable e) {
                            RefreshingSelfPopulatingCache.this.logger.error("An exception was thrown while refreshing the ca", e);
                        }
                        finally {
                            RefreshingSelfPopulatingCache.this.refreshQueue.remove(key);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.warn("An exception was thrown while refreshing the cache for " + element + ". This element may not have been refreshed", (Throwable)e);
        }
        finally {
            if (clearRefreshFlag) {
                this.refreshQueue.remove(key);
            }
        }
        return element;
    }
}

