/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.string;

import egovframework.rte.fdl.string.EgovStringUtil;
import java.math.BigDecimal;

public class EgovNumericUtil {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_UNNECESSARY = 7;

    protected EgovNumericUtil() {
    }

    public static boolean isNumber(String source) {
        if (EgovStringUtil.isNull(source)) {
            return false;
        }
        try {
            Double db = new Double(source);
            return !db.isNaN();
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static String plus(String thisVal, String addVal) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.add(two).toString();
        return result;
    }

    public static String plus(String thisVal, String addVal, int scale) {
        return EgovNumericUtil.plus(thisVal, addVal, scale, 7);
    }

    public static String plus(String thisVal, String addVal, int scale, int roundMode) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.add(two).setScale(scale, roundMode).toString();
        return result;
    }

    public static String minus(String thisVal, String addVal) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.subtract(two).toString();
        return result;
    }

    public static String minus(String thisVal, String addVal, int scale) {
        return EgovNumericUtil.minus(thisVal, addVal, scale, 7);
    }

    public static String minus(String thisVal, String addVal, int scale, int roundMode) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.subtract(two).setScale(scale, roundMode).toString();
        return result;
    }

    public static String multiply(String thisVal, String addVal) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.multiply(two).toString();
        return result;
    }

    public static String multiply(String thisVal, String addVal, int scale) {
        return EgovNumericUtil.multiply(thisVal, addVal, scale, 7);
    }

    public static String multiply(String thisVal, String addVal, int scale, int roundMode) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.multiply(two).setScale(scale, roundMode).toString();
        return result;
    }

    public static String divide(String thisVal, String addVal) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.divide(two).toString();
        return result;
    }

    public static String divide(String thisVal, String addVal, int roundMode) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.divide(two, roundMode).toString();
        return result;
    }

    public static String divide(String thisVal, String addVal, int scale, int roundMode) {
        String result = null;
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        BigDecimal two = new BigDecimal(addVal == null ? "0" : addVal);
        result = one.divide(two, scale, roundMode).toString();
        return result;
    }

    public static String setScale(String thisVal, int scale, int roundMode) {
        BigDecimal one = new BigDecimal(thisVal == null ? "0" : thisVal);
        return one.setScale(scale, roundMode).toString();
    }
}

