/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.string;

import egovframework.rte.fdl.string.EgovObjectUtil;
import egovframework.rte.fdl.string.EgovStringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class EgovDateUtil {
    protected EgovDateUtil() {
    }

    public static String getCalcDateAsString(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return EgovDateUtil.getFormalYear(cd) + EgovDateUtil.getFormalMonth(cd) + EgovDateUtil.getFormalDay(cd);
    }

    public static String getCalcYearAsString(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return EgovDateUtil.getFormalYear(cd);
    }

    public static String getCalcMonthAsString(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return EgovDateUtil.getFormalMonth(cd);
    }

    public static String getCalcDayAsString(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return EgovDateUtil.getFormalDay(cd);
    }

    public static int getCalcYearAsInt(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return cd.get(1);
    }

    public static int getCalcMonthAsInt(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return cd.get(2) + 1;
    }

    public static int getCalcDayAsInt(String sYearPara, String sMonthPara, String sDayPara, int iTerm, String sGuBun) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYearPara), Integer.parseInt(sMonthPara) - 1, Integer.parseInt(sDayPara));
        if (EgovStringUtil.equals(sGuBun, "day")) {
            ((Calendar)cd).add(5, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "month")) {
            ((Calendar)cd).add(2, iTerm);
        } else if (EgovStringUtil.equals(sGuBun, "year")) {
            ((Calendar)cd).add(1, iTerm);
        }
        return cd.get(5);
    }

    public static int getCurrentYearAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(1);
    }

    public static int getCurrentMonthAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(2) + 1;
    }

    public static int getCurrentDayAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(5);
    }

    public static int getCurrentHourAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(11);
    }

    public static int getCurrentMinuteAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(12);
    }

    public static int getCurrentMilliSecondAsInt() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return cd.get(14);
    }

    public static String getCurrentYearAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalYear(cd);
    }

    public static String getCurrentMonthAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalMonth(cd);
    }

    public static String getCurrentDayAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalDay(cd);
    }

    public static String getCurrentHourAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalHour(cd);
    }

    public static String getCurrentMinuteAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalMin(cd);
    }

    public static String getCurrentSecondAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalSec(cd);
    }

    public static String getCurrentMilliSecondAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalMSec(cd);
    }

    public static String getCurrentDateAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalYear(cd) + EgovDateUtil.getFormalMonth(cd) + EgovDateUtil.getFormalDay(cd);
    }

    public static String getCurrentTimeAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalHour(cd) + EgovDateUtil.getFormalMin(cd) + EgovDateUtil.getFormalSec(cd);
    }

    public static String getCurrentDateTimeAsString() {
        GregorianCalendar cd = new GregorianCalendar(Locale.KOREA);
        return EgovDateUtil.getFormalYear(cd) + EgovDateUtil.getFormalMonth(cd) + EgovDateUtil.getFormalDay(cd) + EgovDateUtil.getFormalHour(cd) + EgovDateUtil.getFormalMin(cd) + EgovDateUtil.getFormalSec(cd);
    }

    public static String getDayOfWeekAsString(String sYear, String sMonth, String sDay) {
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(sYear), Integer.parseInt(sMonth) - 1, Integer.parseInt(sDay));
        SimpleDateFormat sdf = new SimpleDateFormat("EEE", Locale.KOREA);
        Date d1 = cd.getTime();
        return sdf.format(d1);
    }

    public static int getFullAge(String socialNo, String keyDate) {
        String birthDate = null;
        if (EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "0") || EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "9")) {
            birthDate = "18" + socialNo.substring(0, 6);
        } else if (EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "1") || EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "2")) {
            birthDate = "19" + socialNo.substring(0, 6);
        } else if (EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "3") || EgovStringUtil.equals(EgovStringUtil.toSubString(socialNo, 6, 7), "4")) {
            birthDate = "20" + socialNo.substring(0, 6);
        }
        if (Integer.parseInt(keyDate.substring(4, 8)) < Integer.parseInt(birthDate.substring(4, 8))) {
            return Integer.parseInt(keyDate.substring(0, 4)) - Integer.parseInt(birthDate.substring(0, 4)) - 1;
        }
        return Integer.parseInt(keyDate.substring(0, 4)) - Integer.parseInt(birthDate.substring(0, 4));
    }

    public static int getCurrentFullAge(String socialNo) {
        String sCurrentDate = EgovDateUtil.getCurrentYearAsString() + EgovDateUtil.getCurrentMonthAsString() + EgovDateUtil.getCurrentDayAsString();
        return EgovDateUtil.getFullAge(socialNo, sCurrentDate);
    }

    public static int getDayCountForMonth(int year, int month) {
        int[] DOMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] lDOMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (year % 4 == 0) {
            if (year % 100 == 0 && year % 400 != 0) {
                return DOMonth[month - 1];
            }
            return lDOMonth[month - 1];
        }
        return DOMonth[month - 1];
    }

    public static int getDayCount(String from, String to) throws ParseException {
        return EgovDateUtil.getDayCountWithFormatter(from, to, "yyyyMMdd");
    }

    public static Date dateFormatCheck(String source) throws ParseException {
        return EgovDateUtil.dateFormatCheck(source, "yyyyMMdd");
    }

    public static Date dateFormatCheck(String source, String format) throws ParseException {
        if (source == null) {
            throw new ParseException("date string to check is null", 0);
        }
        if (format == null) {
            throw new ParseException("format string to check date is null", 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(source);
        }
        catch (ParseException e) {
            throw new ParseException(" wrong date:\"" + source + "\" with format \"" + format + "\"", 0);
        }
        if (!formatter.format(date).equals(source)) {
            throw new ParseException("Out of bound date:\"" + source + "\" with format \"" + format + "\"", 0);
        }
        return date;
    }

    public static int getDayCountWithFormatter(String from, String to, String format) throws ParseException {
        long duration = EgovDateUtil.getTimeCount(from, to, format);
        return (int)(duration / 86400000L);
    }

    protected static String getFormatStringWithDate(String date) throws ParseException {
        String format = null;
        if (date.length() == 4) {
            format = "HHmm";
        } else if (date.length() == 8) {
            format = "yyyyMMdd";
        } else if (date.length() == 12) {
            format = "yyyyMMddHHmm";
        } else if (date.length() == 14) {
            format = "yyyyMMddHHmmss";
        } else if (date.length() == 17) {
            format = "yyyyMMddHHmmssSSS";
        } else {
            throw new ParseException(" wrong date format!:\"" + format + "\"", 0);
        }
        return format;
    }

    public static long getTimeCount(String from, String to) throws ParseException {
        String format = EgovDateUtil.getFormatStringWithDate(from);
        return EgovDateUtil.getTimeCount(from, to, format);
    }

    public static long getTimeCount(String from, String to, String format) throws ParseException {
        Date d1 = EgovDateUtil.dateFormatCheck(from, format);
        Date d2 = EgovDateUtil.dateFormatCheck(to, format);
        long duration = d2.getTime() - d1.getTime();
        return duration;
    }

    public static int getDayOfWeekCount(String from, String to, String yoil) throws ParseException {
        int first = 0;
        int count = 0;
        String[] sYoil = new String[]{"\uc77c", "\uc6d4", "\ud654", "\uc218", "\ubaa9", "\uae08", "\ud1a0"};
        int betweenDays = EgovDateUtil.getDayCount(from, to);
        GregorianCalendar cd = new GregorianCalendar(Integer.parseInt(from.substring(0, 4)), Integer.parseInt(from.substring(4, 6)) - 1, Integer.parseInt(from.substring(6, 8)));
        int dayOfWeek = cd.get(7);
        if (yoil.length() == 3) {
            yoil = yoil.substring(0, 1);
        }
        while (!sYoil[(dayOfWeek - 1) % 7].equals(yoil)) {
            ++dayOfWeek;
            ++first;
        }
        if (betweenDays - first < 0) {
            return 0;
        }
        ++count;
        return count += (betweenDays - first) / 7;
    }

    private static String getFormalYear(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(1)), 4, '0');
    }

    private static String getFormalMonth(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(2) + 1), 2, '0');
    }

    private static String getFormalDay(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(5)), 2, '0');
    }

    private static String getFormalHour(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(11)), 2, '0');
    }

    private static String getFormalMin(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(12)), 2, '0');
    }

    private static String getFormalSec(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(13)), 2, '0');
    }

    private static String getFormalMSec(Calendar cd) {
        return EgovStringUtil.lPad(Integer.toString(cd.get(14)), 3, '0');
    }

    public static String toString(Date date, String format, Locale locale) {
        if (EgovStringUtil.isNull(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        if (EgovObjectUtil.isNull(locale)) {
            locale = Locale.KOREA;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        String tmp = sdf.format(date);
        return tmp;
    }
}

