/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.excel.util;

import egovframework.rte.fdl.string.EgovDateUtil;
import egovframework.rte.fdl.string.EgovStringUtil;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class EgovExcelUtil {
    private static Log log = LogFactory.getLog(EgovExcelUtil.class);

    public static String getValue(HSSFCell cell) {
        String result = "";
        if (null == cell || cell.equals(null)) {
            return "";
        }
        if (cell.getCellType() == 4) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_BOOLEAN : 4");
            result = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == 5) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_ERROR : 5");
        } else if (cell.getCellType() == 2) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_FORMULA : 2");
            String stringValue = cell.getRichStringCellValue().getString();
            String longValue = EgovExcelUtil.doubleToString(cell.getNumericCellValue());
            result = EgovStringUtil.isNumeric((String)longValue) ? longValue : stringValue;
        } else if (cell.getCellType() == 0) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_NUMERIC : 0");
            result = HSSFDateUtil.isCellDateFormatted((Cell)cell) ? EgovDateUtil.toString((Date)cell.getDateCellValue(), (String)"yyyy/MM/dd", null) : EgovExcelUtil.doubleToString(cell.getNumericCellValue());
        } else if (cell.getCellType() == 1) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_STRING : 1");
            result = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 3) {
            log.debug((Object)"### HSSFCell.CELL_TYPE_BLANK : 3");
        }
        return result;
    }

    public static String getValue(XSSFCell cell) {
        String result = "";
        if (null == cell || cell.equals(null)) {
            return "";
        }
        if (cell.getCellType() == 4) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_BOOLEAN : 4");
            result = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == 5) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_ERROR : 5");
        } else if (cell.getCellType() == 2) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_FORMULA : 2");
            String stringValue = cell.getRichStringCellValue().getString();
            String longValue = EgovExcelUtil.doubleToString(cell.getNumericCellValue());
            result = EgovStringUtil.isNumeric((String)longValue) ? longValue : stringValue;
        } else if (cell.getCellType() == 0) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_NUMERIC : 0");
            result = HSSFDateUtil.isCellDateFormatted((Cell)cell) ? EgovDateUtil.toString((Date)cell.getDateCellValue(), (String)"yyyy/MM/dd", null) : EgovExcelUtil.doubleToString(cell.getNumericCellValue());
        } else if (cell.getCellType() == 1) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_STRING : 1");
            result = cell.getRichStringCellValue().getString();
        } else if (cell.getCellType() == 3) {
            log.debug((Object)"### XSSFCell.CELL_TYPE_BLANK : 3");
        }
        return result;
    }

    public static String doubleToString(double d) {
        long lValue = (long)d;
        return (double)lValue == d ? Long.toString(lValue) : Double.toString(d);
    }
}

