/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.excel.util;

import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.servlet.view.AbstractView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPOIExcelView
extends AbstractView {
    protected boolean generatesDownloadContent() {
        return true;
    }

    protected final void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.logger.debug((Object)"Created Excel Workbook from scratch");
        this.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.buildExcelDocument(model, workbook, request, response);
        response.setContentType(this.getContentType());
        ServletOutputStream out = response.getOutputStream();
        out.flush();
        workbook.write((OutputStream)out);
        out.flush();
    }

    protected abstract void buildExcelDocument(Map<String, Object> var1, XSSFWorkbook var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected XSSFCell getCell(XSSFSheet sheet, int row, int col) {
        XSSFCell cell;
        XSSFRow sheetRow = sheet.getRow(row);
        if (sheetRow == null) {
            sheetRow = sheet.createRow(row);
        }
        if ((cell = sheetRow.getCell((int)((short)col))) == null) {
            cell = sheetRow.createCell((int)((short)col));
        }
        return cell;
    }

    protected void setText(XSSFCell cell, String text) {
        cell.setCellType(1);
        cell.setCellValue(text);
    }
}

