/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.digester3.AbstractRulesImpl;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesBase
extends AbstractRulesImpl {
    protected HashMap<String, List<Rule>> cache = new HashMap();
    protected ArrayList<Rule> rules = new ArrayList();

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        for (Rule rule : this.rules) {
            rule.setDigester(digester);
        }
    }

    @Override
    protected void registerRule(String pattern, Rule rule) {
        List<Rule> list;
        int patternLength = pattern.length();
        if (patternLength > 1 && pattern.endsWith("/")) {
            pattern = pattern.substring(0, patternLength - 1);
        }
        if ((list = this.cache.get(pattern)) == null) {
            list = new ArrayList<Rule>();
            this.cache.put(pattern, list);
        }
        list.add(rule);
        this.rules.add(rule);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.rules.clear();
    }

    @Override
    public List<Rule> match(String namespaceURI, String pattern, String name, Attributes attributes) {
        List<Rule> rulesList = this.lookup(namespaceURI, pattern);
        if (rulesList == null || rulesList.size() < 1) {
            String longKey = "";
            for (String key : this.cache.keySet()) {
                if (!key.startsWith("*/") || !pattern.equals(key.substring(2)) && !pattern.endsWith(key.substring(1)) || key.length() <= longKey.length()) continue;
                rulesList = this.lookup(namespaceURI, key);
                longKey = key;
            }
        }
        if (rulesList == null) {
            rulesList = new ArrayList<Rule>();
        }
        return rulesList;
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    protected List<Rule> lookup(String namespaceURI, String pattern) {
        List<Rule> list = this.cache.get(pattern);
        if (list == null) {
            return null;
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return list;
        }
        ArrayList<Rule> results = new ArrayList<Rule>();
        for (Rule item : list) {
            if (!namespaceURI.equals(item.getNamespaceURI()) && item.getNamespaceURI() != null) continue;
            results.add(item);
        }
        return results;
    }
}

