/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xwpf.usermodel.ICell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFTableRow {
    private CTRow ctRow;
    private XWPFTable table;
    private List<XWPFTableCell> tableCells;

    public XWPFTableRow(CTRow cTRow, XWPFTable xWPFTable) {
        this.table = xWPFTable;
        this.ctRow = cTRow;
        this.getTableCells();
    }

    @Internal
    public CTRow getCtRow() {
        return this.ctRow;
    }

    public XWPFTableCell createCell() {
        XWPFTableCell xWPFTableCell = new XWPFTableCell(this.ctRow.addNewTc(), this, this.table.getBody());
        this.tableCells.add(xWPFTableCell);
        return xWPFTableCell;
    }

    public XWPFTableCell getCell(int n) {
        if (n >= 0 && n < this.ctRow.sizeOfTcArray()) {
            return this.getTableCells().get(n);
        }
        return null;
    }

    public void removeCell(int n) {
        if (n >= 0 && n < this.ctRow.sizeOfTcArray()) {
            this.tableCells.remove(n);
        }
    }

    public XWPFTableCell addNewTableCell() {
        CTTc cTTc = this.ctRow.addNewTc();
        XWPFTableCell xWPFTableCell = new XWPFTableCell(cTTc, this, this.table.getBody());
        this.tableCells.add(xWPFTableCell);
        return xWPFTableCell;
    }

    public int getHeight() {
        CTTrPr cTTrPr = this.getTrPr();
        return cTTrPr.sizeOfTrHeightArray() == 0 ? 0 : cTTrPr.getTrHeightArray(0).getVal().intValue();
    }

    public void setHeight(int n) {
        CTTrPr cTTrPr = this.getTrPr();
        CTHeight cTHeight = cTTrPr.sizeOfTrHeightArray() == 0 ? cTTrPr.addNewTrHeight() : cTTrPr.getTrHeightArray(0);
        cTHeight.setVal(new BigInteger("" + n));
    }

    private CTTrPr getTrPr() {
        return this.ctRow.isSetTrPr() ? this.ctRow.getTrPr() : this.ctRow.addNewTrPr();
    }

    public XWPFTable getTable() {
        return this.table;
    }

    public List<ICell> getTableICells() {
        ArrayList<ICell> arrayList = new ArrayList<ICell>();
        XmlCursor xmlCursor = this.ctRow.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTTc) {
                arrayList.add(new XWPFTableCell((CTTc)xmlObject, this, this.table.getBody()));
                continue;
            }
            if (!(xmlObject instanceof CTSdtCell)) continue;
            arrayList.add(new XWPFSDTCell((CTSdtCell)xmlObject, this, this.table.getBody()));
        }
        return arrayList;
    }

    public List<XWPFTableCell> getTableCells() {
        if (this.tableCells == null) {
            ArrayList<XWPFTableCell> arrayList = new ArrayList<XWPFTableCell>();
            for (CTTc cTTc : this.ctRow.getTcArray()) {
                arrayList.add(new XWPFTableCell(cTTc, this, this.table.getBody()));
            }
            this.tableCells = arrayList;
        }
        return this.tableCells;
    }

    public XWPFTableCell getTableCell(CTTc cTTc) {
        for (int i = 0; i < this.tableCells.size(); ++i) {
            if (this.tableCells.get(i).getCTTc() != cTTc) continue;
            return this.tableCells.get(i);
        }
        return null;
    }

    public boolean isCantSplitRow() {
        boolean bl = false;
        CTTrPr cTTrPr = this.getTrPr();
        if (cTTrPr.sizeOfCantSplitArray() > 0) {
            CTOnOff cTOnOff = cTTrPr.getCantSplitArray(0);
            bl = cTOnOff.getVal().equals(STOnOff.ON);
        }
        return bl;
    }

    public void setCantSplitRow(boolean bl) {
        CTTrPr cTTrPr = this.getTrPr();
        CTOnOff cTOnOff = cTTrPr.addNewCantSplit();
        cTOnOff.setVal(bl ? STOnOff.ON : STOnOff.OFF);
    }

    public boolean isRepeatHeader() {
        boolean bl = false;
        CTTrPr cTTrPr = this.getTrPr();
        if (cTTrPr.sizeOfTblHeaderArray() > 0) {
            CTOnOff cTOnOff = cTTrPr.getTblHeaderArray(0);
            bl = cTOnOff.getVal().equals(STOnOff.ON);
        }
        return bl;
    }

    public void setRepeatHeader(boolean bl) {
        CTTrPr cTTrPr = this.getTrPr();
        CTOnOff cTOnOff = cTTrPr.addNewTblHeader();
        cTOnOff.setVal(bl ? STOnOff.ON : STOnOff.OFF);
    }
}

