/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.ICell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFTableCell
implements IBody,
ICell {
    private static EnumMap<XWPFVertAlign, STVerticalJc.Enum> alignMap = new EnumMap(XWPFVertAlign.class);
    private static HashMap<Integer, XWPFVertAlign> stVertAlignTypeMap;
    private final CTTc ctTc;
    protected List<XWPFParagraph> paragraphs = null;
    protected List<XWPFTable> tables = null;
    protected List<IBodyElement> bodyElements = null;
    protected IBody part;
    private XWPFTableRow tableRow = null;

    public XWPFTableCell(CTTc cTTc, XWPFTableRow xWPFTableRow, IBody iBody) {
        this.ctTc = cTTc;
        this.part = iBody;
        this.tableRow = xWPFTableRow;
        if (cTTc.sizeOfPArray() < 1) {
            cTTc.addNewP();
        }
        this.bodyElements = new ArrayList<IBodyElement>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        XmlCursor xmlCursor = this.ctTc.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            IBodyElement iBodyElement;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTP) {
                iBodyElement = new XWPFParagraph((CTP)xmlObject, this);
                this.paragraphs.add((XWPFParagraph)iBodyElement);
                this.bodyElements.add(iBodyElement);
            }
            if (xmlObject instanceof CTTbl) {
                iBodyElement = new XWPFTable((CTTbl)xmlObject, this);
                this.tables.add((XWPFTable)iBodyElement);
                this.bodyElements.add(iBodyElement);
            }
            if (xmlObject instanceof CTSdtBlock) {
                iBodyElement = new XWPFSDT((CTSdtBlock)xmlObject, (IBody)this);
                this.bodyElements.add(iBodyElement);
            }
            if (!(xmlObject instanceof CTSdtRun)) continue;
            iBodyElement = new XWPFSDT((CTSdtRun)xmlObject, (IBody)this);
            System.out.println(((XWPFSDT)iBodyElement).getContent().getText());
            this.bodyElements.add(iBodyElement);
        }
        xmlCursor.dispose();
    }

    @Internal
    public CTTc getCTTc() {
        return this.ctTc;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void setParagraph(XWPFParagraph xWPFParagraph) {
        if (this.ctTc.sizeOfPArray() == 0) {
            this.ctTc.addNewP();
        }
        this.ctTc.setPArray(0, xWPFParagraph.getCTP());
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public XWPFParagraph addParagraph() {
        XWPFParagraph xWPFParagraph = new XWPFParagraph(this.ctTc.addNewP(), this);
        this.addParagraph(xWPFParagraph);
        return xWPFParagraph;
    }

    public void addParagraph(XWPFParagraph xWPFParagraph) {
        this.paragraphs.add(xWPFParagraph);
    }

    public void removeParagraph(int n) {
        this.paragraphs.remove(n);
        this.ctTc.removeP(n);
    }

    @Override
    public XWPFParagraph getParagraph(CTP cTP) {
        for (XWPFParagraph xWPFParagraph : this.paragraphs) {
            if (!cTP.equals(xWPFParagraph.getCTP())) continue;
            return xWPFParagraph;
        }
        return null;
    }

    public XWPFTableRow getTableRow() {
        return this.tableRow;
    }

    public String getColor() {
        CTShd cTShd;
        String string = null;
        CTTcPr cTTcPr = this.ctTc.getTcPr();
        if (cTTcPr != null && (cTShd = cTTcPr.getShd()) != null) {
            string = cTShd.xgetFill().getStringValue();
        }
        return string;
    }

    public void setColor(String string) {
        CTTcPr cTTcPr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTShd cTShd = cTTcPr.isSetShd() ? cTTcPr.getShd() : cTTcPr.addNewShd();
        cTShd.setColor((Object)"auto");
        cTShd.setVal(STShd.CLEAR);
        cTShd.setFill((Object)string);
    }

    public XWPFVertAlign getVerticalAlignment() {
        XWPFVertAlign xWPFVertAlign = null;
        CTTcPr cTTcPr = this.ctTc.getTcPr();
        if (this.ctTc != null) {
            CTVerticalJc cTVerticalJc = cTTcPr.getVAlign();
            xWPFVertAlign = stVertAlignTypeMap.get(cTVerticalJc.getVal().intValue());
        }
        return xWPFVertAlign;
    }

    public void setVerticalAlignment(XWPFVertAlign xWPFVertAlign) {
        CTTcPr cTTcPr = this.ctTc.isSetTcPr() ? this.ctTc.getTcPr() : this.ctTc.addNewTcPr();
        CTVerticalJc cTVerticalJc = cTTcPr.addNewVAlign();
        cTVerticalJc.setVal(alignMap.get((Object)xWPFVertAlign));
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor xmlCursor) {
        int n;
        if (!this.isCursorInTableCell(xmlCursor)) {
            return null;
        }
        String string = CTP.type.getName().getNamespaceURI();
        String string2 = "p";
        xmlCursor.beginElement(string2, string);
        xmlCursor.toParent();
        CTP cTP = (CTP)xmlCursor.getObject();
        XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, this);
        XmlObject xmlObject = null;
        while (!(xmlObject instanceof CTP) && xmlCursor.toPrevSibling()) {
            xmlObject = xmlCursor.getObject();
        }
        if (!(xmlObject instanceof CTP) || (CTP)xmlObject == cTP) {
            this.paragraphs.add(0, xWPFParagraph);
        } else {
            n = this.paragraphs.indexOf(this.getParagraph((CTP)xmlObject)) + 1;
            this.paragraphs.add(n, xWPFParagraph);
        }
        n = 0;
        xmlCursor.toCursor(cTP.newCursor());
        while (xmlCursor.toPrevSibling()) {
            xmlObject = xmlCursor.getObject();
            if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
            ++n;
        }
        this.bodyElements.add(n, xWPFParagraph);
        xmlCursor.toCursor(cTP.newCursor());
        xmlCursor.toEndToken();
        return xWPFParagraph;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor xmlCursor) {
        if (this.isCursorInTableCell(xmlCursor)) {
            int n;
            String string = CTTbl.type.getName().getNamespaceURI();
            String string2 = "tbl";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTTbl cTTbl = (CTTbl)xmlCursor.getObject();
            XWPFTable xWPFTable = new XWPFTable(cTTbl, this);
            xmlCursor.removeXmlContents();
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTTbl) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTTbl)) {
                this.tables.add(0, xWPFTable);
            } else {
                n = this.tables.indexOf(this.getTable((CTTbl)xmlObject)) + 1;
                this.tables.add(n, xWPFTable);
            }
            n = 0;
            xmlCursor = cTTbl.newCursor();
            while (xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                ++n;
            }
            this.bodyElements.add(n, xWPFTable);
            xmlCursor = cTTbl.newCursor();
            xmlCursor.toEndToken();
            return xWPFTable;
        }
        return null;
    }

    private boolean isCursorInTableCell(XmlCursor xmlCursor) {
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        xmlCursor2.toParent();
        return xmlCursor2.getObject() == this.ctTc;
    }

    @Override
    public XWPFParagraph getParagraphArray(int n) {
        if (n > 0 && n < this.paragraphs.size()) {
            return this.paragraphs.get(n);
        }
        return null;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this.tableRow.getTable().getPart();
    }

    @Override
    public BodyType getPartType() {
        return BodyType.TABLECELL;
    }

    @Override
    public XWPFTable getTable(CTTbl cTTbl) {
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.getTables().get(i).getCTTbl() != cTTbl) continue;
            return this.getTables().get(i);
        }
        return null;
    }

    @Override
    public XWPFTable getTableArray(int n) {
        if (n > 0 && n < this.tables.size()) {
            return this.tables.get(n);
        }
        return null;
    }

    @Override
    public List<XWPFTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void insertTable(int n, XWPFTable xWPFTable) {
        this.bodyElements.add(n, xWPFTable);
        int n2 = 0;
        for (CTTbl cTTbl : this.ctTc.getTblArray()) {
            if (cTTbl == xWPFTable.getCTTbl()) break;
            ++n2;
        }
        this.tables.add(n2, xWPFTable);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (XWPFParagraph xWPFParagraph : this.paragraphs) {
            stringBuffer.append(xWPFParagraph.getText());
        }
        return stringBuffer.toString();
    }

    public void setText(String string) {
        CTP cTP = this.ctTc.sizeOfPArray() == 0 ? this.ctTc.addNewP() : this.ctTc.getPArray(0);
        XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, this);
        xWPFParagraph.createRun().setText(string);
    }

    public String getTextRecursively() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            boolean bl = i == this.bodyElements.size() - 1;
            this.appendBodyElementText(stringBuffer, this.bodyElements.get(i), bl);
        }
        return stringBuffer.toString();
    }

    private void appendBodyElementText(StringBuffer stringBuffer, IBodyElement iBodyElement, boolean bl) {
        if (iBodyElement instanceof XWPFParagraph) {
            stringBuffer.append(((XWPFParagraph)iBodyElement).getText());
            if (!bl) {
                stringBuffer.append('\t');
            }
        } else if (iBodyElement instanceof XWPFTable) {
            XWPFTable xWPFTable = (XWPFTable)iBodyElement;
            for (XWPFTableRow xWPFTableRow : xWPFTable.getRows()) {
                for (XWPFTableCell xWPFTableCell : xWPFTableRow.getTableCells()) {
                    List<IBodyElement> list = xWPFTableCell.getBodyElements();
                    for (int i = 0; i < list.size(); ++i) {
                        boolean bl2 = i == list.size() - 1;
                        this.appendBodyElementText(stringBuffer, list.get(i), bl2);
                    }
                }
            }
            if (!bl) {
                stringBuffer.append('\n');
            }
        } else if (iBodyElement instanceof XWPFSDT) {
            stringBuffer.append(((XWPFSDT)iBodyElement).getContent().getText());
            if (!bl) {
                stringBuffer.append('\t');
            }
        }
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cTTc) {
        XmlCursor xmlCursor = cTTc.newCursor();
        xmlCursor.toParent();
        XmlObject xmlObject = xmlCursor.getObject();
        if (!(xmlObject instanceof CTRow)) {
            return null;
        }
        CTRow cTRow = (CTRow)xmlObject;
        xmlCursor.toParent();
        xmlObject = xmlCursor.getObject();
        xmlCursor.dispose();
        if (!(xmlObject instanceof CTTbl)) {
            return null;
        }
        CTTbl cTTbl = (CTTbl)xmlObject;
        XWPFTable xWPFTable = this.getTable(cTTbl);
        if (xWPFTable == null) {
            return null;
        }
        XWPFTableRow xWPFTableRow = xWPFTable.getRow(cTRow);
        if (xWPFTableRow == null) {
            return null;
        }
        return xWPFTableRow.getTableCell(cTTc);
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this.part.getXWPFDocument();
    }

    static {
        alignMap.put(XWPFVertAlign.TOP, STVerticalJc.Enum.forInt((int)1));
        alignMap.put(XWPFVertAlign.CENTER, STVerticalJc.Enum.forInt((int)2));
        alignMap.put(XWPFVertAlign.BOTH, STVerticalJc.Enum.forInt((int)3));
        alignMap.put(XWPFVertAlign.BOTTOM, STVerticalJc.Enum.forInt((int)4));
        stVertAlignTypeMap = new HashMap();
        stVertAlignTypeMap.put(1, XWPFVertAlign.TOP);
        stVertAlignTypeMap.put(2, XWPFVertAlign.CENTER);
        stVertAlignTypeMap.put(3, XWPFVertAlign.BOTH);
        stVertAlignTypeMap.put(4, XWPFVertAlign.BOTTOM);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XWPFVertAlign {
        TOP,
        CENTER,
        BOTH,
        BOTTOM;

    }
}

