/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xwpf.usermodel.BodyElementType;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContents;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFTable
implements IBodyElement,
ISDTContents {
    private static EnumMap<XWPFBorderType, STBorder.Enum> xwpfBorderTypeMap = new EnumMap(XWPFBorderType.class);
    private static HashMap<Integer, XWPFBorderType> stBorderTypeMap;
    protected StringBuffer text = new StringBuffer();
    protected List<XWPFTableRow> tableRows;
    protected List<String> styleIDs;
    protected IBody part;
    private CTTbl ctTbl;

    public XWPFTable(CTTbl cTTbl, IBody iBody, int n, int n2) {
        this(cTTbl, iBody);
        for (int i = 0; i < n; ++i) {
            XWPFTableRow xWPFTableRow = this.getRow(i) == null ? this.createRow() : this.getRow(i);
            for (int j = 0; j < n2; ++j) {
                if (xWPFTableRow.getCell(j) != null) continue;
                xWPFTableRow.createCell();
            }
        }
    }

    public XWPFTable(CTTbl cTTbl, IBody iBody) {
        this.part = iBody;
        this.ctTbl = cTTbl;
        this.tableRows = new ArrayList<XWPFTableRow>();
        if (cTTbl.sizeOfTrArray() == 0) {
            this.createEmptyTable(cTTbl);
        }
        for (CTRow cTRow : cTTbl.getTrArray()) {
            StringBuilder stringBuilder = new StringBuilder();
            XWPFTableRow xWPFTableRow = new XWPFTableRow(cTRow, this);
            this.tableRows.add(xWPFTableRow);
            for (CTTc cTTc : cTRow.getTcArray()) {
                for (CTP cTP : cTTc.getPArray()) {
                    XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, iBody);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\t');
                    }
                    stringBuilder.append(xWPFParagraph.getText());
                }
            }
            if (stringBuilder.length() <= 0) continue;
            this.text.append((CharSequence)stringBuilder);
            this.text.append('\n');
        }
    }

    private void createEmptyTable(CTTbl cTTbl) {
        cTTbl.addNewTr().addNewTc().addNewP();
        CTTblPr cTTblPr = cTTbl.addNewTblPr();
        cTTblPr.addNewTblW().setW(new BigInteger("0"));
        cTTblPr.getTblW().setType(STTblWidth.AUTO);
        CTTblBorders cTTblBorders = cTTblPr.addNewTblBorders();
        cTTblBorders.addNewBottom().setVal(STBorder.SINGLE);
        cTTblBorders.addNewInsideH().setVal(STBorder.SINGLE);
        cTTblBorders.addNewInsideV().setVal(STBorder.SINGLE);
        cTTblBorders.addNewLeft().setVal(STBorder.SINGLE);
        cTTblBorders.addNewRight().setVal(STBorder.SINGLE);
        cTTblBorders.addNewTop().setVal(STBorder.SINGLE);
        this.getRows();
    }

    @Internal
    public CTTbl getCTTbl() {
        return this.ctTbl;
    }

    public String getText() {
        return this.text.toString();
    }

    public void addNewRowBetween(int n, int n2) {
    }

    public void addNewCol() {
        if (this.ctTbl.sizeOfTrArray() == 0) {
            this.createRow();
        }
        for (int i = 0; i < this.ctTbl.sizeOfTrArray(); ++i) {
            XWPFTableRow xWPFTableRow = new XWPFTableRow(this.ctTbl.getTrArray(i), this);
            xWPFTableRow.createCell();
        }
    }

    public XWPFTableRow createRow() {
        int n = this.ctTbl.sizeOfTrArray() > 0 ? this.ctTbl.getTrArray(0).sizeOfTcArray() : 0;
        XWPFTableRow xWPFTableRow = new XWPFTableRow(this.ctTbl.addNewTr(), this);
        this.addColumn(xWPFTableRow, n);
        this.tableRows.add(xWPFTableRow);
        return xWPFTableRow;
    }

    public XWPFTableRow getRow(int n) {
        if (n >= 0 && n < this.ctTbl.sizeOfTrArray()) {
            return this.getRows().get(n);
        }
        return null;
    }

    public int getWidth() {
        CTTblPr cTTblPr = this.getTrPr();
        return cTTblPr.isSetTblW() ? cTTblPr.getTblW().getW().intValue() : -1;
    }

    public void setWidth(int n) {
        CTTblPr cTTblPr = this.getTrPr();
        CTTblWidth cTTblWidth = cTTblPr.isSetTblW() ? cTTblPr.getTblW() : cTTblPr.addNewTblW();
        cTTblWidth.setW(new BigInteger("" + n));
    }

    public int getNumberOfRows() {
        return this.ctTbl.sizeOfTrArray();
    }

    private CTTblPr getTrPr() {
        return this.ctTbl.getTblPr() != null ? this.ctTbl.getTblPr() : this.ctTbl.addNewTblPr();
    }

    private void addColumn(XWPFTableRow xWPFTableRow, int n) {
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                xWPFTableRow.createCell();
            }
        }
    }

    public String getStyleID() {
        CTString cTString;
        String string = null;
        CTTblPr cTTblPr = this.ctTbl.getTblPr();
        if (cTTblPr != null && (cTString = cTTblPr.getTblStyle()) != null) {
            string = cTString.getVal();
        }
        return string;
    }

    public void setStyleID(String string) {
        CTTblPr cTTblPr = this.getTrPr();
        CTString cTString = cTTblPr.getTblStyle();
        if (cTString == null) {
            cTString = cTTblPr.addNewTblStyle();
        }
        cTString.setVal(string);
    }

    public XWPFBorderType getInsideHBorderType() {
        CTTblBorders cTTblBorders;
        XWPFBorderType xWPFBorderType = null;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideH()) {
            CTBorder cTBorder = cTTblBorders.getInsideH();
            xWPFBorderType = stBorderTypeMap.get(cTBorder.getVal().intValue());
        }
        return xWPFBorderType;
    }

    public int getInsideHBorderSize() {
        CTTblBorders cTTblBorders;
        int n = -1;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideH()) {
            CTBorder cTBorder = cTTblBorders.getInsideH();
            n = cTBorder.getSz().intValue();
        }
        return n;
    }

    public int getInsideHBorderSpace() {
        CTTblBorders cTTblBorders;
        int n = -1;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideH()) {
            CTBorder cTBorder = cTTblBorders.getInsideH();
            n = cTBorder.getSpace().intValue();
        }
        return n;
    }

    public String getInsideHBorderColor() {
        CTTblBorders cTTblBorders;
        String string = null;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideH()) {
            CTBorder cTBorder = cTTblBorders.getInsideH();
            string = cTBorder.xgetColor().getStringValue();
        }
        return string;
    }

    public XWPFBorderType getInsideVBorderType() {
        CTTblBorders cTTblBorders;
        XWPFBorderType xWPFBorderType = null;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideV()) {
            CTBorder cTBorder = cTTblBorders.getInsideV();
            xWPFBorderType = stBorderTypeMap.get(cTBorder.getVal().intValue());
        }
        return xWPFBorderType;
    }

    public int getInsideVBorderSize() {
        CTTblBorders cTTblBorders;
        int n = -1;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideV()) {
            CTBorder cTBorder = cTTblBorders.getInsideV();
            n = cTBorder.getSz().intValue();
        }
        return n;
    }

    public int getInsideVBorderSpace() {
        CTTblBorders cTTblBorders;
        int n = -1;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideV()) {
            CTBorder cTBorder = cTTblBorders.getInsideV();
            n = cTBorder.getSpace().intValue();
        }
        return n;
    }

    public String getInsideVBorderColor() {
        CTTblBorders cTTblBorders;
        String string = null;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblBorders() && (cTTblBorders = cTTblPr.getTblBorders()).isSetInsideV()) {
            CTBorder cTBorder = cTTblBorders.getInsideV();
            string = cTBorder.xgetColor().getStringValue();
        }
        return string;
    }

    public int getRowBandSize() {
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblStyleRowBandSize()) {
            CTDecimalNumber cTDecimalNumber = cTTblPr.getTblStyleRowBandSize();
            n = cTDecimalNumber.getVal().intValue();
        }
        return n;
    }

    public void setRowBandSize(int n) {
        CTTblPr cTTblPr = this.getTrPr();
        CTDecimalNumber cTDecimalNumber = cTTblPr.isSetTblStyleRowBandSize() ? cTTblPr.getTblStyleRowBandSize() : cTTblPr.addNewTblStyleRowBandSize();
        cTDecimalNumber.setVal(BigInteger.valueOf(n));
    }

    public int getColBandSize() {
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        if (cTTblPr.isSetTblStyleColBandSize()) {
            CTDecimalNumber cTDecimalNumber = cTTblPr.getTblStyleColBandSize();
            n = cTDecimalNumber.getVal().intValue();
        }
        return n;
    }

    public void setColBandSize(int n) {
        CTTblPr cTTblPr = this.getTrPr();
        CTDecimalNumber cTDecimalNumber = cTTblPr.isSetTblStyleColBandSize() ? cTTblPr.getTblStyleColBandSize() : cTTblPr.addNewTblStyleColBandSize();
        cTDecimalNumber.setVal(BigInteger.valueOf(n));
    }

    public void setInsideHBorder(XWPFBorderType xWPFBorderType, int n, int n2, String string) {
        CTTblPr cTTblPr = this.getTrPr();
        CTTblBorders cTTblBorders = cTTblPr.isSetTblBorders() ? cTTblPr.getTblBorders() : cTTblPr.addNewTblBorders();
        CTBorder cTBorder = cTTblBorders.isSetInsideH() ? cTTblBorders.getInsideH() : cTTblBorders.addNewInsideH();
        cTBorder.setVal(xwpfBorderTypeMap.get((Object)xWPFBorderType));
        cTBorder.setSz(BigInteger.valueOf(n));
        cTBorder.setSpace(BigInteger.valueOf(n2));
        cTBorder.setColor((Object)string);
    }

    public void setInsideVBorder(XWPFBorderType xWPFBorderType, int n, int n2, String string) {
        CTTblPr cTTblPr = this.getTrPr();
        CTTblBorders cTTblBorders = cTTblPr.isSetTblBorders() ? cTTblPr.getTblBorders() : cTTblPr.addNewTblBorders();
        CTBorder cTBorder = cTTblBorders.isSetInsideV() ? cTTblBorders.getInsideV() : cTTblBorders.addNewInsideV();
        cTBorder.setVal(xwpfBorderTypeMap.get((Object)xWPFBorderType));
        cTBorder.setSz(BigInteger.valueOf(n));
        cTBorder.setSpace(BigInteger.valueOf(n2));
        cTBorder.setColor((Object)string);
    }

    public int getCellMarginTop() {
        CTTblWidth cTTblWidth;
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        CTTblCellMar cTTblCellMar = cTTblPr.getTblCellMar();
        if (cTTblCellMar != null && (cTTblWidth = cTTblCellMar.getTop()) != null) {
            n = cTTblWidth.getW().intValue();
        }
        return n;
    }

    public int getCellMarginLeft() {
        CTTblWidth cTTblWidth;
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        CTTblCellMar cTTblCellMar = cTTblPr.getTblCellMar();
        if (cTTblCellMar != null && (cTTblWidth = cTTblCellMar.getLeft()) != null) {
            n = cTTblWidth.getW().intValue();
        }
        return n;
    }

    public int getCellMarginBottom() {
        CTTblWidth cTTblWidth;
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        CTTblCellMar cTTblCellMar = cTTblPr.getTblCellMar();
        if (cTTblCellMar != null && (cTTblWidth = cTTblCellMar.getBottom()) != null) {
            n = cTTblWidth.getW().intValue();
        }
        return n;
    }

    public int getCellMarginRight() {
        CTTblWidth cTTblWidth;
        int n = 0;
        CTTblPr cTTblPr = this.getTrPr();
        CTTblCellMar cTTblCellMar = cTTblPr.getTblCellMar();
        if (cTTblCellMar != null && (cTTblWidth = cTTblCellMar.getRight()) != null) {
            n = cTTblWidth.getW().intValue();
        }
        return n;
    }

    public void setCellMargins(int n, int n2, int n3, int n4) {
        CTTblPr cTTblPr = this.getTrPr();
        CTTblCellMar cTTblCellMar = cTTblPr.isSetTblCellMar() ? cTTblPr.getTblCellMar() : cTTblPr.addNewTblCellMar();
        CTTblWidth cTTblWidth = cTTblCellMar.isSetLeft() ? cTTblCellMar.getLeft() : cTTblCellMar.addNewLeft();
        cTTblWidth.setType(STTblWidth.DXA);
        cTTblWidth.setW(BigInteger.valueOf(n2));
        cTTblWidth = cTTblCellMar.isSetTop() ? cTTblCellMar.getTop() : cTTblCellMar.addNewTop();
        cTTblWidth.setType(STTblWidth.DXA);
        cTTblWidth.setW(BigInteger.valueOf(n));
        cTTblWidth = cTTblCellMar.isSetBottom() ? cTTblCellMar.getBottom() : cTTblCellMar.addNewBottom();
        cTTblWidth.setType(STTblWidth.DXA);
        cTTblWidth.setW(BigInteger.valueOf(n3));
        cTTblWidth = cTTblCellMar.isSetRight() ? cTTblCellMar.getRight() : cTTblCellMar.addNewRight();
        cTTblWidth.setType(STTblWidth.DXA);
        cTTblWidth.setW(BigInteger.valueOf(n4));
    }

    public void addRow(XWPFTableRow xWPFTableRow) {
        this.ctTbl.addNewTr();
        this.ctTbl.setTrArray(this.getNumberOfRows() - 1, xWPFTableRow.getCtRow());
        this.tableRows.add(xWPFTableRow);
    }

    public boolean addRow(XWPFTableRow xWPFTableRow, int n) {
        if (n >= 0 && n <= this.tableRows.size()) {
            this.ctTbl.insertNewTr(n);
            this.ctTbl.setTrArray(n, xWPFTableRow.getCtRow());
            this.tableRows.add(n, xWPFTableRow);
            return true;
        }
        return false;
    }

    public XWPFTableRow insertNewTableRow(int n) {
        if (n >= 0 && n <= this.tableRows.size()) {
            CTRow cTRow = this.ctTbl.insertNewTr(n);
            XWPFTableRow xWPFTableRow = new XWPFTableRow(cTRow, this);
            this.tableRows.add(n, xWPFTableRow);
            return xWPFTableRow;
        }
        return null;
    }

    public boolean removeRow(int n) throws IndexOutOfBoundsException {
        if (n >= 0 && n < this.tableRows.size()) {
            if (this.ctTbl.sizeOfTrArray() > 0) {
                this.ctTbl.removeTr(n);
            }
            this.tableRows.remove(n);
            return true;
        }
        return false;
    }

    public List<XWPFTableRow> getRows() {
        return this.tableRows;
    }

    @Override
    public BodyElementType getElementType() {
        return BodyElementType.TABLE;
    }

    @Override
    public IBody getBody() {
        return this.part;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    @Override
    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public XWPFTableRow getRow(CTRow cTRow) {
        for (int i = 0; i < this.getRows().size(); ++i) {
            if (this.getRows().get(i).getCtRow() != cTRow) continue;
            return this.getRow(i);
        }
        return null;
    }

    static {
        xwpfBorderTypeMap.put(XWPFBorderType.NIL, STBorder.Enum.forInt((int)1));
        xwpfBorderTypeMap.put(XWPFBorderType.NONE, STBorder.Enum.forInt((int)2));
        xwpfBorderTypeMap.put(XWPFBorderType.SINGLE, STBorder.Enum.forInt((int)3));
        xwpfBorderTypeMap.put(XWPFBorderType.THICK, STBorder.Enum.forInt((int)4));
        xwpfBorderTypeMap.put(XWPFBorderType.DOUBLE, STBorder.Enum.forInt((int)5));
        xwpfBorderTypeMap.put(XWPFBorderType.DOTTED, STBorder.Enum.forInt((int)6));
        xwpfBorderTypeMap.put(XWPFBorderType.DASHED, STBorder.Enum.forInt((int)7));
        xwpfBorderTypeMap.put(XWPFBorderType.DOT_DASH, STBorder.Enum.forInt((int)8));
        stBorderTypeMap = new HashMap();
        stBorderTypeMap.put(1, XWPFBorderType.NIL);
        stBorderTypeMap.put(2, XWPFBorderType.NONE);
        stBorderTypeMap.put(3, XWPFBorderType.SINGLE);
        stBorderTypeMap.put(4, XWPFBorderType.THICK);
        stBorderTypeMap.put(5, XWPFBorderType.DOUBLE);
        stBorderTypeMap.put(6, XWPFBorderType.DOTTED);
        stBorderTypeMap.put(7, XWPFBorderType.DASHED);
        stBorderTypeMap.put(8, XWPFBorderType.DOT_DASH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XWPFBorderType {
        NIL,
        NONE,
        SINGLE,
        THICK,
        DOUBLE,
        DOTTED,
        DASHED,
        DOT_DASH;

    }
}

