/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTZoom;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STAlgClass;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STAlgType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STCryptProv;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.SettingsDocument;

public class XWPFSettings
extends POIXMLDocumentPart {
    public CTSettings ctSettings;

    public XWPFSettings(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
    }

    public XWPFSettings() {
        this.ctSettings = CTSettings.Factory.newInstance();
    }

    protected void onDocumentRead() throws IOException {
        super.onDocumentRead();
        this.readFrom(this.getPackagePart().getInputStream());
    }

    public long getZoomPercent() {
        CTZoom cTZoom = !this.ctSettings.isSetZoom() ? this.ctSettings.addNewZoom() : this.ctSettings.getZoom();
        BigInteger bigInteger = cTZoom.getPercent();
        if (bigInteger == null) {
            return 100L;
        }
        return bigInteger.longValue();
    }

    public void setZoomPercent(long l) {
        if (!this.ctSettings.isSetZoom()) {
            this.ctSettings.addNewZoom();
        }
        CTZoom cTZoom = this.ctSettings.getZoom();
        cTZoom.setPercent(BigInteger.valueOf(l));
    }

    public boolean isEnforcedWith(STDocProtect.Enum enum_) {
        CTDocProtect cTDocProtect = this.ctSettings.getDocumentProtection();
        if (cTDocProtect == null) {
            return false;
        }
        return cTDocProtect.getEnforcement().equals(STOnOff.X_1) && cTDocProtect.getEdit().equals(enum_);
    }

    public void setEnforcementEditValue(STDocProtect.Enum enum_) {
        this.safeGetDocumentProtection().setEnforcement(STOnOff.X_1);
        this.safeGetDocumentProtection().setEdit(enum_);
    }

    public void setEnforcementEditValue(STDocProtect.Enum enum_, String string, HashAlgorithm hashAlgorithm) {
        this.safeGetDocumentProtection().setEnforcement(STOnOff.X_1);
        this.safeGetDocumentProtection().setEdit(enum_);
        if (string == null) {
            if (this.safeGetDocumentProtection().isSetCryptProviderType()) {
                this.safeGetDocumentProtection().unsetCryptProviderType();
            }
            if (this.safeGetDocumentProtection().isSetCryptAlgorithmClass()) {
                this.safeGetDocumentProtection().unsetCryptAlgorithmClass();
            }
            if (this.safeGetDocumentProtection().isSetCryptAlgorithmType()) {
                this.safeGetDocumentProtection().unsetCryptAlgorithmType();
            }
            if (this.safeGetDocumentProtection().isSetCryptAlgorithmSid()) {
                this.safeGetDocumentProtection().unsetCryptAlgorithmSid();
            }
            if (this.safeGetDocumentProtection().isSetSalt()) {
                this.safeGetDocumentProtection().unsetSalt();
            }
            if (this.safeGetDocumentProtection().isSetCryptSpinCount()) {
                this.safeGetDocumentProtection().unsetCryptSpinCount();
            }
            if (this.safeGetDocumentProtection().isSetHash()) {
                this.safeGetDocumentProtection().unsetHash();
            }
        } else {
            int n;
            STCryptProv.Enum enum_2;
            if (hashAlgorithm == null) {
                hashAlgorithm = HashAlgorithm.sha1;
            }
            switch (hashAlgorithm) {
                case md2: {
                    enum_2 = STCryptProv.RSA_FULL;
                    n = 1;
                    break;
                }
                case md4: {
                    enum_2 = STCryptProv.RSA_FULL;
                    n = 2;
                    break;
                }
                case md5: {
                    enum_2 = STCryptProv.RSA_FULL;
                    n = 3;
                    break;
                }
                case sha1: {
                    enum_2 = STCryptProv.RSA_FULL;
                    n = 4;
                    break;
                }
                case sha256: {
                    enum_2 = STCryptProv.RSA_AES;
                    n = 12;
                    break;
                }
                case sha384: {
                    enum_2 = STCryptProv.RSA_AES;
                    n = 13;
                    break;
                }
                case sha512: {
                    enum_2 = STCryptProv.RSA_AES;
                    n = 14;
                    break;
                }
                default: {
                    throw new EncryptedDocumentException("Hash algorithm '" + (Object)((Object)hashAlgorithm) + "' is not supported for document write protection.");
                }
            }
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = secureRandom.generateSeed(16);
            int n2 = 100000;
            String string2 = CryptoFunctions.xorHashPasswordReversed(string);
            byte[] byArray2 = CryptoFunctions.hashPassword(string2, hashAlgorithm, byArray, n2, false);
            this.safeGetDocumentProtection().setSalt(byArray);
            this.safeGetDocumentProtection().setHash(byArray2);
            this.safeGetDocumentProtection().setCryptSpinCount(BigInteger.valueOf(n2));
            this.safeGetDocumentProtection().setCryptAlgorithmType(STAlgType.TYPE_ANY);
            this.safeGetDocumentProtection().setCryptAlgorithmClass(STAlgClass.HASH);
            this.safeGetDocumentProtection().setCryptProviderType(enum_2);
            this.safeGetDocumentProtection().setCryptAlgorithmSid(BigInteger.valueOf(n));
        }
    }

    public boolean validateProtectionPassword(String string) {
        HashAlgorithm hashAlgorithm;
        BigInteger bigInteger = this.safeGetDocumentProtection().getCryptAlgorithmSid();
        byte[] byArray = this.safeGetDocumentProtection().getHash();
        byte[] byArray2 = this.safeGetDocumentProtection().getSalt();
        BigInteger bigInteger2 = this.safeGetDocumentProtection().getCryptSpinCount();
        if (bigInteger == null || byArray == null || byArray2 == null || bigInteger2 == null) {
            return false;
        }
        switch (bigInteger.intValue()) {
            case 1: {
                hashAlgorithm = HashAlgorithm.md2;
                break;
            }
            case 2: {
                hashAlgorithm = HashAlgorithm.md4;
                break;
            }
            case 3: {
                hashAlgorithm = HashAlgorithm.md5;
                break;
            }
            case 4: {
                hashAlgorithm = HashAlgorithm.sha1;
                break;
            }
            case 12: {
                hashAlgorithm = HashAlgorithm.sha256;
                break;
            }
            case 13: {
                hashAlgorithm = HashAlgorithm.sha384;
                break;
            }
            case 14: {
                hashAlgorithm = HashAlgorithm.sha512;
                break;
            }
            default: {
                return false;
            }
        }
        String string2 = CryptoFunctions.xorHashPasswordReversed(string);
        byte[] byArray3 = CryptoFunctions.hashPassword(string2, hashAlgorithm, byArray2, bigInteger2.intValue(), false);
        return Arrays.equals(byArray, byArray3);
    }

    public void removeEnforcement() {
        this.safeGetDocumentProtection().setEnforcement(STOnOff.X_0);
    }

    public void setUpdateFields() {
        CTOnOff cTOnOff = CTOnOff.Factory.newInstance();
        cTOnOff.setVal(STOnOff.TRUE);
        this.ctSettings.setUpdateFields(cTOnOff);
    }

    boolean isUpdateFields() {
        return this.ctSettings.isSetUpdateFields() && this.ctSettings.getUpdateFields().getVal() == STOnOff.TRUE;
    }

    public boolean isTrackRevisions() {
        return this.ctSettings.isSetTrackRevisions();
    }

    public void setTrackRevisions(boolean bl) {
        if (bl) {
            if (!this.ctSettings.isSetTrackRevisions()) {
                this.ctSettings.addNewTrackRevisions();
            }
        } else if (this.ctSettings.isSetTrackRevisions()) {
            this.ctSettings.unsetTrackRevisions();
        }
    }

    protected void commit() throws IOException {
        if (this.ctSettings == null) {
            throw new IllegalStateException("Unable to write out settings that were never read in!");
        }
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTSettings.type.getName().getNamespaceURI(), "settings"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.ctSettings.save(outputStream, xmlOptions);
        outputStream.close();
    }

    private CTDocProtect safeGetDocumentProtection() {
        CTDocProtect cTDocProtect = this.ctSettings.getDocumentProtection();
        if (cTDocProtect == null) {
            cTDocProtect = CTDocProtect.Factory.newInstance();
            this.ctSettings.setDocumentProtection(cTDocProtect);
        }
        return this.ctSettings.getDocumentProtection();
    }

    private void readFrom(InputStream inputStream) {
        try {
            this.ctSettings = SettingsDocument.Factory.parse((InputStream)inputStream).getSettings();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

