/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.ICell;
import ai2.org.apache.poi.xwpf.usermodel.IRunBody;
import ai2.org.apache.poi.xwpf.usermodel.IRunElement;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContent;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContents;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRun;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;

public class XWPFSDTContent
implements ISDTContent {
    private List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    private List<XWPFTable> tables = new ArrayList<XWPFTable>();
    private List<XWPFRun> runs = new ArrayList<XWPFRun>();
    private List<XWPFSDT> contentControls = new ArrayList<XWPFSDT>();
    private List<ISDTContents> bodyElements = new ArrayList<ISDTContents>();

    public XWPFSDTContent(CTSdtContentRun cTSdtContentRun, IBody iBody, IRunBody iRunBody) {
        for (CTR cTR : cTSdtContentRun.getRArray()) {
            XWPFRun xWPFRun = new XWPFRun(cTR, iRunBody);
            this.runs.add(xWPFRun);
            this.bodyElements.add(xWPFRun);
        }
    }

    public XWPFSDTContent(CTSdtContentBlock cTSdtContentBlock, IBody iBody, IRunBody iRunBody) {
        XmlCursor xmlCursor = cTSdtContentBlock.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            ISDTContents iSDTContents;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTP) {
                iSDTContents = new XWPFParagraph((CTP)xmlObject, iBody);
                this.bodyElements.add(iSDTContents);
                this.paragraphs.add((XWPFParagraph)iSDTContents);
                continue;
            }
            if (xmlObject instanceof CTTbl) {
                iSDTContents = new XWPFTable((CTTbl)xmlObject, iBody);
                this.bodyElements.add(iSDTContents);
                this.tables.add((XWPFTable)iSDTContents);
                continue;
            }
            if (xmlObject instanceof CTSdtBlock) {
                iSDTContents = new XWPFSDT((CTSdtBlock)xmlObject, iBody);
                this.bodyElements.add(iSDTContents);
                this.contentControls.add((XWPFSDT)iSDTContents);
                continue;
            }
            if (!(xmlObject instanceof CTR)) continue;
            iSDTContents = new XWPFRun((CTR)xmlObject, iRunBody);
            this.runs.add((XWPFRun)iSDTContents);
            this.bodyElements.add(iSDTContents);
        }
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            ISDTContents iSDTContents = this.bodyElements.get(i);
            if (iSDTContents instanceof XWPFParagraph) {
                this.appendParagraph((XWPFParagraph)iSDTContents, stringBuilder);
                bl = true;
            } else if (iSDTContents instanceof XWPFTable) {
                this.appendTable((XWPFTable)iSDTContents, stringBuilder);
                bl = true;
            } else if (iSDTContents instanceof XWPFSDT) {
                stringBuilder.append(((XWPFSDT)iSDTContents).getContent().getText());
                bl = true;
            } else if (iSDTContents instanceof XWPFRun) {
                stringBuilder.append(((XWPFRun)iSDTContents).toString());
                bl = false;
            }
            if (!bl || i >= this.bodyElements.size() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void appendTable(XWPFTable xWPFTable, StringBuilder stringBuilder) {
        for (XWPFTableRow xWPFTableRow : xWPFTable.getRows()) {
            List<ICell> list = xWPFTableRow.getTableICells();
            for (int i = 0; i < list.size(); ++i) {
                ICell iCell = list.get(i);
                if (iCell instanceof XWPFTableCell) {
                    stringBuilder.append(((XWPFTableCell)iCell).getTextRecursively());
                } else if (iCell instanceof XWPFSDTCell) {
                    stringBuilder.append(((XWPFSDTCell)iCell).getContent().getText());
                }
                if (i >= list.size() - 1) continue;
                stringBuilder.append("\t");
            }
            stringBuilder.append('\n');
        }
    }

    private void appendParagraph(XWPFParagraph xWPFParagraph, StringBuilder stringBuilder) {
        for (IRunElement iRunElement : xWPFParagraph.getRuns()) {
            stringBuilder.append(iRunElement.toString());
        }
    }

    public String toString() {
        return this.getText();
    }
}

