/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRelation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class XWPFPictureData
extends POIXMLDocumentPart {
    protected static final POIXMLRelation[] RELATIONS = new POIXMLRelation[13];
    private Long checksum = null;

    protected XWPFPictureData() {
    }

    public XWPFPictureData(PackagePart packagePart, PackageRelationship packageRelationship) {
        super(packagePart, packageRelationship);
    }

    protected void onDocumentRead() throws IOException {
        super.onDocumentRead();
    }

    public byte[] getData() {
        try {
            return IOUtils.toByteArray(this.getPackagePart().getInputStream());
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
    }

    public String getFileName() {
        String string = this.getPackagePart().getPartName().getName();
        if (string == null) {
            return null;
        }
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public String suggestFileExtension() {
        return this.getPackagePart().getPartName().getExtension();
    }

    public int getPictureType() {
        String string = this.getPackagePart().getContentType();
        for (int i = 0; i < RELATIONS.length; ++i) {
            if (RELATIONS[i] == null || !RELATIONS[i].getContentType().equals(string)) continue;
            return i;
        }
        return 0;
    }

    public Long getChecksum() {
        if (this.checksum == null) {
            byte[] byArray;
            InputStream inputStream = null;
            try {
                inputStream = this.getPackagePart().getInputStream();
                byArray = IOUtils.toByteArray(inputStream);
            }
            catch (IOException iOException) {
                throw new POIXMLException(iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new POIXMLException(iOException);
                }
            }
            this.checksum = IOUtils.calculateChecksum(byArray);
        }
        return this.checksum;
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof XWPFPictureData)) {
            return false;
        }
        XWPFPictureData xWPFPictureData = (XWPFPictureData)object;
        PackagePart packagePart = xWPFPictureData.getPackagePart();
        PackagePart packagePart2 = this.getPackagePart();
        if (packagePart != null && packagePart2 == null || packagePart == null && packagePart2 != null) {
            return false;
        }
        if (packagePart2 != null) {
            object3 = packagePart.getPackage();
            object2 = packagePart2.getPackage();
            if (object3 != null && object2 == null || object3 == null && object2 != null) {
                return false;
            }
            if (object2 != null && !object2.equals(object3)) {
                return false;
            }
        }
        object3 = xWPFPictureData.getChecksum();
        object2 = this.getChecksum();
        if (!((Long)object2).equals(object3)) {
            return false;
        }
        return Arrays.equals(this.getData(), xWPFPictureData.getData());
    }

    public int hashCode() {
        return this.getChecksum().hashCode();
    }

    protected void prepareForCommit() {
    }

    static {
        XWPFPictureData.RELATIONS[2] = XWPFRelation.IMAGE_EMF;
        XWPFPictureData.RELATIONS[3] = XWPFRelation.IMAGE_WMF;
        XWPFPictureData.RELATIONS[4] = XWPFRelation.IMAGE_PICT;
        XWPFPictureData.RELATIONS[5] = XWPFRelation.IMAGE_JPEG;
        XWPFPictureData.RELATIONS[6] = XWPFRelation.IMAGE_PNG;
        XWPFPictureData.RELATIONS[7] = XWPFRelation.IMAGE_DIB;
        XWPFPictureData.RELATIONS[8] = XWPFRelation.IMAGE_GIF;
        XWPFPictureData.RELATIONS[9] = XWPFRelation.IMAGE_TIFF;
        XWPFPictureData.RELATIONS[10] = XWPFRelation.IMAGE_EPS;
        XWPFPictureData.RELATIONS[11] = XWPFRelation.IMAGE_BMP;
        XWPFPictureData.RELATIONS[12] = XWPFRelation.IMAGE_WPG;
    }
}

