/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPictureData;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;

public class XWPFPicture {
    private CTPicture ctPic;
    private String description;
    private XWPFRun run;

    public XWPFPicture(CTPicture cTPicture, XWPFRun xWPFRun) {
        this.run = xWPFRun;
        this.ctPic = cTPicture;
        this.description = cTPicture.getNvPicPr().getCNvPr().getDescr();
    }

    public void setPictureReference(PackageRelationship packageRelationship) {
        this.ctPic.getBlipFill().getBlip().setEmbed(packageRelationship.getId());
    }

    public CTPicture getCTPicture() {
        return this.ctPic;
    }

    public XWPFPictureData getPictureData() {
        POIXMLDocumentPart pOIXMLDocumentPart;
        CTBlipFillProperties cTBlipFillProperties = this.ctPic.getBlipFill();
        if (cTBlipFillProperties == null || !cTBlipFillProperties.isSetBlip()) {
            return null;
        }
        String string = cTBlipFillProperties.getBlip().getEmbed();
        POIXMLDocumentPart pOIXMLDocumentPart2 = this.run.getParent().getPart();
        if (pOIXMLDocumentPart2 != null && (pOIXMLDocumentPart = pOIXMLDocumentPart2.getRelationById(string)) instanceof XWPFPictureData) {
            return (XWPFPictureData)pOIXMLDocumentPart;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }
}

