/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.wp.usermodel.Paragraph;
import ai2.org.apache.poi.xwpf.usermodel.BodyElementType;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.Borders;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.IRunBody;
import ai2.org.apache.poi.xwpf.usermodel.IRunElement;
import ai2.org.apache.poi.xwpf.usermodel.ISDTContents;
import ai2.org.apache.poi.xwpf.usermodel.LineSpacingRule;
import ai2.org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import ai2.org.apache.poi.xwpf.usermodel.PositionInParagraph;
import ai2.org.apache.poi.xwpf.usermodel.TextAlignment;
import ai2.org.apache.poi.xwpf.usermodel.TextSegement;
import ai2.org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFieldRun;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFootnote;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import ai2.org.apache.poi.xwpf.usermodel.XWPFNum;
import ai2.org.apache.poi.xwpf.usermodel.XWPFNumbering;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRun;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdnRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTProofErr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSmartTagRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFParagraph
implements IBodyElement,
IRunBody,
ISDTContents,
Paragraph {
    private final CTP paragraph;
    protected IBody part;
    protected XWPFDocument document;
    protected List<XWPFRun> runs;
    protected List<IRunElement> iruns;
    private StringBuffer footnoteText = new StringBuffer();

    public XWPFParagraph(CTP cTP, IBody iBody) {
        this.paragraph = cTP;
        this.part = iBody;
        this.document = iBody.getXWPFDocument();
        if (this.document == null) {
            throw new NullPointerException();
        }
        this.runs = new ArrayList<XWPFRun>();
        this.iruns = new ArrayList<IRunElement>();
        this.buildRunsInOrderFromXml((XmlObject)this.paragraph);
        for (XWPFRun xWPFRun : this.runs) {
            CTR cTR = xWPFRun.getCTR();
            XmlCursor xmlCursor = cTR.newCursor();
            xmlCursor.selectPath("child::*");
            while (xmlCursor.toNextSelection()) {
                XmlObject xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTFtnEdnRef)) continue;
                CTFtnEdnRef cTFtnEdnRef = (CTFtnEdnRef)xmlObject;
                this.footnoteText.append(" [").append(cTFtnEdnRef.getId()).append(": ");
                XWPFFootnote xWPFFootnote = cTFtnEdnRef.getDomNode().getLocalName().equals("footnoteReference") ? this.document.getFootnoteByID(cTFtnEdnRef.getId().intValue()) : this.document.getEndnoteByID(cTFtnEdnRef.getId().intValue());
                boolean bl = true;
                for (XWPFParagraph xWPFParagraph : xWPFFootnote.getParagraphs()) {
                    if (!bl) {
                        this.footnoteText.append("\n");
                        bl = false;
                    }
                    this.footnoteText.append(xWPFParagraph.getText());
                }
                this.footnoteText.append("] ");
            }
            xmlCursor.dispose();
        }
    }

    private void buildRunsInOrderFromXml(XmlObject xmlObject) {
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.selectPath("child::*");
        while (xmlCursor.toNextSelection()) {
            XWPFRun xWPFRun;
            Object object;
            int n;
            int n2;
            CTR[] cTRArray;
            XmlObject xmlObject2 = xmlCursor.getObject();
            if (xmlObject2 instanceof CTR) {
                XWPFRun xWPFRun2 = new XWPFRun((CTR)xmlObject2, this);
                this.runs.add(xWPFRun2);
                this.iruns.add(xWPFRun2);
            }
            if (xmlObject2 instanceof CTHyperlink) {
                CTHyperlink cTHyperlink = (CTHyperlink)xmlObject2;
                cTRArray = cTHyperlink.getRArray();
                n2 = cTRArray.length;
                for (n = 0; n < n2; ++n) {
                    object = cTRArray[n];
                    xWPFRun = new XWPFHyperlinkRun(cTHyperlink, (CTR)object, this);
                    this.runs.add(xWPFRun);
                    this.iruns.add(xWPFRun);
                }
            }
            if (xmlObject2 instanceof CTSimpleField) {
                CTSimpleField cTSimpleField = (CTSimpleField)xmlObject2;
                cTRArray = cTSimpleField.getRArray();
                n2 = cTRArray.length;
                for (n = 0; n < n2; ++n) {
                    object = cTRArray[n];
                    xWPFRun = new XWPFFieldRun(cTSimpleField, (CTR)object, this);
                    this.runs.add(xWPFRun);
                    this.iruns.add(xWPFRun);
                }
            }
            if (xmlObject2 instanceof CTSdtBlock) {
                XWPFSDT xWPFSDT = new XWPFSDT((CTSdtBlock)xmlObject2, this.part);
                this.iruns.add(xWPFSDT);
            }
            if (xmlObject2 instanceof CTSdtRun) {
                XWPFSDT xWPFSDT = new XWPFSDT((CTSdtRun)xmlObject2, this.part);
                this.iruns.add(xWPFSDT);
            }
            if (xmlObject2 instanceof CTRunTrackChange) {
                for (CTR cTR : ((CTRunTrackChange)xmlObject2).getRArray()) {
                    object = new XWPFRun(cTR, this);
                    this.runs.add((XWPFRun)object);
                    this.iruns.add((IRunElement)object);
                }
            }
            if (!(xmlObject2 instanceof CTSmartTagRun)) continue;
            this.buildRunsInOrderFromXml(xmlObject2);
        }
        xmlCursor.dispose();
    }

    @Internal
    public CTP getCTP() {
        return this.paragraph;
    }

    public List<XWPFRun> getRuns() {
        return Collections.unmodifiableList(this.runs);
    }

    public List<IRunElement> getIRuns() {
        return Collections.unmodifiableList(this.iruns);
    }

    public boolean isEmpty() {
        return !this.paragraph.getDomNode().hasChildNodes();
    }

    @Override
    public XWPFDocument getDocument() {
        return this.document;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (IRunElement iRunElement : this.iruns) {
            if (iRunElement instanceof XWPFSDT) {
                stringBuffer.append(((XWPFSDT)iRunElement).getContent().getText());
                continue;
            }
            stringBuffer.append(iRunElement.toString());
        }
        stringBuffer.append(this.footnoteText);
        return stringBuffer.toString();
    }

    public String getStyleID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getPStyle() != null && this.paragraph.getPPr().getPStyle().getVal() != null) {
            return this.paragraph.getPPr().getPStyle().getVal();
        }
        return null;
    }

    public BigInteger getNumID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getNumPr() != null && this.paragraph.getPPr().getNumPr().getNumId() != null) {
            return this.paragraph.getPPr().getNumPr().getNumId().getVal();
        }
        return null;
    }

    public void setNumID(BigInteger bigInteger) {
        if (this.paragraph.getPPr() == null) {
            this.paragraph.addNewPPr();
        }
        if (this.paragraph.getPPr().getNumPr() == null) {
            this.paragraph.getPPr().addNewNumPr();
        }
        if (this.paragraph.getPPr().getNumPr().getNumId() == null) {
            this.paragraph.getPPr().getNumPr().addNewNumId();
        }
        this.paragraph.getPPr().getNumPr().getNumId().setVal(bigInteger);
    }

    public BigInteger getNumIlvl() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getNumPr() != null && this.paragraph.getPPr().getNumPr().getIlvl() != null) {
            return this.paragraph.getPPr().getNumPr().getIlvl().getVal();
        }
        return null;
    }

    public String getNumFmt() {
        XWPFNum xWPFNum;
        BigInteger bigInteger = this.getNumID();
        XWPFNumbering xWPFNumbering = this.document.getNumbering();
        if (bigInteger != null && xWPFNumbering != null && (xWPFNum = xWPFNumbering.getNum(bigInteger)) != null) {
            BigInteger bigInteger2 = this.getNumIlvl();
            BigInteger bigInteger3 = xWPFNum.getCTNum().getAbstractNumId().getVal();
            CTAbstractNum cTAbstractNum = xWPFNumbering.getAbstractNum(bigInteger3).getAbstractNum();
            CTLvl cTLvl = null;
            for (int i = 0; i < cTAbstractNum.sizeOfLvlArray(); ++i) {
                CTLvl cTLvl2 = cTAbstractNum.getLvlArray(i);
                if (!cTLvl2.getIlvl().equals(bigInteger2)) continue;
                cTLvl = cTLvl2;
                break;
            }
            if (cTLvl != null && cTLvl.getNumFmt() != null && cTLvl.getNumFmt().getVal() != null) {
                return cTLvl.getNumFmt().getVal().toString();
            }
        }
        return null;
    }

    public String getNumLevelText() {
        XWPFNum xWPFNum;
        BigInteger bigInteger = this.getNumID();
        XWPFNumbering xWPFNumbering = this.document.getNumbering();
        if (bigInteger != null && xWPFNumbering != null && (xWPFNum = xWPFNumbering.getNum(bigInteger)) != null) {
            BigInteger bigInteger2 = this.getNumIlvl();
            CTNum cTNum = xWPFNum.getCTNum();
            if (cTNum == null) {
                return null;
            }
            CTDecimalNumber cTDecimalNumber = cTNum.getAbstractNumId();
            if (cTDecimalNumber == null) {
                return null;
            }
            BigInteger bigInteger3 = cTDecimalNumber.getVal();
            if (bigInteger3 == null) {
                return null;
            }
            XWPFAbstractNum xWPFAbstractNum = xWPFNumbering.getAbstractNum(bigInteger3);
            if (xWPFAbstractNum == null) {
                return null;
            }
            CTAbstractNum cTAbstractNum = xWPFAbstractNum.getCTAbstractNum();
            if (cTAbstractNum == null) {
                return null;
            }
            CTLvl cTLvl = null;
            for (int i = 0; i < cTAbstractNum.sizeOfLvlArray(); ++i) {
                CTLvl cTLvl2 = cTAbstractNum.getLvlArray(i);
                if (cTLvl2 == null || cTLvl2.getIlvl() == null || !cTLvl2.getIlvl().equals(bigInteger2)) continue;
                cTLvl = cTLvl2;
                break;
            }
            if (cTLvl != null && cTLvl.getLvlText() != null && cTLvl.getLvlText().getVal() != null) {
                return cTLvl.getLvlText().getVal().toString();
            }
        }
        return null;
    }

    public BigInteger getNumStartOverride() {
        XWPFNum xWPFNum;
        BigInteger bigInteger = this.getNumID();
        XWPFNumbering xWPFNumbering = this.document.getNumbering();
        if (bigInteger != null && xWPFNumbering != null && (xWPFNum = xWPFNumbering.getNum(bigInteger)) != null) {
            CTNum cTNum = xWPFNum.getCTNum();
            if (cTNum == null) {
                return null;
            }
            BigInteger bigInteger2 = this.getNumIlvl();
            CTNumLvl cTNumLvl = null;
            for (int i = 0; i < cTNum.sizeOfLvlOverrideArray(); ++i) {
                CTNumLvl cTNumLvl2 = cTNum.getLvlOverrideArray(i);
                if (cTNumLvl2 == null || cTNumLvl2.getIlvl() == null || !cTNumLvl2.getIlvl().equals(bigInteger2)) continue;
                cTNumLvl = cTNumLvl2;
                break;
            }
            if (cTNumLvl != null && cTNumLvl.getStartOverride() != null) {
                return cTNumLvl.getStartOverride().getVal();
            }
        }
        return null;
    }

    public String getParagraphText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (XWPFRun xWPFRun : this.runs) {
            stringBuffer.append(xWPFRun.toString());
        }
        return stringBuffer.toString();
    }

    public String getPictureText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (XWPFRun xWPFRun : this.runs) {
            stringBuffer.append(xWPFRun.getPictureText());
        }
        return stringBuffer.toString();
    }

    public String getFootnoteText() {
        return this.footnoteText.toString();
    }

    public ParagraphAlignment getAlignment() {
        CTPPr cTPPr = this.getCTPPr();
        return cTPPr == null || !cTPPr.isSetJc() ? ParagraphAlignment.LEFT : ParagraphAlignment.valueOf(cTPPr.getJc().getVal().intValue());
    }

    public void setAlignment(ParagraphAlignment paragraphAlignment) {
        CTPPr cTPPr = this.getCTPPr();
        CTJc cTJc = cTPPr.isSetJc() ? cTPPr.getJc() : cTPPr.addNewJc();
        STJc.Enum enum_ = STJc.Enum.forInt((int)paragraphAlignment.getValue());
        cTJc.setVal(enum_);
    }

    @Override
    public int getFontAlignment() {
        return this.getAlignment().getValue();
    }

    @Override
    public void setFontAlignment(int n) {
        ParagraphAlignment paragraphAlignment = ParagraphAlignment.valueOf(n);
        this.setAlignment(paragraphAlignment);
    }

    public TextAlignment getVerticalAlignment() {
        CTPPr cTPPr = this.getCTPPr();
        return cTPPr == null || !cTPPr.isSetTextAlignment() ? TextAlignment.AUTO : TextAlignment.valueOf(cTPPr.getTextAlignment().getVal().intValue());
    }

    public void setVerticalAlignment(TextAlignment textAlignment) {
        CTPPr cTPPr = this.getCTPPr();
        CTTextAlignment cTTextAlignment = cTPPr.isSetTextAlignment() ? cTPPr.getTextAlignment() : cTPPr.addNewTextAlignment();
        STTextAlignment.Enum enum_ = STTextAlignment.Enum.forInt((int)textAlignment.getValue());
        cTTextAlignment.setVal(enum_);
    }

    public Borders getBorderTop() {
        CTPBdr cTPBdr = this.getCTPBrd(false);
        CTBorder cTBorder = null;
        if (cTPBdr != null) {
            cTBorder = cTPBdr.getTop();
        }
        STBorder.Enum enum_ = cTBorder != null ? cTBorder.getVal() : STBorder.NONE;
        return Borders.valueOf(enum_.intValue());
    }

    public void setBorderTop(Borders borders) {
        CTBorder cTBorder;
        CTPBdr cTPBdr = this.getCTPBrd(true);
        if (cTPBdr == null) {
            throw new RuntimeException("invalid paragraph state");
        }
        CTBorder cTBorder2 = cTBorder = cTPBdr.isSetTop() ? cTPBdr.getTop() : cTPBdr.addNewTop();
        if (borders.getValue() == Borders.NONE.getValue()) {
            cTPBdr.unsetTop();
        } else {
            cTBorder.setVal(STBorder.Enum.forInt((int)borders.getValue()));
        }
    }

    public Borders getBorderBottom() {
        CTPBdr cTPBdr = this.getCTPBrd(false);
        CTBorder cTBorder = null;
        if (cTPBdr != null) {
            cTBorder = cTPBdr.getBottom();
        }
        STBorder.Enum enum_ = cTBorder != null ? cTBorder.getVal() : STBorder.NONE;
        return Borders.valueOf(enum_.intValue());
    }

    public void setBorderBottom(Borders borders) {
        CTBorder cTBorder;
        CTPBdr cTPBdr = this.getCTPBrd(true);
        CTBorder cTBorder2 = cTBorder = cTPBdr.isSetBottom() ? cTPBdr.getBottom() : cTPBdr.addNewBottom();
        if (borders.getValue() == Borders.NONE.getValue()) {
            cTPBdr.unsetBottom();
        } else {
            cTBorder.setVal(STBorder.Enum.forInt((int)borders.getValue()));
        }
    }

    public Borders getBorderLeft() {
        CTPBdr cTPBdr = this.getCTPBrd(false);
        CTBorder cTBorder = null;
        if (cTPBdr != null) {
            cTBorder = cTPBdr.getLeft();
        }
        STBorder.Enum enum_ = cTBorder != null ? cTBorder.getVal() : STBorder.NONE;
        return Borders.valueOf(enum_.intValue());
    }

    public void setBorderLeft(Borders borders) {
        CTBorder cTBorder;
        CTPBdr cTPBdr = this.getCTPBrd(true);
        CTBorder cTBorder2 = cTBorder = cTPBdr.isSetLeft() ? cTPBdr.getLeft() : cTPBdr.addNewLeft();
        if (borders.getValue() == Borders.NONE.getValue()) {
            cTPBdr.unsetLeft();
        } else {
            cTBorder.setVal(STBorder.Enum.forInt((int)borders.getValue()));
        }
    }

    public Borders getBorderRight() {
        CTPBdr cTPBdr = this.getCTPBrd(false);
        CTBorder cTBorder = null;
        if (cTPBdr != null) {
            cTBorder = cTPBdr.getRight();
        }
        STBorder.Enum enum_ = cTBorder != null ? cTBorder.getVal() : STBorder.NONE;
        return Borders.valueOf(enum_.intValue());
    }

    public void setBorderRight(Borders borders) {
        CTBorder cTBorder;
        CTPBdr cTPBdr = this.getCTPBrd(true);
        CTBorder cTBorder2 = cTBorder = cTPBdr.isSetRight() ? cTPBdr.getRight() : cTPBdr.addNewRight();
        if (borders.getValue() == Borders.NONE.getValue()) {
            cTPBdr.unsetRight();
        } else {
            cTBorder.setVal(STBorder.Enum.forInt((int)borders.getValue()));
        }
    }

    public Borders getBorderBetween() {
        CTPBdr cTPBdr = this.getCTPBrd(false);
        CTBorder cTBorder = null;
        if (cTPBdr != null) {
            cTBorder = cTPBdr.getBetween();
        }
        STBorder.Enum enum_ = cTBorder != null ? cTBorder.getVal() : STBorder.NONE;
        return Borders.valueOf(enum_.intValue());
    }

    public void setBorderBetween(Borders borders) {
        CTBorder cTBorder;
        CTPBdr cTPBdr = this.getCTPBrd(true);
        CTBorder cTBorder2 = cTBorder = cTPBdr.isSetBetween() ? cTPBdr.getBetween() : cTPBdr.addNewBetween();
        if (borders.getValue() == Borders.NONE.getValue()) {
            cTPBdr.unsetBetween();
        } else {
            cTBorder.setVal(STBorder.Enum.forInt((int)borders.getValue()));
        }
    }

    public boolean isPageBreak() {
        CTOnOff cTOnOff;
        CTPPr cTPPr = this.getCTPPr();
        CTOnOff cTOnOff2 = cTOnOff = cTPPr.isSetPageBreakBefore() ? cTPPr.getPageBreakBefore() : null;
        return cTOnOff != null && cTOnOff.getVal().intValue() == 1;
    }

    public void setPageBreak(boolean bl) {
        CTOnOff cTOnOff;
        CTPPr cTPPr = this.getCTPPr();
        CTOnOff cTOnOff2 = cTOnOff = cTPPr.isSetPageBreakBefore() ? cTPPr.getPageBreakBefore() : cTPPr.addNewPageBreakBefore();
        if (bl) {
            cTOnOff.setVal(STOnOff.TRUE);
        } else {
            cTOnOff.setVal(STOnOff.FALSE);
        }
    }

    public int getSpacingAfter() {
        CTSpacing cTSpacing = this.getCTSpacing(false);
        return cTSpacing != null && cTSpacing.isSetAfter() ? cTSpacing.getAfter().intValue() : -1;
    }

    public void setSpacingAfter(int n) {
        CTSpacing cTSpacing = this.getCTSpacing(true);
        if (cTSpacing != null) {
            BigInteger bigInteger = new BigInteger("" + n);
            cTSpacing.setAfter(bigInteger);
        }
    }

    public int getSpacingAfterLines() {
        CTSpacing cTSpacing = this.getCTSpacing(false);
        return cTSpacing != null && cTSpacing.isSetAfterLines() ? cTSpacing.getAfterLines().intValue() : -1;
    }

    public void setSpacingAfterLines(int n) {
        CTSpacing cTSpacing = this.getCTSpacing(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTSpacing.setAfterLines(bigInteger);
    }

    public int getSpacingBefore() {
        CTSpacing cTSpacing = this.getCTSpacing(false);
        return cTSpacing != null && cTSpacing.isSetBefore() ? cTSpacing.getBefore().intValue() : -1;
    }

    public void setSpacingBefore(int n) {
        CTSpacing cTSpacing = this.getCTSpacing(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTSpacing.setBefore(bigInteger);
    }

    public int getSpacingBeforeLines() {
        CTSpacing cTSpacing = this.getCTSpacing(false);
        return cTSpacing != null && cTSpacing.isSetBeforeLines() ? cTSpacing.getBeforeLines().intValue() : -1;
    }

    public void setSpacingBeforeLines(int n) {
        CTSpacing cTSpacing = this.getCTSpacing(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTSpacing.setBeforeLines(bigInteger);
    }

    public LineSpacingRule getSpacingLineRule() {
        CTSpacing cTSpacing = this.getCTSpacing(false);
        return cTSpacing != null && cTSpacing.isSetLineRule() ? LineSpacingRule.valueOf(cTSpacing.getLineRule().intValue()) : LineSpacingRule.AUTO;
    }

    public void setSpacingLineRule(LineSpacingRule lineSpacingRule) {
        CTSpacing cTSpacing = this.getCTSpacing(true);
        cTSpacing.setLineRule(STLineSpacingRule.Enum.forInt((int)lineSpacingRule.getValue()));
    }

    public int getIndentationLeft() {
        CTInd cTInd = this.getCTInd(false);
        return cTInd != null && cTInd.isSetLeft() ? cTInd.getLeft().intValue() : -1;
    }

    public void setIndentationLeft(int n) {
        CTInd cTInd = this.getCTInd(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTInd.setLeft(bigInteger);
    }

    public int getIndentationRight() {
        CTInd cTInd = this.getCTInd(false);
        return cTInd != null && cTInd.isSetRight() ? cTInd.getRight().intValue() : -1;
    }

    public void setIndentationRight(int n) {
        CTInd cTInd = this.getCTInd(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTInd.setRight(bigInteger);
    }

    public int getIndentationHanging() {
        CTInd cTInd = this.getCTInd(false);
        return cTInd != null && cTInd.isSetHanging() ? cTInd.getHanging().intValue() : -1;
    }

    public void setIndentationHanging(int n) {
        CTInd cTInd = this.getCTInd(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTInd.setHanging(bigInteger);
    }

    public int getIndentationFirstLine() {
        CTInd cTInd = this.getCTInd(false);
        return cTInd != null && cTInd.isSetFirstLine() ? cTInd.getFirstLine().intValue() : -1;
    }

    public void setIndentationFirstLine(int n) {
        CTInd cTInd = this.getCTInd(true);
        BigInteger bigInteger = new BigInteger("" + n);
        cTInd.setFirstLine(bigInteger);
    }

    @Override
    public int getIndentFromLeft() {
        return this.getIndentFromLeft();
    }

    @Override
    public void setIndentFromLeft(int n) {
        this.setIndentationLeft(n);
    }

    @Override
    public int getIndentFromRight() {
        return this.getIndentFromRight();
    }

    @Override
    public void setIndentFromRight(int n) {
        this.setIndentationRight(n);
    }

    @Override
    public int getFirstLineIndent() {
        return this.getIndentationFirstLine();
    }

    @Override
    public void setFirstLineIndent(int n) {
        this.setIndentationFirstLine(n);
    }

    @Override
    public boolean isWordWrapped() {
        CTOnOff cTOnOff;
        CTOnOff cTOnOff2 = cTOnOff = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : null;
        if (cTOnOff != null) {
            return cTOnOff.getVal() == STOnOff.ON || cTOnOff.getVal() == STOnOff.TRUE || cTOnOff.getVal() == STOnOff.X_1;
        }
        return false;
    }

    @Override
    public void setWordWrapped(boolean bl) {
        CTOnOff cTOnOff;
        CTOnOff cTOnOff2 = cTOnOff = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : this.getCTPPr().addNewWordWrap();
        if (bl) {
            cTOnOff.setVal(STOnOff.TRUE);
        } else {
            cTOnOff.unsetVal();
        }
    }

    public boolean isWordWrap() {
        return this.isWordWrapped();
    }

    @Deprecated
    public void setWordWrap(boolean bl) {
        this.setWordWrapped(bl);
    }

    public String getStyle() {
        CTPPr cTPPr = this.getCTPPr();
        CTString cTString = cTPPr.isSetPStyle() ? cTPPr.getPStyle() : null;
        return cTString != null ? cTString.getVal() : null;
    }

    public void setStyle(String string) {
        CTPPr cTPPr = this.getCTPPr();
        CTString cTString = cTPPr.getPStyle() != null ? cTPPr.getPStyle() : cTPPr.addNewPStyle();
        cTString.setVal(string);
    }

    private CTPBdr getCTPBrd(boolean bl) {
        CTPBdr cTPBdr;
        CTPPr cTPPr = this.getCTPPr();
        CTPBdr cTPBdr2 = cTPBdr = cTPPr.isSetPBdr() ? cTPPr.getPBdr() : null;
        if (bl && cTPBdr == null) {
            cTPBdr = cTPPr.addNewPBdr();
        }
        return cTPBdr;
    }

    private CTSpacing getCTSpacing(boolean bl) {
        CTSpacing cTSpacing;
        CTPPr cTPPr = this.getCTPPr();
        CTSpacing cTSpacing2 = cTSpacing = cTPPr.getSpacing() == null ? null : cTPPr.getSpacing();
        if (bl && cTSpacing == null) {
            cTSpacing = cTPPr.addNewSpacing();
        }
        return cTSpacing;
    }

    private CTInd getCTInd(boolean bl) {
        CTInd cTInd;
        CTPPr cTPPr = this.getCTPPr();
        CTInd cTInd2 = cTInd = cTPPr.getInd() == null ? null : cTPPr.getInd();
        if (bl && cTInd == null) {
            cTInd = cTPPr.addNewInd();
        }
        return cTInd;
    }

    private CTPPr getCTPPr() {
        CTPPr cTPPr = this.paragraph.getPPr() == null ? this.paragraph.addNewPPr() : this.paragraph.getPPr();
        return cTPPr;
    }

    protected void addRun(CTR cTR) {
        int n = this.paragraph.sizeOfRArray();
        this.paragraph.addNewR();
        this.paragraph.setRArray(n, cTR);
    }

    public XWPFRun createRun() {
        XWPFRun xWPFRun = new XWPFRun(this.paragraph.addNewR(), (IRunBody)this);
        this.runs.add(xWPFRun);
        this.iruns.add(xWPFRun);
        return xWPFRun;
    }

    public XWPFRun insertNewRun(int n) {
        if (n >= 0 && n <= this.paragraph.sizeOfRArray()) {
            XWPFRun xWPFRun;
            int n2;
            CTR cTR = this.paragraph.insertNewR(n);
            XWPFRun xWPFRun2 = new XWPFRun(cTR, (IRunBody)this);
            int n3 = this.iruns.size();
            if (n < this.runs.size() && (n2 = this.iruns.indexOf(xWPFRun = this.runs.get(n))) != -1) {
                n3 = n2;
            }
            this.iruns.add(n3, xWPFRun2);
            this.runs.add(n, xWPFRun2);
            return xWPFRun2;
        }
        return null;
    }

    public TextSegement searchText(String string, PositionInParagraph positionInParagraph) {
        int n = positionInParagraph.getRun();
        int n2 = positionInParagraph.getText();
        int n3 = positionInParagraph.getChar();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        CTR[] cTRArray = this.paragraph.getRArray();
        for (int i = n; i < cTRArray.length; ++i) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            CTR cTR = cTRArray[i];
            XmlCursor xmlCursor = cTR.newCursor();
            xmlCursor.selectPath("./*");
            while (xmlCursor.toNextSelection()) {
                XmlObject xmlObject = xmlCursor.getObject();
                if (xmlObject instanceof CTText) {
                    if (n8 >= n2) {
                        String string2 = ((CTText)xmlObject).getStringValue();
                        for (n9 = i == n ? n3 : 0; n9 < string2.length(); ++n9) {
                            if (string2.charAt(n9) == string.charAt(0) && n5 == 0) {
                                n6 = n8;
                                n7 = n9;
                                n4 = i;
                                bl = true;
                            }
                            if (string2.charAt(n9) == string.charAt(n5)) {
                                if (n5 + 1 < string.length()) {
                                    ++n5;
                                    continue;
                                }
                                if (!bl) continue;
                                TextSegement textSegement = new TextSegement();
                                textSegement.setBeginRun(n4);
                                textSegement.setBeginText(n6);
                                textSegement.setBeginChar(n7);
                                textSegement.setEndRun(i);
                                textSegement.setEndText(n8);
                                textSegement.setEndChar(n9);
                                return textSegement;
                            }
                            n5 = 0;
                        }
                    }
                    ++n8;
                    continue;
                }
                if (xmlObject instanceof CTProofErr) {
                    xmlCursor.removeXml();
                    continue;
                }
                if (xmlObject instanceof CTRPr) continue;
                n5 = 0;
            }
            xmlCursor.dispose();
        }
        return null;
    }

    public String getText(TextSegement textSegement) {
        int n = textSegement.getBeginRun();
        int n2 = textSegement.getBeginText();
        int n3 = textSegement.getBeginChar();
        int n4 = textSegement.getEndRun();
        int n5 = textSegement.getEndText();
        int n6 = textSegement.getEndChar();
        StringBuilder stringBuilder = new StringBuilder();
        CTR[] cTRArray = this.paragraph.getRArray();
        for (int i = n; i <= n4; ++i) {
            CTText[] cTTextArray = cTRArray[i].getTArray();
            int n7 = 0;
            int n8 = cTTextArray.length - 1;
            if (i == n) {
                n7 = n2;
            }
            if (i == n4) {
                n8 = n5;
            }
            for (int j = n7; j <= n8; ++j) {
                String string = cTTextArray[j].getStringValue();
                int n9 = 0;
                int n10 = string.length() - 1;
                if (j == n2 && i == n) {
                    n9 = n3;
                }
                if (j == n5 && i == n4) {
                    n10 = n6;
                }
                stringBuilder.append(string.substring(n9, n10 + 1));
            }
        }
        return stringBuilder.toString();
    }

    public boolean removeRun(int n) {
        if (n >= 0 && n < this.paragraph.sizeOfRArray()) {
            XWPFRun xWPFRun = this.runs.get(n);
            if (xWPFRun instanceof XWPFHyperlinkRun || xWPFRun instanceof XWPFFieldRun) {
                throw new IllegalArgumentException("Removing Field or Hyperlink runs not yet supported");
            }
            this.runs.remove(n);
            this.iruns.remove(xWPFRun);
            this.getCTP().removeR(n);
            return true;
        }
        return false;
    }

    @Override
    public BodyElementType getElementType() {
        return BodyElementType.PARAGRAPH;
    }

    @Override
    public IBody getBody() {
        return this.part;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    @Override
    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public void addRun(XWPFRun xWPFRun) {
        if (!this.runs.contains(xWPFRun)) {
            this.runs.add(xWPFRun);
        }
    }

    public XWPFRun getRun(CTR cTR) {
        for (int i = 0; i < this.getRuns().size(); ++i) {
            if (this.getRuns().get(i).getCTR() != cTR) continue;
            return this.getRuns().get(i);
        }
        return null;
    }
}

