/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFactory;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPictureData;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWPFHeaderFooter
extends POIXMLDocumentPart
implements IBody {
    List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>(1);
    List<XWPFTable> tables = new ArrayList<XWPFTable>(1);
    List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    List<IBodyElement> bodyElements = new ArrayList<IBodyElement>(1);
    CTHdrFtr headerFooter;
    XWPFDocument document;

    XWPFHeaderFooter(XWPFDocument xWPFDocument, CTHdrFtr cTHdrFtr) {
        if (xWPFDocument == null) {
            throw new NullPointerException();
        }
        this.document = xWPFDocument;
        this.headerFooter = cTHdrFtr;
        this.readHdrFtr();
    }

    protected XWPFHeaderFooter() {
        this.headerFooter = CTHdrFtr.Factory.newInstance();
        this.readHdrFtr();
    }

    public XWPFHeaderFooter(POIXMLDocumentPart pOIXMLDocumentPart, PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(pOIXMLDocumentPart, packagePart, packageRelationship);
        this.document = (XWPFDocument)this.getParent();
        if (this.document == null) {
            throw new NullPointerException();
        }
    }

    @Override
    protected void onDocumentRead() throws IOException {
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
            if (!(pOIXMLDocumentPart instanceof XWPFPictureData)) continue;
            XWPFPictureData xWPFPictureData = (XWPFPictureData)pOIXMLDocumentPart;
            this.pictures.add(xWPFPictureData);
            this.document.registerPackagePictureData(xWPFPictureData);
        }
    }

    @Internal
    public CTHdrFtr _getHdrFtr() {
        return this.headerFooter;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    @Override
    public List<XWPFTable> getTables() throws ArrayIndexOutOfBoundsException {
        return Collections.unmodifiableList(this.tables);
    }

    public String getText() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.paragraphs.size(); ++n) {
            String object2;
            if (this.paragraphs.get(n).isEmpty() || (object2 = this.paragraphs.get(n).getText()) == null || object2.length() <= 0) continue;
            stringBuffer.append(object2);
            stringBuffer.append('\n');
        }
        for (n = 0; n < this.tables.size(); ++n) {
            String string = this.tables.get(n).getText();
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        for (IBodyElement iBodyElement : this.getBodyElements()) {
            if (!(iBodyElement instanceof XWPFSDT)) continue;
            stringBuffer.append(((XWPFSDT)iBodyElement).getContent().getText() + '\n');
        }
        return stringBuffer.toString();
    }

    public void setHeaderFooter(CTHdrFtr cTHdrFtr) {
        this.headerFooter = cTHdrFtr;
        this.readHdrFtr();
    }

    @Override
    public XWPFTable getTable(CTTbl cTTbl) {
        for (XWPFTable xWPFTable : this.tables) {
            if (xWPFTable == null) {
                return null;
            }
            if (!xWPFTable.getCTTbl().equals(cTTbl)) continue;
            return xWPFTable;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraph(CTP cTP) {
        for (XWPFParagraph xWPFParagraph : this.paragraphs) {
            if (!xWPFParagraph.getCTP().equals(cTP)) continue;
            return xWPFParagraph;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraphArray(int n) {
        return this.paragraphs.get(n);
    }

    public List<XWPFParagraph> getListParagraph() {
        return this.paragraphs;
    }

    public List<XWPFPictureData> getAllPictures() {
        return Collections.unmodifiableList(this.pictures);
    }

    public List<XWPFPictureData> getAllPackagePictures() {
        return this.document.getAllPackagePictures();
    }

    public String addPictureData(byte[] byArray, int n) throws InvalidFormatException {
        XWPFPictureData xWPFPictureData = this.document.findPackagePictureData(byArray, n);
        POIXMLRelation pOIXMLRelation = XWPFPictureData.RELATIONS[n];
        if (xWPFPictureData == null) {
            int n2 = this.document.getNextPicNameNumber(n);
            xWPFPictureData = (XWPFPictureData)this.createRelationship(pOIXMLRelation, XWPFFactory.getInstance(), n2);
            PackagePart packagePart = xWPFPictureData.getPackagePart();
            OutputStream outputStream = null;
            try {
                outputStream = packagePart.getOutputStream();
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new POIXMLException(iOException);
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.document.registerPackagePictureData(xWPFPictureData);
            this.pictures.add(xWPFPictureData);
            return this.getRelationId(xWPFPictureData);
        }
        if (!this.getRelations().contains(xWPFPictureData)) {
            PackagePart packagePart = xWPFPictureData.getPackagePart();
            TargetMode targetMode = TargetMode.INTERNAL;
            PackagePartName packagePartName = packagePart.getPartName();
            String string = pOIXMLRelation.getRelation();
            PackageRelationship packageRelationship = this.getPackagePart().addRelationship(packagePartName, targetMode, string);
            String string2 = packageRelationship.getId();
            this.addRelation(string2, xWPFPictureData);
            this.pictures.add(xWPFPictureData);
            return string2;
        }
        return this.getRelationId(xWPFPictureData);
    }

    public String addPictureData(InputStream inputStream, int n) throws InvalidFormatException, IOException {
        byte[] byArray = IOUtils.toByteArray(inputStream);
        return this.addPictureData(byArray, n);
    }

    public XWPFPictureData getPictureDataByID(String string) {
        POIXMLDocumentPart pOIXMLDocumentPart = this.getRelationById(string);
        if (pOIXMLDocumentPart != null && pOIXMLDocumentPart instanceof XWPFPictureData) {
            return (XWPFPictureData)pOIXMLDocumentPart;
        }
        return null;
    }

    public XWPFParagraph createParagraph() {
        XWPFParagraph xWPFParagraph = new XWPFParagraph(this.headerFooter.addNewP(), this);
        this.paragraphs.add(xWPFParagraph);
        return xWPFParagraph;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor xmlCursor) {
        if (this.isCursorInHdrF(xmlCursor)) {
            int n;
            String string = CTP.type.getName().getNamespaceURI();
            String string2 = "p";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTP cTP = (CTP)xmlCursor.getObject();
            XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, this);
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTP) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTP) || (CTP)xmlObject == cTP) {
                this.paragraphs.add(0, xWPFParagraph);
            } else {
                n = this.paragraphs.indexOf(this.getParagraph((CTP)xmlObject)) + 1;
                this.paragraphs.add(n, xWPFParagraph);
            }
            n = 0;
            xmlCursor.toCursor(cTP.newCursor());
            while (xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                ++n;
            }
            this.bodyElements.add(n, xWPFParagraph);
            xmlCursor.toCursor(cTP.newCursor());
            xmlCursor.toEndToken();
            return xWPFParagraph;
        }
        return null;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor xmlCursor) {
        if (this.isCursorInHdrF(xmlCursor)) {
            int n;
            String string = CTTbl.type.getName().getNamespaceURI();
            String string2 = "tbl";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTTbl cTTbl = (CTTbl)xmlCursor.getObject();
            XWPFTable xWPFTable = new XWPFTable(cTTbl, this);
            xmlCursor.removeXmlContents();
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTTbl) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTTbl)) {
                this.tables.add(0, xWPFTable);
            } else {
                n = this.tables.indexOf(this.getTable((CTTbl)xmlObject)) + 1;
                this.tables.add(n, xWPFTable);
            }
            n = 0;
            xmlCursor = cTTbl.newCursor();
            while (xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                ++n;
            }
            this.bodyElements.add(n, xWPFTable);
            xmlCursor = cTTbl.newCursor();
            xmlCursor.toEndToken();
            return xWPFTable;
        }
        return null;
    }

    private boolean isCursorInHdrF(XmlCursor xmlCursor) {
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        xmlCursor2.toParent();
        return xmlCursor2.getObject() == this.headerFooter;
    }

    public POIXMLDocumentPart getOwner() {
        return this;
    }

    @Override
    public XWPFTable getTableArray(int n) {
        if (n > 0 && n < this.tables.size()) {
            return this.tables.get(n);
        }
        return null;
    }

    @Override
    public void insertTable(int n, XWPFTable xWPFTable) {
        this.bodyElements.add(n, xWPFTable);
        int n2 = 0;
        for (CTTbl cTTbl : this.headerFooter.getTblArray()) {
            if (cTTbl == xWPFTable.getCTTbl()) break;
            ++n2;
        }
        this.tables.add(n2, xWPFTable);
    }

    public void readHdrFtr() {
        this.bodyElements = new ArrayList<IBodyElement>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        XmlCursor xmlCursor = this.headerFooter.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            IBodyElement iBodyElement;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTP) {
                iBodyElement = new XWPFParagraph((CTP)xmlObject, this);
                this.paragraphs.add((XWPFParagraph)iBodyElement);
                this.bodyElements.add(iBodyElement);
            }
            if (!(xmlObject instanceof CTTbl)) continue;
            iBodyElement = new XWPFTable((CTTbl)xmlObject, this);
            this.tables.add((XWPFTable)iBodyElement);
            this.bodyElements.add(iBodyElement);
        }
        xmlCursor.dispose();
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cTTc) {
        XmlCursor xmlCursor = cTTc.newCursor();
        xmlCursor.toParent();
        XmlObject xmlObject = xmlCursor.getObject();
        if (!(xmlObject instanceof CTRow)) {
            return null;
        }
        CTRow cTRow = (CTRow)xmlObject;
        xmlCursor.toParent();
        xmlObject = xmlCursor.getObject();
        xmlCursor.dispose();
        if (!(xmlObject instanceof CTTbl)) {
            return null;
        }
        CTTbl cTTbl = (CTTbl)xmlObject;
        XWPFTable xWPFTable = this.getTable(cTTbl);
        if (xWPFTable == null) {
            return null;
        }
        XWPFTableRow xWPFTableRow = xWPFTable.getRow(cTRow);
        return xWPFTableRow.getTableCell(cTTc);
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        if (this.document != null) {
            return this.document;
        }
        return (XWPFDocument)this.getParent();
    }

    public void setXWPFDocument(XWPFDocument xWPFDocument) {
        this.document = xWPFDocument;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this;
    }
}

