/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFootnote;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFootnotes;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFFootnotes
extends POIXMLDocumentPart {
    protected XWPFDocument document;
    private List<XWPFFootnote> listFootnote = new ArrayList<XWPFFootnote>();
    private CTFootnotes ctFootnotes;

    public XWPFFootnotes(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, OpenXML4JException {
        super(packagePart, packageRelationship);
    }

    public XWPFFootnotes() {
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            CTFtnEdn[] cTFtnEdnArray = this.getPackagePart().getInputStream();
            FootnotesDocument footnotesDocument = FootnotesDocument.Factory.parse((InputStream)cTFtnEdnArray);
            this.ctFootnotes = footnotesDocument.getFootnotes();
        }
        catch (XmlException xmlException) {
            throw new POIXMLException();
        }
        for (CTFtnEdn cTFtnEdn : this.ctFootnotes.getFootnoteArray()) {
            this.listFootnote.add(new XWPFFootnote(cTFtnEdn, this));
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTFootnotes.type.getName().getNamespaceURI(), "footnotes"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.ctFootnotes.save(outputStream, xmlOptions);
        outputStream.close();
    }

    public List<XWPFFootnote> getFootnotesList() {
        return this.listFootnote;
    }

    public XWPFFootnote getFootnoteById(int n) {
        for (XWPFFootnote xWPFFootnote : this.listFootnote) {
            if (xWPFFootnote.getCTFtnEdn().getId().intValue() != n) continue;
            return xWPFFootnote;
        }
        return null;
    }

    public void setFootnotes(CTFootnotes cTFootnotes) {
        this.ctFootnotes = cTFootnotes;
    }

    public void addFootnote(XWPFFootnote xWPFFootnote) {
        this.listFootnote.add(xWPFFootnote);
        this.ctFootnotes.addNewFootnote().set((XmlObject)xWPFFootnote.getCTFtnEdn());
    }

    public XWPFFootnote addFootnote(CTFtnEdn cTFtnEdn) {
        CTFtnEdn cTFtnEdn2 = this.ctFootnotes.addNewFootnote();
        cTFtnEdn2.set((XmlObject)cTFtnEdn);
        XWPFFootnote xWPFFootnote = new XWPFFootnote(cTFtnEdn2, this);
        this.listFootnote.add(xWPFFootnote);
        return xWPFFootnote;
    }

    public XWPFDocument getXWPFDocument() {
        if (this.document != null) {
            return this.document;
        }
        return (XWPFDocument)this.getParent();
    }

    public void setXWPFDocument(XWPFDocument xWPFDocument) {
        this.document = xWPFDocument;
    }
}

