/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFootnotes;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPictureData;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFFootnote
implements Iterable<XWPFParagraph>,
IBody {
    private List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    private List<XWPFTable> tables = new ArrayList<XWPFTable>();
    private List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    private List<IBodyElement> bodyElements = new ArrayList<IBodyElement>();
    private CTFtnEdn ctFtnEdn;
    private XWPFFootnotes footnotes;
    private XWPFDocument document;

    public XWPFFootnote(CTFtnEdn cTFtnEdn, XWPFFootnotes xWPFFootnotes) {
        this.footnotes = xWPFFootnotes;
        this.ctFtnEdn = cTFtnEdn;
        this.document = xWPFFootnotes.getXWPFDocument();
        this.init();
    }

    public XWPFFootnote(XWPFDocument xWPFDocument, CTFtnEdn cTFtnEdn) {
        this.ctFtnEdn = cTFtnEdn;
        this.document = xWPFDocument;
        this.init();
    }

    private void init() {
        XmlCursor xmlCursor = this.ctFtnEdn.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            IBodyElement iBodyElement;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTP) {
                iBodyElement = new XWPFParagraph((CTP)xmlObject, this);
                this.bodyElements.add(iBodyElement);
                this.paragraphs.add((XWPFParagraph)iBodyElement);
                continue;
            }
            if (xmlObject instanceof CTTbl) {
                iBodyElement = new XWPFTable((CTTbl)xmlObject, this);
                this.bodyElements.add(iBodyElement);
                this.tables.add((XWPFTable)iBodyElement);
                continue;
            }
            if (!(xmlObject instanceof CTSdtBlock)) continue;
            iBodyElement = new XWPFSDT((CTSdtBlock)xmlObject, (IBody)this);
            this.bodyElements.add(iBodyElement);
        }
        xmlCursor.dispose();
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public Iterator<XWPFParagraph> iterator() {
        return this.paragraphs.iterator();
    }

    @Override
    public List<XWPFTable> getTables() {
        return this.tables;
    }

    public List<XWPFPictureData> getPictures() {
        return this.pictures;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return this.bodyElements;
    }

    public CTFtnEdn getCTFtnEdn() {
        return this.ctFtnEdn;
    }

    public void setCTFtnEdn(CTFtnEdn cTFtnEdn) {
        this.ctFtnEdn = cTFtnEdn;
    }

    @Override
    public XWPFTable getTableArray(int n) {
        if (n > 0 && n < this.tables.size()) {
            return this.tables.get(n);
        }
        return null;
    }

    @Override
    public void insertTable(int n, XWPFTable xWPFTable) {
        this.bodyElements.add(n, xWPFTable);
        int n2 = 0;
        for (CTTbl cTTbl : this.ctFtnEdn.getTblArray()) {
            if (cTTbl == xWPFTable.getCTTbl()) break;
            ++n2;
        }
        this.tables.add(n2, xWPFTable);
    }

    @Override
    public XWPFTable getTable(CTTbl cTTbl) {
        for (XWPFTable xWPFTable : this.tables) {
            if (xWPFTable == null) {
                return null;
            }
            if (!xWPFTable.getCTTbl().equals(cTTbl)) continue;
            return xWPFTable;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraph(CTP cTP) {
        for (XWPFParagraph xWPFParagraph : this.paragraphs) {
            if (!xWPFParagraph.getCTP().equals(cTP)) continue;
            return xWPFParagraph;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraphArray(int n) {
        return this.paragraphs.get(n);
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cTTc) {
        XmlCursor xmlCursor = cTTc.newCursor();
        xmlCursor.toParent();
        XmlObject xmlObject = xmlCursor.getObject();
        if (!(xmlObject instanceof CTRow)) {
            return null;
        }
        CTRow cTRow = (CTRow)xmlObject;
        xmlCursor.toParent();
        xmlObject = xmlCursor.getObject();
        xmlCursor.dispose();
        if (!(xmlObject instanceof CTTbl)) {
            return null;
        }
        CTTbl cTTbl = (CTTbl)xmlObject;
        XWPFTable xWPFTable = this.getTable(cTTbl);
        if (xWPFTable == null) {
            return null;
        }
        XWPFTableRow xWPFTableRow = xWPFTable.getRow(cTRow);
        return xWPFTableRow.getTableCell(cTTc);
    }

    private boolean isCursorInFtn(XmlCursor xmlCursor) {
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        xmlCursor2.toParent();
        return xmlCursor2.getObject() == this.ctFtnEdn;
    }

    public POIXMLDocumentPart getOwner() {
        return this.footnotes;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor xmlCursor) {
        if (this.isCursorInFtn(xmlCursor)) {
            int n;
            String string = CTTbl.type.getName().getNamespaceURI();
            String string2 = "tbl";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTTbl cTTbl = (CTTbl)xmlCursor.getObject();
            XWPFTable xWPFTable = new XWPFTable(cTTbl, this);
            xmlCursor.removeXmlContents();
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTTbl) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTTbl)) {
                this.tables.add(0, xWPFTable);
            } else {
                n = this.tables.indexOf(this.getTable((CTTbl)xmlObject)) + 1;
                this.tables.add(n, xWPFTable);
            }
            n = 0;
            xmlCursor = cTTbl.newCursor();
            while (xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                ++n;
            }
            this.bodyElements.add(n, xWPFTable);
            xmlCursor = cTTbl.newCursor();
            xmlCursor.toEndToken();
            return xWPFTable;
        }
        return null;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor xmlCursor) {
        if (this.isCursorInFtn(xmlCursor)) {
            int n;
            String string = CTP.type.getName().getNamespaceURI();
            String string2 = "p";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTP cTP = (CTP)xmlCursor.getObject();
            XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, this);
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTP) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTP) || (CTP)xmlObject == cTP) {
                this.paragraphs.add(0, xWPFParagraph);
            } else {
                n = this.paragraphs.indexOf(this.getParagraph((CTP)xmlObject)) + 1;
                this.paragraphs.add(n, xWPFParagraph);
            }
            n = 0;
            xmlCursor.toCursor(cTP.newCursor());
            while (xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
                if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                ++n;
            }
            this.bodyElements.add(n, xWPFParagraph);
            xmlCursor.toCursor(cTP.newCursor());
            xmlCursor.toEndToken();
            return xWPFParagraph;
        }
        return null;
    }

    public XWPFTable addNewTbl(CTTbl cTTbl) {
        CTTbl cTTbl2 = this.ctFtnEdn.addNewTbl();
        cTTbl2.set((XmlObject)cTTbl);
        XWPFTable xWPFTable = new XWPFTable(cTTbl2, this);
        this.tables.add(xWPFTable);
        return xWPFTable;
    }

    public XWPFParagraph addNewParagraph(CTP cTP) {
        CTP cTP2 = this.ctFtnEdn.addNewP();
        cTP2.set((XmlObject)cTP);
        XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP2, this);
        this.paragraphs.add(xWPFParagraph);
        return xWPFParagraph;
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this.document;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this.footnotes;
    }

    @Override
    public BodyType getPartType() {
        return BodyType.FOOTNOTE;
    }
}

