/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;

public class XWPFFooter
extends XWPFHeaderFooter {
    public XWPFFooter() {
    }

    public XWPFFooter(XWPFDocument xWPFDocument, CTHdrFtr cTHdrFtr) throws IOException {
        super(xWPFDocument, cTHdrFtr);
        XmlCursor xmlCursor = this.headerFooter.newCursor();
        xmlCursor.selectPath("./*");
        while (xmlCursor.toNextSelection()) {
            IBodyElement iBodyElement;
            XmlObject xmlObject = xmlCursor.getObject();
            if (xmlObject instanceof CTP) {
                iBodyElement = new XWPFParagraph((CTP)xmlObject, this);
                this.paragraphs.add(iBodyElement);
                this.bodyElements.add(iBodyElement);
            }
            if (!(xmlObject instanceof CTTbl)) continue;
            iBodyElement = new XWPFTable((CTTbl)xmlObject, this);
            this.tables.add(iBodyElement);
            this.bodyElements.add(iBodyElement);
        }
        xmlCursor.dispose();
    }

    public XWPFFooter(POIXMLDocumentPart pOIXMLDocumentPart, PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(pOIXMLDocumentPart, packagePart, packageRelationship);
    }

    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTNumbering.type.getName().getNamespaceURI(), "ftr"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        hashMap.put("urn:schemas-microsoft-com:office:office", "o");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        hashMap.put("urn:schemas-microsoft-com:vml", "v");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        hashMap.put("urn:schemas-microsoft-com:office:word", "w10");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        hashMap.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        super._getHdrFtr().save(outputStream, xmlOptions);
        outputStream.close();
    }

    protected void onDocumentRead() throws IOException {
        super.onDocumentRead();
        FtrDocument ftrDocument = null;
        try {
            InputStream inputStream = this.getPackagePart().getInputStream();
            ftrDocument = FtrDocument.Factory.parse((InputStream)inputStream);
            this.headerFooter = ftrDocument.getFtr();
            XmlCursor xmlCursor = this.headerFooter.newCursor();
            xmlCursor.selectPath("./*");
            while (xmlCursor.toNextSelection()) {
                IBodyElement iBodyElement;
                XmlObject xmlObject = xmlCursor.getObject();
                if (xmlObject instanceof CTP) {
                    iBodyElement = new XWPFParagraph((CTP)xmlObject, this);
                    this.paragraphs.add(iBodyElement);
                    this.bodyElements.add(iBodyElement);
                }
                if (xmlObject instanceof CTTbl) {
                    iBodyElement = new XWPFTable((CTTbl)xmlObject, this);
                    this.tables.add(iBodyElement);
                    this.bodyElements.add(iBodyElement);
                }
                if (!(xmlObject instanceof CTSdtBlock)) continue;
                iBodyElement = new XWPFSDT((CTSdtBlock)xmlObject, (IBody)this);
                this.bodyElements.add(iBodyElement);
            }
            xmlCursor.dispose();
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    public BodyType getPartType() {
        return BodyType.FOOTER;
    }
}

