/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLFactory;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRelation;
import java.lang.reflect.Constructor;

public final class XWPFFactory
extends POIXMLFactory {
    private static final POILogger logger = POILogFactory.getLogger(XWPFFactory.class);
    private static final XWPFFactory inst = new XWPFFactory();

    private XWPFFactory() {
    }

    public static XWPFFactory getInstance() {
        return inst;
    }

    public POIXMLDocumentPart createDocumentPart(POIXMLDocumentPart pOIXMLDocumentPart, PackageRelationship packageRelationship, PackagePart packagePart) {
        XWPFRelation xWPFRelation = XWPFRelation.getInstance(packageRelationship.getRelationshipType());
        if (xWPFRelation == null || xWPFRelation.getRelationClass() == null) {
            logger.log(1, new Object[]{"using default POIXMLDocumentPart for " + packageRelationship.getRelationshipType()});
            return new POIXMLDocumentPart(packagePart, packageRelationship);
        }
        try {
            Class<? extends POIXMLDocumentPart> clazz = xWPFRelation.getRelationClass();
            try {
                Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(POIXMLDocumentPart.class, PackagePart.class, PackageRelationship.class);
                return constructor.newInstance(pOIXMLDocumentPart, packagePart, packageRelationship);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(PackagePart.class, PackageRelationship.class);
                return constructor.newInstance(packagePart, packageRelationship);
            }
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    public POIXMLDocumentPart newDocumentPart(POIXMLRelation pOIXMLRelation) {
        try {
            Class<? extends POIXMLDocumentPart> clazz = pOIXMLRelation.getRelationClass();
            Constructor<? extends POIXMLDocumentPart> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }
}

