/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.POIXMLProperties;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.IdentifierManager;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.PackageHelper;
import ai2.org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import ai2.org.apache.poi.xwpf.usermodel.BodyElementType;
import ai2.org.apache.poi.xwpf.usermodel.BodyType;
import ai2.org.apache.poi.xwpf.usermodel.Document;
import ai2.org.apache.poi.xwpf.usermodel.IBody;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.TOC;
import ai2.org.apache.poi.xwpf.usermodel.XWPFComment;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFactory;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFooter;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFootnote;
import ai2.org.apache.poi.xwpf.usermodel.XWPFFootnotes;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHeader;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import ai2.org.apache.poi.xwpf.usermodel.XWPFNumbering;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFPictureData;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRelation;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSettings;
import ai2.org.apache.poi.xwpf.usermodel.XWPFStyles;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.EndnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.NumberingDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFDocument
extends POIXMLDocument
implements Document,
IBody {
    protected List<XWPFFooter> footers = new ArrayList<XWPFFooter>();
    protected List<XWPFHeader> headers = new ArrayList<XWPFHeader>();
    protected List<XWPFComment> comments = new ArrayList<XWPFComment>();
    protected List<XWPFHyperlink> hyperlinks = new ArrayList<XWPFHyperlink>();
    protected List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    protected List<XWPFTable> tables = new ArrayList<XWPFTable>();
    protected List<XWPFSDT> contentControls = new ArrayList<XWPFSDT>();
    protected List<IBodyElement> bodyElements = new ArrayList<IBodyElement>();
    protected List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    protected Map<Long, List<XWPFPictureData>> packagePictures = new HashMap<Long, List<XWPFPictureData>>();
    protected Map<Integer, XWPFFootnote> endnotes = new HashMap<Integer, XWPFFootnote>();
    protected XWPFNumbering numbering;
    protected XWPFStyles styles;
    protected XWPFFootnotes footnotes;
    private CTDocument1 ctDocument;
    private XWPFSettings settings;
    private IdentifierManager drawingIdManager = new IdentifierManager(0L, 0xFFFFFFFFL);
    private XWPFHeaderFooterPolicy headerFooterPolicy;

    public XWPFDocument(OPCPackage oPCPackage) throws IOException {
        super(oPCPackage);
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument(InputStream inputStream) throws IOException {
        super(PackageHelper.open(inputStream));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument() {
        super(XWPFDocument.newPackage());
        this.onDocumentCreate();
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage oPCPackage = OPCPackage.create(new ByteArrayOutputStream());
            PackagePartName packagePartName = PackagingURIHelper.createPartName(XWPFRelation.DOCUMENT.getDefaultFileName());
            oPCPackage.addRelationship(packagePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            oPCPackage.createPart(packagePartName, XWPFRelation.DOCUMENT.getContentType());
            oPCPackage.getPackageProperties().setCreatorProperty("Apache POI");
            return oPCPackage;
        }
        catch (Exception exception) {
            throw new POIXMLException(exception);
        }
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            DocumentDocument documentDocument = DocumentDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.ctDocument = documentDocument.getDocument();
            this.initFootnotes();
            XmlCursor xmlCursor = this.ctDocument.getBody().newCursor();
            xmlCursor.selectPath("./*");
            while (xmlCursor.toNextSelection()) {
                XmlObject xmlObject = xmlCursor.getObject();
                if (xmlObject instanceof CTP) {
                    XWPFParagraph xWPFParagraph = new XWPFParagraph((CTP)xmlObject, this);
                    this.bodyElements.add(xWPFParagraph);
                    this.paragraphs.add(xWPFParagraph);
                    continue;
                }
                if (xmlObject instanceof CTTbl) {
                    XWPFTable xWPFTable = new XWPFTable((CTTbl)xmlObject, this);
                    this.bodyElements.add(xWPFTable);
                    this.tables.add(xWPFTable);
                    continue;
                }
                if (!(xmlObject instanceof CTSdtBlock)) continue;
                XWPFSDT xWPFSDT = new XWPFSDT((CTSdtBlock)xmlObject, (IBody)this);
                this.bodyElements.add(xWPFSDT);
                this.contentControls.add(xWPFSDT);
            }
            xmlCursor.dispose();
            if (documentDocument.getDocument().getBody().getSectPr() != null) {
                this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
            }
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                Object object;
                String string = pOIXMLDocumentPart.getPackageRelationship().getRelationshipType();
                if (string.equals(XWPFRelation.STYLES.getRelation())) {
                    this.styles = (XWPFStyles)pOIXMLDocumentPart;
                    this.styles.onDocumentRead();
                    continue;
                }
                if (string.equals(XWPFRelation.NUMBERING.getRelation())) {
                    this.numbering = (XWPFNumbering)pOIXMLDocumentPart;
                    this.numbering.onDocumentRead();
                    continue;
                }
                if (string.equals(XWPFRelation.FOOTER.getRelation())) {
                    object = (XWPFFooter)pOIXMLDocumentPart;
                    this.footers.add((XWPFFooter)object);
                    ((XWPFFooter)object).onDocumentRead();
                    continue;
                }
                if (string.equals(XWPFRelation.HEADER.getRelation())) {
                    object = (XWPFHeader)pOIXMLDocumentPart;
                    this.headers.add((XWPFHeader)object);
                    ((XWPFHeader)object).onDocumentRead();
                    continue;
                }
                if (string.equals(XWPFRelation.COMMENT.getRelation())) {
                    object = CommentsDocument.Factory.parse((InputStream)pOIXMLDocumentPart.getPackagePart().getInputStream());
                    for (CTComment cTComment : object.getComments().getCommentArray()) {
                        this.comments.add(new XWPFComment(cTComment, this));
                    }
                    continue;
                }
                if (string.equals(XWPFRelation.SETTINGS.getRelation())) {
                    this.settings = (XWPFSettings)pOIXMLDocumentPart;
                    this.settings.onDocumentRead();
                    continue;
                }
                if (string.equals(XWPFRelation.IMAGES.getRelation())) {
                    object = (XWPFPictureData)pOIXMLDocumentPart;
                    ((XWPFPictureData)object).onDocumentRead();
                    this.registerPackagePictureData((XWPFPictureData)object);
                    this.pictures.add((XWPFPictureData)object);
                    continue;
                }
                if (!string.equals(XWPFRelation.GLOSSARY_DOCUMENT.getRelation())) continue;
                for (POIXMLDocumentPart pOIXMLDocumentPart2 : pOIXMLDocumentPart.getRelations()) {
                    try {
                        Method method = pOIXMLDocumentPart2.getClass().getDeclaredMethod("onDocumentRead", new Class[0]);
                        method.setAccessible(true);
                        method.invoke((Object)pOIXMLDocumentPart2, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new POIXMLException(exception);
                    }
                }
            }
            this.initHyperlinks();
        }
        catch (XmlException xmlException) {
            throw new POIXMLException(xmlException);
        }
    }

    private void initHyperlinks() {
        try {
            for (PackageRelationship packageRelationship : this.getPackagePart().getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation())) {
                this.hyperlinks.add(new XWPFHyperlink(packageRelationship.getId(), packageRelationship.getTargetURI().toString()));
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new POIXMLException(invalidFormatException);
        }
    }

    private void initFootnotes() throws XmlException, IOException {
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
            String string = pOIXMLDocumentPart.getPackageRelationship().getRelationshipType();
            if (string.equals(XWPFRelation.FOOTNOTE.getRelation())) {
                this.footnotes = (XWPFFootnotes)pOIXMLDocumentPart;
                this.footnotes.onDocumentRead();
                continue;
            }
            if (!string.equals(XWPFRelation.ENDNOTE.getRelation())) continue;
            EndnotesDocument endnotesDocument = EndnotesDocument.Factory.parse((InputStream)pOIXMLDocumentPart.getPackagePart().getInputStream());
            for (CTFtnEdn cTFtnEdn : endnotesDocument.getEndnotes().getEndnoteArray()) {
                this.endnotes.put(cTFtnEdn.getId().intValue(), new XWPFFootnote(this, cTFtnEdn));
            }
        }
    }

    @Override
    protected void onDocumentCreate() {
        this.ctDocument = CTDocument1.Factory.newInstance();
        this.ctDocument.addNewBody();
        this.settings = (XWPFSettings)this.createRelationship(XWPFRelation.SETTINGS, XWPFFactory.getInstance());
        POIXMLProperties.ExtendedProperties extendedProperties = this.getProperties().getExtendedProperties();
        extendedProperties.getUnderlyingProperties().setApplication("Apache POI");
    }

    @Internal
    public CTDocument1 getDocument() {
        return this.ctDocument;
    }

    IdentifierManager getDrawingIdManager() {
        return this.drawingIdManager;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public Iterator<IBodyElement> getBodyElementsIterator() {
        return this.bodyElements.iterator();
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    @Override
    public List<XWPFTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public XWPFTable getTableArray(int n) {
        if (n > 0 && n < this.tables.size()) {
            return this.tables.get(n);
        }
        return null;
    }

    public List<XWPFFooter> getFooterList() {
        return Collections.unmodifiableList(this.footers);
    }

    public XWPFFooter getFooterArray(int n) {
        return this.footers.get(n);
    }

    public List<XWPFHeader> getHeaderList() {
        return Collections.unmodifiableList(this.headers);
    }

    public XWPFHeader getHeaderArray(int n) {
        return this.headers.get(n);
    }

    public String getTblStyle(XWPFTable xWPFTable) {
        return xWPFTable.getStyleID();
    }

    public XWPFHyperlink getHyperlinkByID(String string) {
        for (XWPFHyperlink xWPFHyperlink : this.hyperlinks) {
            if (!xWPFHyperlink.getId().equals(string)) continue;
            return xWPFHyperlink;
        }
        return null;
    }

    public XWPFFootnote getFootnoteByID(int n) {
        if (this.footnotes == null) {
            return null;
        }
        return this.footnotes.getFootnoteById(n);
    }

    public XWPFFootnote getEndnoteByID(int n) {
        if (this.endnotes == null) {
            return null;
        }
        return this.endnotes.get(n);
    }

    public List<XWPFFootnote> getFootnotes() {
        if (this.footnotes == null) {
            return Collections.emptyList();
        }
        return this.footnotes.getFootnotesList();
    }

    public XWPFHyperlink[] getHyperlinks() {
        return this.hyperlinks.toArray(new XWPFHyperlink[this.hyperlinks.size()]);
    }

    public XWPFComment getCommentByID(String string) {
        for (XWPFComment xWPFComment : this.comments) {
            if (!xWPFComment.getId().equals(string)) continue;
            return xWPFComment;
        }
        return null;
    }

    public XWPFComment[] getComments() {
        return this.comments.toArray(new XWPFComment[this.comments.size()]);
    }

    public PackagePart getPartById(String string) {
        try {
            PackagePart packagePart = this.getCorePart();
            return packagePart.getRelatedPart(packagePart.getRelationship(string));
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalArgumentException(invalidFormatException);
        }
    }

    public XWPFHeaderFooterPolicy getHeaderFooterPolicy() {
        return this.headerFooterPolicy;
    }

    public XWPFHeaderFooterPolicy createHeaderFooterPolicy() {
        if (this.headerFooterPolicy == null) {
            if (!this.ctDocument.getBody().isSetSectPr()) {
                this.ctDocument.getBody().addNewSectPr();
            }
            this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
        }
        return this.headerFooterPolicy;
    }

    @Internal
    public CTStyles getStyle() throws XmlException, IOException {
        PackagePart[] packagePartArray;
        try {
            packagePartArray = this.getRelatedByType(XWPFRelation.STYLES.getRelation());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
        if (packagePartArray.length != 1) {
            throw new IllegalStateException("Expecting one Styles document part, but found " + packagePartArray.length);
        }
        StylesDocument stylesDocument = StylesDocument.Factory.parse((InputStream)packagePartArray[0].getInputStream());
        return stylesDocument.getStyles();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        LinkedList<PackagePart> linkedList = new LinkedList<PackagePart>();
        PackagePart packagePart = this.getPackagePart();
        for (PackageRelationship packageRelationship : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject")) {
            linkedList.add(packagePart.getRelatedPart(packageRelationship));
        }
        for (PackageRelationship packageRelationship : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package")) {
            linkedList.add(packagePart.getRelatedPart(packageRelationship));
        }
        return linkedList;
    }

    private int getBodyElementSpecificPos(int n, List<? extends IBodyElement> list) {
        if (list.size() == 0) {
            return -1;
        }
        if (n >= 0 && n < this.bodyElements.size()) {
            int n2;
            IBodyElement iBodyElement = this.bodyElements.get(n);
            if (iBodyElement.getElementType() != list.get(0).getElementType()) {
                return -1;
            }
            for (int i = n2 = Math.min(n, list.size() - 1); i >= 0; --i) {
                if (list.get(i) != iBodyElement) continue;
                return i;
            }
        }
        return -1;
    }

    public int getParagraphPos(int n) {
        return this.getBodyElementSpecificPos(n, this.paragraphs);
    }

    public int getTablePos(int n) {
        return this.getBodyElementSpecificPos(n, this.tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor xmlCursor) {
        if (this.isCursorInBody(xmlCursor)) {
            String string = CTP.type.getName().getNamespaceURI();
            String string2 = "p";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTP cTP = (CTP)xmlCursor.getObject();
            XWPFParagraph xWPFParagraph = new XWPFParagraph(cTP, this);
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTP) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTP) || (CTP)xmlObject == cTP) {
                this.paragraphs.add(0, xWPFParagraph);
            } else {
                int n = this.paragraphs.indexOf(this.getParagraph((CTP)xmlObject)) + 1;
                this.paragraphs.add(n, xWPFParagraph);
            }
            XmlCursor xmlCursor2 = cTP.newCursor();
            try {
                int n = 0;
                xmlCursor.toCursor(xmlCursor2);
                while (xmlCursor.toPrevSibling()) {
                    xmlObject = xmlCursor.getObject();
                    if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                    ++n;
                }
                this.bodyElements.add(n, xWPFParagraph);
                xmlCursor.toCursor(xmlCursor2);
                xmlCursor.toEndToken();
                XWPFParagraph xWPFParagraph2 = xWPFParagraph;
                return xWPFParagraph2;
            }
            finally {
                xmlCursor2.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWPFTable insertNewTbl(XmlCursor xmlCursor) {
        if (this.isCursorInBody(xmlCursor)) {
            int n;
            String string = CTTbl.type.getName().getNamespaceURI();
            String string2 = "tbl";
            xmlCursor.beginElement(string2, string);
            xmlCursor.toParent();
            CTTbl cTTbl = (CTTbl)xmlCursor.getObject();
            XWPFTable xWPFTable = new XWPFTable(cTTbl, this);
            XmlObject xmlObject = null;
            while (!(xmlObject instanceof CTTbl) && xmlCursor.toPrevSibling()) {
                xmlObject = xmlCursor.getObject();
            }
            if (!(xmlObject instanceof CTTbl)) {
                this.tables.add(0, xWPFTable);
            } else {
                n = this.tables.indexOf(this.getTable((CTTbl)xmlObject)) + 1;
                this.tables.add(n, xWPFTable);
            }
            n = 0;
            XmlCursor xmlCursor2 = cTTbl.newCursor();
            try {
                xmlCursor.toCursor(xmlCursor2);
                while (xmlCursor.toPrevSibling()) {
                    xmlObject = xmlCursor.getObject();
                    if (!(xmlObject instanceof CTP) && !(xmlObject instanceof CTTbl)) continue;
                    ++n;
                }
                this.bodyElements.add(n, xWPFTable);
                xmlCursor.toCursor(xmlCursor2);
                xmlCursor.toEndToken();
                XWPFTable xWPFTable2 = xWPFTable;
                return xWPFTable2;
            }
            finally {
                xmlCursor2.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCursorInBody(XmlCursor xmlCursor) {
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        xmlCursor2.toParent();
        try {
            boolean bl = xmlCursor2.getObject() == this.ctDocument.getBody();
            return bl;
        }
        finally {
            xmlCursor2.dispose();
        }
    }

    private int getPosOfBodyElement(IBodyElement iBodyElement) {
        BodyElementType bodyElementType = iBodyElement.getElementType();
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            IBodyElement iBodyElement2 = this.bodyElements.get(i);
            if (iBodyElement2.getElementType() != bodyElementType || !iBodyElement2.equals(iBodyElement)) continue;
            return i;
        }
        return -1;
    }

    public int getPosOfParagraph(XWPFParagraph xWPFParagraph) {
        return this.getPosOfBodyElement(xWPFParagraph);
    }

    public int getPosOfTable(XWPFTable xWPFTable) {
        return this.getPosOfBodyElement(xWPFTable);
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDocument1.type.getName().getNamespaceURI(), "document"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        hashMap.put("urn:schemas-microsoft-com:office:office", "o");
        hashMap.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        hashMap.put("urn:schemas-microsoft-com:vml", "v");
        hashMap.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        hashMap.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        hashMap.put("urn:schemas-microsoft-com:office:word", "w10");
        hashMap.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        hashMap.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.ctDocument.save(outputStream, xmlOptions);
        outputStream.close();
    }

    private int getRelationIndex(XWPFRelation xWPFRelation) {
        List<POIXMLDocumentPart> list = this.getRelations();
        int n = 1;
        for (POIXMLDocumentPart pOIXMLDocumentPart : list) {
            if (!pOIXMLDocumentPart.getPackageRelationship().getRelationshipType().equals(xWPFRelation.getRelation())) continue;
            ++n;
        }
        return n;
    }

    public XWPFParagraph createParagraph() {
        XWPFParagraph xWPFParagraph = new XWPFParagraph(this.ctDocument.getBody().addNewP(), this);
        this.bodyElements.add(xWPFParagraph);
        this.paragraphs.add(xWPFParagraph);
        return xWPFParagraph;
    }

    public XWPFNumbering createNumbering() {
        if (this.numbering == null) {
            NumberingDocument numberingDocument = NumberingDocument.Factory.newInstance();
            XWPFRelation xWPFRelation = XWPFRelation.NUMBERING;
            int n = this.getRelationIndex(xWPFRelation);
            XWPFNumbering xWPFNumbering = (XWPFNumbering)this.createRelationship(xWPFRelation, XWPFFactory.getInstance(), n);
            xWPFNumbering.setNumbering(numberingDocument.addNewNumbering());
            this.numbering = xWPFNumbering;
        }
        return this.numbering;
    }

    public XWPFStyles createStyles() {
        if (this.styles == null) {
            StylesDocument stylesDocument = StylesDocument.Factory.newInstance();
            XWPFRelation xWPFRelation = XWPFRelation.STYLES;
            int n = this.getRelationIndex(xWPFRelation);
            XWPFStyles xWPFStyles = (XWPFStyles)this.createRelationship(xWPFRelation, XWPFFactory.getInstance(), n);
            xWPFStyles.setStyles(stylesDocument.addNewStyles());
            this.styles = xWPFStyles;
        }
        return this.styles;
    }

    public XWPFFootnotes createFootnotes() {
        if (this.footnotes == null) {
            FootnotesDocument footnotesDocument = FootnotesDocument.Factory.newInstance();
            XWPFRelation xWPFRelation = XWPFRelation.FOOTNOTE;
            int n = this.getRelationIndex(xWPFRelation);
            XWPFFootnotes xWPFFootnotes = (XWPFFootnotes)this.createRelationship(xWPFRelation, XWPFFactory.getInstance(), n);
            xWPFFootnotes.setFootnotes(footnotesDocument.addNewFootnotes());
            this.footnotes = xWPFFootnotes;
        }
        return this.footnotes;
    }

    public XWPFFootnote addFootnote(CTFtnEdn cTFtnEdn) {
        return this.footnotes.addFootnote(cTFtnEdn);
    }

    public XWPFFootnote addEndnote(CTFtnEdn cTFtnEdn) {
        XWPFFootnote xWPFFootnote = new XWPFFootnote(this, cTFtnEdn);
        this.endnotes.put(cTFtnEdn.getId().intValue(), xWPFFootnote);
        return xWPFFootnote;
    }

    public boolean removeBodyElement(int n) {
        if (n >= 0 && n < this.bodyElements.size()) {
            int n2;
            BodyElementType bodyElementType = this.bodyElements.get(n).getElementType();
            if (bodyElementType == BodyElementType.TABLE) {
                n2 = this.getTablePos(n);
                this.tables.remove(n2);
                this.ctDocument.getBody().removeTbl(n2);
            }
            if (bodyElementType == BodyElementType.PARAGRAPH) {
                n2 = this.getParagraphPos(n);
                this.paragraphs.remove(n2);
                this.ctDocument.getBody().removeP(n2);
            }
            this.bodyElements.remove(n);
            return true;
        }
        return false;
    }

    public void setParagraph(XWPFParagraph xWPFParagraph, int n) {
        this.paragraphs.set(n, xWPFParagraph);
        this.ctDocument.getBody().setPArray(n, xWPFParagraph.getCTP());
    }

    public XWPFParagraph getLastParagraph() {
        int n = this.paragraphs.toArray().length - 1;
        return this.paragraphs.get(n);
    }

    public XWPFTable createTable() {
        XWPFTable xWPFTable = new XWPFTable(this.ctDocument.getBody().addNewTbl(), this);
        this.bodyElements.add(xWPFTable);
        this.tables.add(xWPFTable);
        return xWPFTable;
    }

    public XWPFTable createTable(int n, int n2) {
        XWPFTable xWPFTable = new XWPFTable(this.ctDocument.getBody().addNewTbl(), this, n, n2);
        this.bodyElements.add(xWPFTable);
        this.tables.add(xWPFTable);
        return xWPFTable;
    }

    public void createTOC() {
        CTSdtBlock cTSdtBlock = this.getDocument().getBody().addNewSdt();
        TOC tOC = new TOC(cTSdtBlock);
        for (XWPFParagraph xWPFParagraph : this.paragraphs) {
            String string = xWPFParagraph.getStyle();
            if (string == null || !string.startsWith("Heading")) continue;
            try {
                int n = Integer.parseInt(string.substring("Heading".length()));
                tOC.addRow(n, xWPFParagraph.getText(), 1, "112723803");
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    public void setTable(int n, XWPFTable xWPFTable) {
        this.tables.set(n, xWPFTable);
        this.ctDocument.getBody().setTblArray(n, xWPFTable.getCTTbl());
    }

    public boolean isEnforcedReadonlyProtection() {
        return this.settings.isEnforcedWith(STDocProtect.READ_ONLY);
    }

    public boolean isEnforcedFillingFormsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.FORMS);
    }

    public boolean isEnforcedCommentsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.COMMENTS);
    }

    public boolean isEnforcedTrackedChangesProtection() {
        return this.settings.isEnforcedWith(STDocProtect.TRACKED_CHANGES);
    }

    public boolean isEnforcedUpdateFields() {
        return this.settings.isUpdateFields();
    }

    public void enforceReadonlyProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY);
    }

    public void enforceReadonlyProtection(String string, HashAlgorithm hashAlgorithm) {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY, string, hashAlgorithm);
    }

    public void enforceFillingFormsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS);
    }

    public void enforceFillingFormsProtection(String string, HashAlgorithm hashAlgorithm) {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS, string, hashAlgorithm);
    }

    public void enforceCommentsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS);
    }

    public void enforceCommentsProtection(String string, HashAlgorithm hashAlgorithm) {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS, string, hashAlgorithm);
    }

    public void enforceTrackedChangesProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES);
    }

    public void enforceTrackedChangesProtection(String string, HashAlgorithm hashAlgorithm) {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES, string, hashAlgorithm);
    }

    public boolean validateProtectionPassword(String string) {
        return this.settings.validateProtectionPassword(string);
    }

    public void removeProtectionEnforcement() {
        this.settings.removeEnforcement();
    }

    public void enforceUpdateFields() {
        this.settings.setUpdateFields();
    }

    public boolean isTrackRevisions() {
        return this.settings.isTrackRevisions();
    }

    public void setTrackRevisions(boolean bl) {
        this.settings.setTrackRevisions(bl);
    }

    public long getZoomPercent() {
        return this.settings.getZoomPercent();
    }

    public void setZoomPercent(long l) {
        this.settings.setZoomPercent(l);
    }

    @Override
    public void insertTable(int n, XWPFTable xWPFTable) {
        this.bodyElements.add(n, xWPFTable);
        int n2 = 0;
        for (CTTbl cTTbl : this.ctDocument.getBody().getTblArray()) {
            if (cTTbl == xWPFTable.getCTTbl()) break;
            ++n2;
        }
        this.tables.add(n2, xWPFTable);
    }

    public List<XWPFPictureData> getAllPictures() {
        return Collections.unmodifiableList(this.pictures);
    }

    public List<XWPFPictureData> getAllPackagePictures() {
        ArrayList<XWPFPictureData> arrayList = new ArrayList<XWPFPictureData>();
        Collection<List<XWPFPictureData>> collection = this.packagePictures.values();
        for (List<XWPFPictureData> list : collection) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    void registerPackagePictureData(XWPFPictureData xWPFPictureData) {
        List<XWPFPictureData> list = this.packagePictures.get(xWPFPictureData.getChecksum());
        if (list == null) {
            list = new ArrayList<XWPFPictureData>(1);
            this.packagePictures.put(xWPFPictureData.getChecksum(), list);
        }
        if (!list.contains(xWPFPictureData)) {
            list.add(xWPFPictureData);
        }
    }

    XWPFPictureData findPackagePictureData(byte[] byArray, int n) {
        long l = IOUtils.calculateChecksum(byArray);
        XWPFPictureData xWPFPictureData = null;
        List<XWPFPictureData> list = this.packagePictures.get(l);
        if (list != null) {
            Iterator<XWPFPictureData> iterator = list.iterator();
            while (iterator.hasNext() && xWPFPictureData == null) {
                XWPFPictureData xWPFPictureData2 = iterator.next();
                if (!Arrays.equals(byArray, xWPFPictureData2.getData())) continue;
                xWPFPictureData = xWPFPictureData2;
            }
        }
        return xWPFPictureData;
    }

    public String addPictureData(byte[] byArray, int n) throws InvalidFormatException {
        XWPFPictureData xWPFPictureData = this.findPackagePictureData(byArray, n);
        POIXMLRelation pOIXMLRelation = XWPFPictureData.RELATIONS[n];
        if (xWPFPictureData == null) {
            int n2 = this.getNextPicNameNumber(n);
            xWPFPictureData = (XWPFPictureData)this.createRelationship(pOIXMLRelation, XWPFFactory.getInstance(), n2);
            PackagePart packagePart = xWPFPictureData.getPackagePart();
            OutputStream outputStream = null;
            try {
                outputStream = packagePart.getOutputStream();
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new POIXMLException(iOException);
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.registerPackagePictureData(xWPFPictureData);
            this.pictures.add(xWPFPictureData);
            return this.getRelationId(xWPFPictureData);
        }
        if (!this.getRelations().contains(xWPFPictureData)) {
            PackagePart packagePart = xWPFPictureData.getPackagePart();
            TargetMode targetMode = TargetMode.INTERNAL;
            PackagePartName packagePartName = packagePart.getPartName();
            String string = pOIXMLRelation.getRelation();
            PackageRelationship packageRelationship = this.getPackagePart().addRelationship(packagePartName, targetMode, string);
            String string2 = packageRelationship.getId();
            this.addRelation(string2, xWPFPictureData);
            this.pictures.add(xWPFPictureData);
            return string2;
        }
        return this.getRelationId(xWPFPictureData);
    }

    public String addPictureData(InputStream inputStream, int n) throws InvalidFormatException {
        try {
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return this.addPictureData(byArray, n);
        }
        catch (IOException iOException) {
            throw new POIXMLException(iOException);
        }
    }

    public int getNextPicNameNumber(int n) throws InvalidFormatException {
        int n2 = this.getAllPackagePictures().size() + 1;
        String string = XWPFPictureData.RELATIONS[n].getFileName(n2);
        PackagePartName packagePartName = PackagingURIHelper.createPartName(string);
        while (this.getPackage().getPart(packagePartName) != null) {
            string = XWPFPictureData.RELATIONS[n].getFileName(++n2);
            packagePartName = PackagingURIHelper.createPartName(string);
        }
        return n2;
    }

    public XWPFPictureData getPictureDataByID(String string) {
        POIXMLDocumentPart pOIXMLDocumentPart = this.getRelationById(string);
        if (pOIXMLDocumentPart instanceof XWPFPictureData) {
            XWPFPictureData xWPFPictureData = (XWPFPictureData)pOIXMLDocumentPart;
            return xWPFPictureData;
        }
        return null;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public XWPFStyles getStyles() {
        return this.styles;
    }

    @Override
    public XWPFParagraph getParagraph(CTP cTP) {
        for (int i = 0; i < this.getParagraphs().size(); ++i) {
            if (this.getParagraphs().get(i).getCTP() != cTP) continue;
            return this.getParagraphs().get(i);
        }
        return null;
    }

    @Override
    public XWPFTable getTable(CTTbl cTTbl) {
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.getTables().get(i).getCTTbl() != cTTbl) continue;
            return this.getTables().get(i);
        }
        return null;
    }

    public Iterator<XWPFTable> getTablesIterator() {
        return this.tables.iterator();
    }

    public Iterator<XWPFParagraph> getParagraphsIterator() {
        return this.paragraphs.iterator();
    }

    @Override
    public XWPFParagraph getParagraphArray(int n) {
        if (n >= 0 && n < this.paragraphs.size()) {
            return this.paragraphs.get(n);
        }
        return null;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this;
    }

    @Override
    public BodyType getPartType() {
        return BodyType.DOCUMENT;
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cTTc) {
        XmlCursor xmlCursor = cTTc.newCursor();
        xmlCursor.toParent();
        XmlObject xmlObject = xmlCursor.getObject();
        if (!(xmlObject instanceof CTRow)) {
            return null;
        }
        CTRow cTRow = (CTRow)xmlObject;
        xmlCursor.toParent();
        xmlObject = xmlCursor.getObject();
        xmlCursor.dispose();
        if (!(xmlObject instanceof CTTbl)) {
            return null;
        }
        CTTbl cTTbl = (CTTbl)xmlObject;
        XWPFTable xWPFTable = this.getTable(cTTbl);
        if (xWPFTable == null) {
            return null;
        }
        XWPFTableRow xWPFTableRow = xWPFTable.getRow(cTRow);
        if (xWPFTableRow == null) {
            return null;
        }
        return xWPFTableRow.getTableCell(cTTc);
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this;
    }
}

