/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParagraphAlignment {
    LEFT(1),
    CENTER(2),
    RIGHT(3),
    BOTH(4),
    MEDIUM_KASHIDA(5),
    DISTRIBUTE(6),
    NUM_TAB(7),
    HIGH_KASHIDA(8),
    LOW_KASHIDA(9),
    THAI_DISTRIBUTE(10);

    private static Map<Integer, ParagraphAlignment> imap;
    private final int value;

    private ParagraphAlignment(int n2) {
        this.value = n2;
    }

    public static ParagraphAlignment valueOf(int n) {
        ParagraphAlignment paragraphAlignment = imap.get(n);
        if (paragraphAlignment == null) {
            throw new IllegalArgumentException("Unknown paragraph alignment: " + n);
        }
        return paragraphAlignment;
    }

    public int getValue() {
        return this.value;
    }

    static {
        imap = new HashMap<Integer, ParagraphAlignment>();
        for (ParagraphAlignment paragraphAlignment : ParagraphAlignment.values()) {
            imap.put(paragraphAlignment.getValue(), paragraphAlignment);
        }
    }
}

