/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xwpf.extractor;

import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.xwpf.model.XWPFCommentsDecorator;
import ai2.org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import ai2.org.apache.poi.xwpf.usermodel.IBodyElement;
import ai2.org.apache.poi.xwpf.usermodel.ICell;
import ai2.org.apache.poi.xwpf.usermodel.IRunElement;
import ai2.org.apache.poi.xwpf.usermodel.XWPFDocument;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import ai2.org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import ai2.org.apache.poi.xwpf.usermodel.XWPFParagraph;
import ai2.org.apache.poi.xwpf.usermodel.XWPFRelation;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDT;
import ai2.org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTable;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableCell;
import ai2.org.apache.poi.xwpf.usermodel.XWPFTableRow;
import java.io.IOException;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class XWPFWordExtractor
extends POIXMLTextExtractor {
    public static final XWPFRelation[] SUPPORTED_TYPES = new XWPFRelation[]{XWPFRelation.DOCUMENT, XWPFRelation.TEMPLATE, XWPFRelation.MACRO_DOCUMENT, XWPFRelation.MACRO_TEMPLATE_DOCUMENT};
    private XWPFDocument document;
    private boolean fetchHyperlinks = false;

    public XWPFWordExtractor(OPCPackage oPCPackage) throws XmlException, OpenXML4JException, IOException {
        this(new XWPFDocument(oPCPackage));
    }

    public XWPFWordExtractor(XWPFDocument xWPFDocument) {
        super(xWPFDocument);
        this.document = xWPFDocument;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  XWPFWordExtractor <filename.docx>");
            System.exit(1);
        }
        XWPFWordExtractor xWPFWordExtractor = new XWPFWordExtractor(POIXMLDocument.openPackage(stringArray[0]));
        System.out.println(((POITextExtractor)xWPFWordExtractor).getText());
        xWPFWordExtractor.close();
    }

    public void setFetchHyperlinks(boolean bl) {
        this.fetchHyperlinks = bl;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        XWPFHeaderFooterPolicy xWPFHeaderFooterPolicy = this.document.getHeaderFooterPolicy();
        this.extractHeaders(stringBuffer, xWPFHeaderFooterPolicy);
        for (IBodyElement iBodyElement : this.document.getBodyElements()) {
            this.appendBodyElementText(stringBuffer, iBodyElement);
            stringBuffer.append('\n');
        }
        this.extractFooters(stringBuffer, xWPFHeaderFooterPolicy);
        return stringBuffer.toString();
    }

    public void appendBodyElementText(StringBuffer stringBuffer, IBodyElement iBodyElement) {
        if (iBodyElement instanceof XWPFParagraph) {
            this.appendParagraphText(stringBuffer, (XWPFParagraph)iBodyElement);
        } else if (iBodyElement instanceof XWPFTable) {
            this.appendTableText(stringBuffer, (XWPFTable)iBodyElement);
        } else if (iBodyElement instanceof XWPFSDT) {
            stringBuffer.append(((XWPFSDT)iBodyElement).getContent().getText());
        }
    }

    public void appendParagraphText(StringBuffer stringBuffer, XWPFParagraph xWPFParagraph) {
        Object object;
        CTSectPr cTSectPr = null;
        if (xWPFParagraph.getCTP().getPPr() != null) {
            cTSectPr = xWPFParagraph.getCTP().getPPr().getSectPr();
        }
        XWPFHeaderFooterPolicy xWPFHeaderFooterPolicy = null;
        if (cTSectPr != null) {
            xWPFHeaderFooterPolicy = new XWPFHeaderFooterPolicy(this.document, cTSectPr);
            this.extractHeaders(stringBuffer, xWPFHeaderFooterPolicy);
        }
        for (IRunElement object22 : xWPFParagraph.getRuns()) {
            stringBuffer.append(object22.toString());
            if (!(object22 instanceof XWPFHyperlinkRun) || !this.fetchHyperlinks || (object = ((XWPFHyperlinkRun)object22).getHyperlink(this.document)) == null) continue;
            stringBuffer.append(" <" + ((XWPFHyperlink)object).getURL() + ">");
        }
        XWPFCommentsDecorator xWPFCommentsDecorator = new XWPFCommentsDecorator(xWPFParagraph, null);
        String string = xWPFCommentsDecorator.getCommentText();
        if (string.length() > 0) {
            stringBuffer.append(string).append('\n');
        }
        if ((object = xWPFParagraph.getFootnoteText()) != null && ((String)object).length() > 0) {
            stringBuffer.append((String)object + '\n');
        }
        if (cTSectPr != null) {
            this.extractFooters(stringBuffer, xWPFHeaderFooterPolicy);
        }
    }

    private void appendTableText(StringBuffer stringBuffer, XWPFTable xWPFTable) {
        for (XWPFTableRow xWPFTableRow : xWPFTable.getRows()) {
            List<ICell> list = xWPFTableRow.getTableICells();
            for (int i = 0; i < list.size(); ++i) {
                ICell iCell = list.get(i);
                if (iCell instanceof XWPFTableCell) {
                    stringBuffer.append(((XWPFTableCell)iCell).getTextRecursively());
                } else if (iCell instanceof XWPFSDTCell) {
                    stringBuffer.append(((XWPFSDTCell)iCell).getContent().getText());
                }
                if (i >= list.size() - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append('\n');
        }
    }

    private void extractFooters(StringBuffer stringBuffer, XWPFHeaderFooterPolicy xWPFHeaderFooterPolicy) {
        if (xWPFHeaderFooterPolicy == null) {
            return;
        }
        if (xWPFHeaderFooterPolicy.getFirstPageFooter() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getFirstPageFooter().getText());
        }
        if (xWPFHeaderFooterPolicy.getEvenPageFooter() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getEvenPageFooter().getText());
        }
        if (xWPFHeaderFooterPolicy.getDefaultFooter() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getDefaultFooter().getText());
        }
    }

    private void extractHeaders(StringBuffer stringBuffer, XWPFHeaderFooterPolicy xWPFHeaderFooterPolicy) {
        if (xWPFHeaderFooterPolicy == null) {
            return;
        }
        if (xWPFHeaderFooterPolicy.getFirstPageHeader() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getFirstPageHeader().getText());
        }
        if (xWPFHeaderFooterPolicy.getEvenPageHeader() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getEvenPageHeader().getText());
        }
        if (xWPFHeaderFooterPolicy.getDefaultHeader() != null) {
            stringBuffer.append(xWPFHeaderFooterPolicy.getDefaultHeader().getText());
        }
    }
}

