/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.helpers;

import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class XSSFPaswordHelper {
    public static void setPassword(XmlObject xmlObject, String string, HashAlgorithm hashAlgorithm, String string2) {
        XmlCursor xmlCursor = xmlObject.newCursor();
        if (string == null) {
            xmlCursor.removeAttribute(XSSFPaswordHelper.getAttrName(string2, "password"));
            xmlCursor.removeAttribute(XSSFPaswordHelper.getAttrName(string2, "algorithmName"));
            xmlCursor.removeAttribute(XSSFPaswordHelper.getAttrName(string2, "hashValue"));
            xmlCursor.removeAttribute(XSSFPaswordHelper.getAttrName(string2, "saltValue"));
            xmlCursor.removeAttribute(XSSFPaswordHelper.getAttrName(string2, "spinCount"));
            return;
        }
        xmlCursor.toFirstContentToken();
        if (hashAlgorithm == null) {
            int n = CryptoFunctions.createXorVerifier1(string);
            xmlCursor.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(string2, "password"), Integer.toHexString(n).toUpperCase(Locale.ROOT));
        } else {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = secureRandom.generateSeed(16);
            int n = 100000;
            byte[] byArray2 = CryptoFunctions.hashPassword(string, hashAlgorithm, byArray, n, false);
            xmlCursor.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(string2, "algorithmName"), hashAlgorithm.jceId);
            xmlCursor.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(string2, "hashValue"), DatatypeConverter.printBase64Binary((byte[])byArray2));
            xmlCursor.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(string2, "saltValue"), DatatypeConverter.printBase64Binary((byte[])byArray));
            xmlCursor.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(string2, "spinCount"), "" + n);
        }
        xmlCursor.dispose();
    }

    public static boolean validatePassword(XmlObject xmlObject, String string, String string2) {
        if (string == null) {
            return false;
        }
        XmlCursor xmlCursor = xmlObject.newCursor();
        String string3 = xmlCursor.getAttributeText(XSSFPaswordHelper.getAttrName(string2, "password"));
        String string4 = xmlCursor.getAttributeText(XSSFPaswordHelper.getAttrName(string2, "algorithmName"));
        String string5 = xmlCursor.getAttributeText(XSSFPaswordHelper.getAttrName(string2, "hashValue"));
        String string6 = xmlCursor.getAttributeText(XSSFPaswordHelper.getAttrName(string2, "saltValue"));
        String string7 = xmlCursor.getAttributeText(XSSFPaswordHelper.getAttrName(string2, "spinCount"));
        xmlCursor.dispose();
        if (string3 != null) {
            int n;
            int n2 = Integer.parseInt(string3, 16);
            return n2 == (n = CryptoFunctions.createXorVerifier1(string));
        }
        if (string5 == null || string4 == null || string6 == null || string7 == null) {
            return false;
        }
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string5);
        HashAlgorithm hashAlgorithm = HashAlgorithm.fromString(string4);
        byte[] byArray2 = DatatypeConverter.parseBase64Binary((String)string6);
        int n = Integer.parseInt(string7);
        byte[] byArray3 = CryptoFunctions.hashPassword(string, hashAlgorithm, byArray2, n, false);
        return Arrays.equals(byArray, byArray3);
    }

    private static QName getAttrName(String string, String string2) {
        if (string == null || "".equals(string)) {
            return new QName(string2);
        }
        return new QName(string + Character.toUpperCase(string2.charAt(0)) + string2.substring(1));
    }
}

