/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.helpers;

import ai2.org.apache.poi.ss.formula.FormulaParser;
import ai2.org.apache.poi.ss.formula.FormulaRenderer;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Pxg;
import ai2.org.apache.poi.ss.formula.ptg.Pxg3D;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFName;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.Iterator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;

public final class XSSFFormulaUtils {
    private final XSSFWorkbook _wb;
    private final XSSFEvaluationWorkbook _fpwb;

    public XSSFFormulaUtils(XSSFWorkbook xSSFWorkbook) {
        this._wb = xSSFWorkbook;
        this._fpwb = XSSFEvaluationWorkbook.create(this._wb);
    }

    public void updateSheetName(int n, String string, String string2) {
        for (int i = 0; i < this._wb.getNumberOfNames(); ++i) {
            Object object = this._wb.getNameAt(i);
            if (((XSSFName)object).getSheetIndex() != -1 && ((XSSFName)object).getSheetIndex() != n) continue;
            this.updateName((XSSFName)object, string, string2);
        }
        for (Object object : this._wb) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                for (Cell cell : row) {
                    if (cell.getCellType() != 2) continue;
                    this.updateFormula((XSSFCell)cell, string, string2);
                }
            }
        }
    }

    private void updateFormula(XSSFCell xSSFCell, String string, String string2) {
        String string3;
        CTCellFormula cTCellFormula = xSSFCell.getCTCell().getF();
        if (cTCellFormula != null && (string3 = cTCellFormula.getStringValue()) != null && string3.length() > 0) {
            Ptg[] ptgArray;
            int n = this._wb.getSheetIndex(xSSFCell.getSheet());
            for (Ptg ptg : ptgArray = FormulaParser.parse(string3, this._fpwb, 0, n)) {
                this.updatePtg(ptg, string, string2);
            }
            String string4 = FormulaRenderer.toFormulaString(this._fpwb, ptgArray);
            if (!string3.equals(string4)) {
                cTCellFormula.setStringValue(string4);
            }
        }
    }

    private void updateName(XSSFName xSSFName, String string, String string2) {
        String string3 = xSSFName.getRefersToFormula();
        if (string3 != null) {
            Ptg[] ptgArray;
            int n = xSSFName.getSheetIndex();
            for (Ptg ptg : ptgArray = FormulaParser.parse(string3, this._fpwb, 4, n)) {
                this.updatePtg(ptg, string, string2);
            }
            String string4 = FormulaRenderer.toFormulaString(this._fpwb, ptgArray);
            if (!string3.equals(string4)) {
                xSSFName.setRefersToFormula(string4);
            }
        }
    }

    private void updatePtg(Ptg ptg, String string, String string2) {
        Pxg pxg;
        if (ptg instanceof Pxg && (pxg = (Pxg)((Object)ptg)).getExternalWorkbookNumber() < 1) {
            Pxg3D pxg3D;
            if (pxg.getSheetName() != null && pxg.getSheetName().equals(string)) {
                pxg.setSheetName(string2);
            }
            if (pxg instanceof Pxg3D && (pxg3D = (Pxg3D)pxg).getLastSheetName() != null && pxg3D.getLastSheetName().equals(string)) {
                pxg3D.setLastSheetName(string2);
            }
        }
    }
}

