/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.extensions;

import ai2.org.apache.poi.ss.usermodel.HeaderFooter;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.helpers.HeaderFooterHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;

public abstract class XSSFHeaderFooter
implements HeaderFooter {
    private HeaderFooterHelper helper;
    private CTHeaderFooter headerFooter;
    private boolean stripFields = false;

    public XSSFHeaderFooter(CTHeaderFooter cTHeaderFooter) {
        this.headerFooter = cTHeaderFooter;
        this.helper = new HeaderFooterHelper();
    }

    @Internal
    public CTHeaderFooter getHeaderFooter() {
        return this.headerFooter;
    }

    public String getValue() {
        String string = this.getText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean areFieldsStripped() {
        return this.stripFields;
    }

    public void setAreFieldsStripped(boolean bl) {
        this.stripFields = bl;
    }

    public static String stripFields(String string) {
        return ai2.org.apache.poi.hssf.usermodel.HeaderFooter.stripFields(string);
    }

    public abstract String getText();

    protected abstract void setText(String var1);

    public String getCenter() {
        String string = this.helper.getCenterSection(this.getText());
        if (this.stripFields) {
            return XSSFHeaderFooter.stripFields(string);
        }
        return string;
    }

    public String getLeft() {
        String string = this.helper.getLeftSection(this.getText());
        if (this.stripFields) {
            return XSSFHeaderFooter.stripFields(string);
        }
        return string;
    }

    public String getRight() {
        String string = this.helper.getRightSection(this.getText());
        if (this.stripFields) {
            return XSSFHeaderFooter.stripFields(string);
        }
        return string;
    }

    public void setCenter(String string) {
        this.setText(this.helper.setCenterSection(this.getText(), string));
    }

    public void setLeft(String string) {
        this.setText(this.helper.setLeftSection(this.getText(), string));
    }

    public void setRight(String string) {
        this.setText(this.helper.setRightSection(this.getText(), string));
    }
}

