/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.extensions;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public final class XSSFCellFill {
    private CTFill _fill;

    public XSSFCellFill(CTFill cTFill) {
        this._fill = cTFill;
    }

    public XSSFCellFill() {
        this._fill = CTFill.Factory.newInstance();
    }

    public XSSFColor getFillBackgroundColor() {
        CTPatternFill cTPatternFill = this._fill.getPatternFill();
        if (cTPatternFill == null) {
            return null;
        }
        CTColor cTColor = cTPatternFill.getBgColor();
        return cTColor == null ? null : new XSSFColor(cTColor);
    }

    public void setFillBackgroundColor(int n) {
        CTPatternFill cTPatternFill = this.ensureCTPatternFill();
        CTColor cTColor = cTPatternFill.isSetBgColor() ? cTPatternFill.getBgColor() : cTPatternFill.addNewBgColor();
        cTColor.setIndexed((long)n);
    }

    public void setFillBackgroundColor(XSSFColor xSSFColor) {
        CTPatternFill cTPatternFill = this.ensureCTPatternFill();
        cTPatternFill.setBgColor(xSSFColor.getCTColor());
    }

    public XSSFColor getFillForegroundColor() {
        CTPatternFill cTPatternFill = this._fill.getPatternFill();
        if (cTPatternFill == null) {
            return null;
        }
        CTColor cTColor = cTPatternFill.getFgColor();
        return cTColor == null ? null : new XSSFColor(cTColor);
    }

    public void setFillForegroundColor(int n) {
        CTPatternFill cTPatternFill = this.ensureCTPatternFill();
        CTColor cTColor = cTPatternFill.isSetFgColor() ? cTPatternFill.getFgColor() : cTPatternFill.addNewFgColor();
        cTColor.setIndexed((long)n);
    }

    public void setFillForegroundColor(XSSFColor xSSFColor) {
        CTPatternFill cTPatternFill = this.ensureCTPatternFill();
        cTPatternFill.setFgColor(xSSFColor.getCTColor());
    }

    public STPatternType.Enum getPatternType() {
        CTPatternFill cTPatternFill = this._fill.getPatternFill();
        return cTPatternFill == null ? null : cTPatternFill.getPatternType();
    }

    public void setPatternType(STPatternType.Enum enum_) {
        CTPatternFill cTPatternFill = this.ensureCTPatternFill();
        cTPatternFill.setPatternType(enum_);
    }

    private CTPatternFill ensureCTPatternFill() {
        CTPatternFill cTPatternFill = this._fill.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = this._fill.addNewPatternFill();
        }
        return cTPatternFill;
    }

    @Internal
    public CTFill getCTFill() {
        return this._fill;
    }

    public int hashCode() {
        return this._fill.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XSSFCellFill)) {
            return false;
        }
        XSSFCellFill xSSFCellFill = (XSSFCellFill)object;
        return this._fill.toString().equals(xSSFCellFill.getCTFill().toString());
    }
}

