/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.extensions;

import ai2.org.apache.poi.ss.usermodel.BorderStyle;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class XSSFCellBorder {
    private ThemesTable _theme;
    private CTBorder border;

    public XSSFCellBorder(CTBorder cTBorder, ThemesTable themesTable) {
        this(cTBorder);
        this._theme = themesTable;
    }

    public XSSFCellBorder(CTBorder cTBorder) {
        this.border = cTBorder;
    }

    public XSSFCellBorder() {
        this.border = CTBorder.Factory.newInstance();
    }

    public void setThemesTable(ThemesTable themesTable) {
        this._theme = themesTable;
    }

    @Internal
    public CTBorder getCTBorder() {
        return this.border;
    }

    public BorderStyle getBorderStyle(BorderSide borderSide) {
        CTBorderPr cTBorderPr = this.getBorder(borderSide);
        STBorderStyle.Enum enum_ = cTBorderPr == null ? STBorderStyle.NONE : cTBorderPr.getStyle();
        return BorderStyle.values()[enum_.intValue() - 1];
    }

    public void setBorderStyle(BorderSide borderSide, BorderStyle borderStyle) {
        this.getBorder(borderSide, true).setStyle(STBorderStyle.Enum.forInt((int)(borderStyle.ordinal() + 1)));
    }

    public XSSFColor getBorderColor(BorderSide borderSide) {
        CTBorderPr cTBorderPr = this.getBorder(borderSide);
        if (cTBorderPr != null && cTBorderPr.isSetColor()) {
            XSSFColor xSSFColor = new XSSFColor(cTBorderPr.getColor());
            if (this._theme != null) {
                this._theme.inheritFromThemeAsRequired(xSSFColor);
            }
            return xSSFColor;
        }
        return null;
    }

    public void setBorderColor(BorderSide borderSide, XSSFColor xSSFColor) {
        CTBorderPr cTBorderPr = this.getBorder(borderSide, true);
        if (xSSFColor == null) {
            cTBorderPr.unsetColor();
        } else {
            cTBorderPr.setColor(xSSFColor.getCTColor());
        }
    }

    private CTBorderPr getBorder(BorderSide borderSide) {
        return this.getBorder(borderSide, false);
    }

    private CTBorderPr getBorder(BorderSide borderSide, boolean bl) {
        CTBorderPr cTBorderPr;
        switch (borderSide) {
            case TOP: {
                cTBorderPr = this.border.getTop();
                if (!bl || cTBorderPr != null) break;
                cTBorderPr = this.border.addNewTop();
                break;
            }
            case RIGHT: {
                cTBorderPr = this.border.getRight();
                if (!bl || cTBorderPr != null) break;
                cTBorderPr = this.border.addNewRight();
                break;
            }
            case BOTTOM: {
                cTBorderPr = this.border.getBottom();
                if (!bl || cTBorderPr != null) break;
                cTBorderPr = this.border.addNewBottom();
                break;
            }
            case LEFT: {
                cTBorderPr = this.border.getLeft();
                if (!bl || cTBorderPr != null) break;
                cTBorderPr = this.border.addNewLeft();
                break;
            }
            default: {
                throw new IllegalArgumentException("No suitable side specified for the border");
            }
        }
        return cTBorderPr;
    }

    public int hashCode() {
        return this.border.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XSSFCellBorder)) {
            return false;
        }
        XSSFCellBorder xSSFCellBorder = (XSSFCellBorder)object;
        return this.border.toString().equals(xSSFCellBorder.getCTBorder().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderSide {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

