/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.AxisCrossBetween;
import ai2.org.apache.poi.ss.usermodel.charts.AxisCrosses;
import ai2.org.apache.poi.ss.usermodel.charts.AxisOrientation;
import ai2.org.apache.poi.ss.usermodel.charts.AxisPosition;
import ai2.org.apache.poi.ss.usermodel.charts.AxisTickMark;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.ss.usermodel.charts.ValueAxis;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTickMark;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STCrossBetween;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickLblPos;

public class XSSFValueAxis
extends XSSFChartAxis
implements ValueAxis {
    private CTValAx ctValAx;

    public XSSFValueAxis(XSSFChart xSSFChart, long l, AxisPosition axisPosition) {
        super(xSSFChart);
        this.createAxis(l, axisPosition);
    }

    public XSSFValueAxis(XSSFChart xSSFChart, CTValAx cTValAx) {
        super(xSSFChart);
        this.ctValAx = cTValAx;
    }

    public long getId() {
        return this.ctValAx.getAxId().getVal();
    }

    public void setCrossBetween(AxisCrossBetween axisCrossBetween) {
        this.ctValAx.getCrossBetween().setVal(XSSFValueAxis.fromCrossBetween(axisCrossBetween));
    }

    public AxisCrossBetween getCrossBetween() {
        return XSSFValueAxis.toCrossBetween(this.ctValAx.getCrossBetween().getVal());
    }

    protected CTAxPos getCTAxPos() {
        return this.ctValAx.getAxPos();
    }

    protected CTNumFmt getCTNumFmt() {
        if (this.ctValAx.isSetNumFmt()) {
            return this.ctValAx.getNumFmt();
        }
        return this.ctValAx.addNewNumFmt();
    }

    protected CTScaling getCTScaling() {
        return this.ctValAx.getScaling();
    }

    protected CTCrosses getCTCrosses() {
        return this.ctValAx.getCrosses();
    }

    protected CTBoolean getDelete() {
        return this.ctValAx.getDelete();
    }

    protected CTTickMark getMajorCTTickMark() {
        return this.ctValAx.getMajorTickMark();
    }

    protected CTTickMark getMinorCTTickMark() {
        return this.ctValAx.getMinorTickMark();
    }

    public void crossAxis(ChartAxis chartAxis) {
        this.ctValAx.getCrossAx().setVal(chartAxis.getId());
    }

    private void createAxis(long l, AxisPosition axisPosition) {
        this.ctValAx = this.chart.getCTChart().getPlotArea().addNewValAx();
        this.ctValAx.addNewAxId().setVal(l);
        this.ctValAx.addNewAxPos();
        this.ctValAx.addNewScaling();
        this.ctValAx.addNewCrossBetween();
        this.ctValAx.addNewCrosses();
        this.ctValAx.addNewCrossAx();
        this.ctValAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        this.ctValAx.addNewDelete();
        this.ctValAx.addNewMajorTickMark();
        this.ctValAx.addNewMinorTickMark();
        this.setPosition(axisPosition);
        this.setOrientation(AxisOrientation.MIN_MAX);
        this.setCrossBetween(AxisCrossBetween.MIDPOINT_CATEGORY);
        this.setCrosses(AxisCrosses.AUTO_ZERO);
        this.setVisible(true);
        this.setMajorTickMark(AxisTickMark.CROSS);
        this.setMinorTickMark(AxisTickMark.NONE);
    }

    private static STCrossBetween.Enum fromCrossBetween(AxisCrossBetween axisCrossBetween) {
        switch (axisCrossBetween) {
            case BETWEEN: {
                return STCrossBetween.BETWEEN;
            }
            case MIDPOINT_CATEGORY: {
                return STCrossBetween.MID_CAT;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisCrossBetween toCrossBetween(STCrossBetween.Enum enum_) {
        switch (enum_.intValue()) {
            case 1: {
                return AxisCrossBetween.BETWEEN;
            }
            case 2: {
                return AxisCrossBetween.MIDPOINT_CATEGORY;
            }
        }
        throw new IllegalArgumentException();
    }
}

