/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.Chart;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.ss.usermodel.charts.ChartDataSource;
import ai2.org.apache.poi.ss.usermodel.charts.ScatterChartData;
import ai2.org.apache.poi.ss.usermodel.charts.ScatterChartSeries;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.charts.AbstractXSSFChartSeries;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartUtil;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STScatterStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFScatterChartData
implements ScatterChartData {
    private List<Series> series = new ArrayList<Series>();

    @Override
    public ScatterChartSeries addSerie(ChartDataSource<?> chartDataSource, ChartDataSource<? extends Number> chartDataSource2) {
        if (!chartDataSource2.isNumeric()) {
            throw new IllegalArgumentException("Y axis data source must be numeric.");
        }
        int n = this.series.size();
        Series series = new Series(n, n, chartDataSource, chartDataSource2);
        this.series.add(series);
        return series;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... chartAxisArray) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xSSFChart = (XSSFChart)chart;
        CTPlotArea cTPlotArea = xSSFChart.getCTChart().getPlotArea();
        CTScatterChart cTScatterChart = cTPlotArea.addNewScatterChart();
        this.addStyle(cTScatterChart);
        for (Series series : this.series) {
            series.addToChart(cTScatterChart);
        }
        for (ChartAxis chartAxis : chartAxisArray) {
            cTScatterChart.addNewAxId().setVal(chartAxis.getId());
        }
    }

    public List<? extends Series> getSeries() {
        return this.series;
    }

    private void addStyle(CTScatterChart cTScatterChart) {
        CTScatterStyle cTScatterStyle = cTScatterChart.addNewScatterStyle();
        cTScatterStyle.setVal(STScatterStyle.LINE_MARKER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Series
    extends AbstractXSSFChartSeries
    implements ScatterChartSeries {
        private int id;
        private int order;
        private ChartDataSource<?> xs;
        private ChartDataSource<? extends Number> ys;

        protected Series(int n, int n2, ChartDataSource<?> chartDataSource, ChartDataSource<? extends Number> chartDataSource2) {
            this.id = n;
            this.order = n2;
            this.xs = chartDataSource;
            this.ys = chartDataSource2;
        }

        @Override
        public ChartDataSource<?> getXValues() {
            return this.xs;
        }

        @Override
        public ChartDataSource<? extends Number> getYValues() {
            return this.ys;
        }

        protected void addToChart(CTScatterChart cTScatterChart) {
            CTScatterSer cTScatterSer = cTScatterChart.addNewSer();
            cTScatterSer.addNewIdx().setVal((long)this.id);
            cTScatterSer.addNewOrder().setVal((long)this.order);
            CTAxDataSource cTAxDataSource = cTScatterSer.addNewXVal();
            XSSFChartUtil.buildAxDataSource(cTAxDataSource, this.xs);
            CTNumDataSource cTNumDataSource = cTScatterSer.addNewYVal();
            XSSFChartUtil.buildNumDataSource(cTNumDataSource, this.ys);
            if (this.isTitleSet()) {
                cTScatterSer.setTx(this.getCTSerTx());
            }
        }
    }
}

