/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.ChartDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XSSFChartUtil {
    private XSSFChartUtil() {
    }

    public static void buildAxDataSource(CTAxDataSource cTAxDataSource, ChartDataSource<?> chartDataSource) {
        if (chartDataSource.isNumeric()) {
            if (chartDataSource.isReference()) {
                XSSFChartUtil.buildNumRef(cTAxDataSource.addNewNumRef(), chartDataSource);
            } else {
                XSSFChartUtil.buildNumLit(cTAxDataSource.addNewNumLit(), chartDataSource);
            }
        } else if (chartDataSource.isReference()) {
            XSSFChartUtil.buildStrRef(cTAxDataSource.addNewStrRef(), chartDataSource);
        } else {
            XSSFChartUtil.buildStrLit(cTAxDataSource.addNewStrLit(), chartDataSource);
        }
    }

    public static void buildNumDataSource(CTNumDataSource cTNumDataSource, ChartDataSource<? extends Number> chartDataSource) {
        if (chartDataSource.isReference()) {
            XSSFChartUtil.buildNumRef(cTNumDataSource.addNewNumRef(), chartDataSource);
        } else {
            XSSFChartUtil.buildNumLit(cTNumDataSource.addNewNumLit(), chartDataSource);
        }
    }

    private static void buildNumRef(CTNumRef cTNumRef, ChartDataSource<?> chartDataSource) {
        cTNumRef.setF(chartDataSource.getFormulaString());
        CTNumData cTNumData = cTNumRef.addNewNumCache();
        XSSFChartUtil.fillNumCache(cTNumData, chartDataSource);
    }

    private static void buildNumLit(CTNumData cTNumData, ChartDataSource<?> chartDataSource) {
        XSSFChartUtil.fillNumCache(cTNumData, chartDataSource);
    }

    private static void buildStrRef(CTStrRef cTStrRef, ChartDataSource<?> chartDataSource) {
        cTStrRef.setF(chartDataSource.getFormulaString());
        CTStrData cTStrData = cTStrRef.addNewStrCache();
        XSSFChartUtil.fillStringCache(cTStrData, chartDataSource);
    }

    private static void buildStrLit(CTStrData cTStrData, ChartDataSource<?> chartDataSource) {
        XSSFChartUtil.fillStringCache(cTStrData, chartDataSource);
    }

    private static void fillStringCache(CTStrData cTStrData, ChartDataSource<?> chartDataSource) {
        int n = chartDataSource.getPointCount();
        cTStrData.addNewPtCount().setVal((long)n);
        for (int i = 0; i < n; ++i) {
            Object obj = chartDataSource.getPointAt(i);
            if (obj == null) continue;
            CTStrVal cTStrVal = cTStrData.addNewPt();
            cTStrVal.setIdx((long)i);
            cTStrVal.setV(obj.toString());
        }
    }

    private static void fillNumCache(CTNumData cTNumData, ChartDataSource<?> chartDataSource) {
        int n = chartDataSource.getPointCount();
        cTNumData.addNewPtCount().setVal((long)n);
        for (int i = 0; i < n; ++i) {
            Number number = (Number)chartDataSource.getPointAt(i);
            if (number == null) continue;
            CTNumVal cTNumVal = cTNumData.addNewPt();
            cTNumVal.setIdx((long)i);
            cTNumVal.setV(number.toString());
        }
    }
}

