/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.ChartLegend;
import ai2.org.apache.poi.ss.usermodel.charts.LegendPosition;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFManualLayout;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLegend;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLegendPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLegendPos;

public final class XSSFChartLegend
implements ChartLegend {
    private CTLegend legend;

    public XSSFChartLegend(XSSFChart xSSFChart) {
        CTChart cTChart = xSSFChart.getCTChart();
        this.legend = cTChart.isSetLegend() ? cTChart.getLegend() : cTChart.addNewLegend();
        this.setDefaults();
    }

    private void setDefaults() {
        if (!this.legend.isSetOverlay()) {
            this.legend.addNewOverlay();
        }
        this.legend.getOverlay().setVal(false);
    }

    @Internal
    public CTLegend getCTLegend() {
        return this.legend;
    }

    public void setPosition(LegendPosition legendPosition) {
        if (!this.legend.isSetLegendPos()) {
            this.legend.addNewLegendPos();
        }
        this.legend.getLegendPos().setVal(this.fromLegendPosition(legendPosition));
    }

    public LegendPosition getPosition() {
        if (this.legend.isSetLegendPos()) {
            return this.toLegendPosition(this.legend.getLegendPos());
        }
        return LegendPosition.RIGHT;
    }

    public XSSFManualLayout getManualLayout() {
        if (!this.legend.isSetLayout()) {
            this.legend.addNewLayout();
        }
        return new XSSFManualLayout(this.legend.getLayout());
    }

    public boolean isOverlay() {
        return this.legend.getOverlay().getVal();
    }

    public void setOverlay(boolean bl) {
        this.legend.getOverlay().setVal(bl);
    }

    private STLegendPos.Enum fromLegendPosition(LegendPosition legendPosition) {
        switch (legendPosition) {
            case BOTTOM: {
                return STLegendPos.B;
            }
            case LEFT: {
                return STLegendPos.L;
            }
            case RIGHT: {
                return STLegendPos.R;
            }
            case TOP: {
                return STLegendPos.T;
            }
            case TOP_RIGHT: {
                return STLegendPos.TR;
            }
        }
        throw new IllegalArgumentException();
    }

    private LegendPosition toLegendPosition(CTLegendPos cTLegendPos) {
        switch (cTLegendPos.getVal().intValue()) {
            case 1: {
                return LegendPosition.BOTTOM;
            }
            case 3: {
                return LegendPosition.LEFT;
            }
            case 4: {
                return LegendPosition.RIGHT;
            }
            case 5: {
                return LegendPosition.TOP;
            }
            case 2: {
                return LegendPosition.TOP_RIGHT;
            }
        }
        throw new IllegalArgumentException();
    }
}

