/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel.charts;

import ai2.org.apache.poi.ss.usermodel.charts.AxisCrosses;
import ai2.org.apache.poi.ss.usermodel.charts.AxisOrientation;
import ai2.org.apache.poi.ss.usermodel.charts.AxisPosition;
import ai2.org.apache.poi.ss.usermodel.charts.AxisTickMark;
import ai2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.charts.XSSFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTickMark;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickLblPos;

public class XSSFCategoryAxis
extends XSSFChartAxis {
    private CTCatAx ctCatAx;

    public XSSFCategoryAxis(XSSFChart xSSFChart, long l, AxisPosition axisPosition) {
        super(xSSFChart);
        this.createAxis(l, axisPosition);
    }

    public XSSFCategoryAxis(XSSFChart xSSFChart, CTCatAx cTCatAx) {
        super(xSSFChart);
        this.ctCatAx = cTCatAx;
    }

    public long getId() {
        return this.ctCatAx.getAxId().getVal();
    }

    protected CTAxPos getCTAxPos() {
        return this.ctCatAx.getAxPos();
    }

    protected CTNumFmt getCTNumFmt() {
        if (this.ctCatAx.isSetNumFmt()) {
            return this.ctCatAx.getNumFmt();
        }
        return this.ctCatAx.addNewNumFmt();
    }

    protected CTScaling getCTScaling() {
        return this.ctCatAx.getScaling();
    }

    protected CTCrosses getCTCrosses() {
        return this.ctCatAx.getCrosses();
    }

    protected CTBoolean getDelete() {
        return this.ctCatAx.getDelete();
    }

    protected CTTickMark getMajorCTTickMark() {
        return this.ctCatAx.getMajorTickMark();
    }

    protected CTTickMark getMinorCTTickMark() {
        return this.ctCatAx.getMinorTickMark();
    }

    public void crossAxis(ChartAxis chartAxis) {
        this.ctCatAx.getCrossAx().setVal(chartAxis.getId());
    }

    private void createAxis(long l, AxisPosition axisPosition) {
        this.ctCatAx = this.chart.getCTChart().getPlotArea().addNewCatAx();
        this.ctCatAx.addNewAxId().setVal(l);
        this.ctCatAx.addNewAxPos();
        this.ctCatAx.addNewScaling();
        this.ctCatAx.addNewCrosses();
        this.ctCatAx.addNewCrossAx();
        this.ctCatAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        this.ctCatAx.addNewDelete();
        this.ctCatAx.addNewMajorTickMark();
        this.ctCatAx.addNewMinorTickMark();
        this.setPosition(axisPosition);
        this.setOrientation(AxisOrientation.MIN_MAX);
        this.setCrosses(AxisCrosses.AUTO_ZERO);
        this.setVisible(true);
        this.setMajorTickMark(AxisTickMark.CROSS);
        this.setMinorTickMark(AxisTickMark.NONE);
    }
}

