/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.CalculationChain;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFRow
implements Row,
Comparable<XSSFRow> {
    private final CTRow _row;
    private final TreeMap<Integer, XSSFCell> _cells;
    private final XSSFSheet _sheet;

    protected XSSFRow(CTRow cTRow, XSSFSheet xSSFSheet) {
        this._row = cTRow;
        this._sheet = xSSFSheet;
        this._cells = new TreeMap();
        for (CTCell cTCell : cTRow.getCArray()) {
            XSSFCell xSSFCell = new XSSFCell(this, cTCell);
            this._cells.put(xSSFCell.getColumnIndex(), xSSFCell);
            xSSFSheet.onReadCell(xSSFCell);
        }
    }

    @Override
    public XSSFSheet getSheet() {
        return this._sheet;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this._cells.values().iterator();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    @Override
    public int compareTo(XSSFRow xSSFRow) {
        int n = this.getRowNum();
        if (xSSFRow.getSheet() != this.getSheet()) {
            throw new IllegalArgumentException("The compared rows must belong to the same XSSFSheet");
        }
        int n2 = xSSFRow.getRowNum();
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    @Override
    public XSSFCell createCell(int n) {
        return this.createCell(n, 3);
    }

    @Override
    public XSSFCell createCell(int n, int n2) {
        CTCell cTCell;
        XSSFCell xSSFCell = this._cells.get(n);
        if (xSSFCell != null) {
            cTCell = xSSFCell.getCTCell();
            cTCell.set((XmlObject)CTCell.Factory.newInstance());
        } else {
            cTCell = this._row.addNewC();
        }
        XSSFCell xSSFCell2 = new XSSFCell(this, cTCell);
        xSSFCell2.setCellNum(n);
        if (n2 != 3) {
            xSSFCell2.setCellType(n2);
        }
        this._cells.put(n, xSSFCell2);
        return xSSFCell2;
    }

    @Override
    public XSSFCell getCell(int n) {
        return this.getCell(n, this._sheet.getWorkbook().getMissingCellPolicy());
    }

    @Override
    public XSSFCell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        if (n < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        XSSFCell xSSFCell = this._cells.get(n);
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return xSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (xSSFCell == null) {
                return xSSFCell;
            }
            if (xSSFCell.getCellType() == 3) {
                return null;
            }
            return xSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (xSSFCell == null) {
                return this.createCell((short)n, 3);
            }
            return xSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    @Override
    public short getFirstCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.firstKey());
    }

    @Override
    public short getLastCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.lastKey() + 1);
    }

    @Override
    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    @Override
    public float getHeightInPoints() {
        if (this._row.isSetHt()) {
            return (float)this._row.getHt();
        }
        return this._sheet.getDefaultRowHeightInPoints();
    }

    @Override
    public void setHeight(short s) {
        if (s == -1) {
            if (this._row.isSetHt()) {
                this._row.unsetHt();
            }
            if (this._row.isSetCustomHeight()) {
                this._row.unsetCustomHeight();
            }
        } else {
            this._row.setHt((double)s / 20.0);
            this._row.setCustomHeight(true);
        }
    }

    @Override
    public void setHeightInPoints(float f) {
        this.setHeight((short)(f == -1.0f ? -1.0f : f * 20.0f));
    }

    @Override
    public int getPhysicalNumberOfCells() {
        return this._cells.size();
    }

    @Override
    public int getRowNum() {
        return (int)(this._row.getR() - 1L);
    }

    @Override
    public void setRowNum(int n) {
        int n2 = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid row number (" + n + ") outside allowable range (0.." + n2 + ")");
        }
        this._row.setR((long)(n + 1));
    }

    @Override
    public boolean getZeroHeight() {
        return this._row.getHidden();
    }

    @Override
    public void setZeroHeight(boolean bl) {
        this._row.setHidden(bl);
    }

    @Override
    public boolean isFormatted() {
        return this._row.isSetS();
    }

    @Override
    public XSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        StylesTable stylesTable = this.getSheet().getWorkbook().getStylesSource();
        if (stylesTable.getNumCellStyles() > 0) {
            return stylesTable.getStyleAt((int)this._row.getS());
        }
        return null;
    }

    @Override
    public void setRowStyle(CellStyle cellStyle) {
        if (cellStyle == null) {
            if (this._row.isSetS()) {
                this._row.unsetS();
                this._row.unsetCustomFormat();
            }
        } else {
            StylesTable stylesTable = this.getSheet().getWorkbook().getStylesSource();
            XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
            xSSFCellStyle.verifyBelongsToStylesSource(stylesTable);
            long l = stylesTable.putStyle(xSSFCellStyle);
            this._row.setS(l);
            this._row.setCustomFormat(true);
        }
    }

    @Override
    public void removeCell(Cell cell) {
        if (cell.getRow() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this row");
        }
        XSSFCell xSSFCell = (XSSFCell)cell;
        if (xSSFCell.isPartOfArrayFormulaGroup()) {
            xSSFCell.notifyArrayFormulaChanging();
        }
        if (cell.getCellType() == 2) {
            this._sheet.getWorkbook().onDeleteFormula(xSSFCell);
        }
        this._cells.remove(cell.getColumnIndex());
    }

    @Internal
    public CTRow getCTRow() {
        return this._row;
    }

    protected void onDocumentWrite() {
        int n;
        boolean bl = true;
        CTCell[] cTCellArray = this._row.getCArray();
        if (cTCellArray.length != this._cells.size()) {
            bl = false;
        } else {
            n = 0;
            for (XSSFCell xSSFCell : this._cells.values()) {
                CTCell cTCell = xSSFCell.getCTCell();
                CTCell cTCell2 = cTCellArray[n++];
                String string = cTCell.getR();
                String string2 = cTCell2.getR();
                if (string != null ? string.equals(string2) : string2 == null) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            cTCellArray = new CTCell[this._cells.size()];
            n = 0;
            for (XSSFCell xSSFCell : this._cells.values()) {
                cTCellArray[n] = (CTCell)xSSFCell.getCTCell().copy();
                xSSFCell.setCTCell(cTCellArray[n]);
                ++n;
            }
            this._row.setCArray(cTCellArray);
        }
    }

    public String toString() {
        return this._row.toString();
    }

    protected void shift(int n) {
        int n2 = this.getRowNum() + n;
        CalculationChain calculationChain = this._sheet.getWorkbook().getCalculationChain();
        int n3 = (int)this._sheet.sheet.getSheetId();
        String string = "Row[rownum=" + this.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        for (Cell cell : this) {
            XSSFCell xSSFCell = (XSSFCell)cell;
            if (xSSFCell.isPartOfArrayFormulaGroup()) {
                xSSFCell.notifyArrayFormulaChanging(string);
            }
            if (calculationChain != null) {
                calculationChain.removeItem(n3, xSSFCell.getReference());
            }
            CTCell cTCell = xSSFCell.getCTCell();
            String string2 = new CellReference(n2, xSSFCell.getColumnIndex()).formatAsString();
            cTCell.setR(string2);
        }
        this.setRowNum(n2);
    }

    @Override
    public int getOutlineLevel() {
        return this._row.getOutlineLevel();
    }
}

