/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.ss.usermodel.PageOrder;
import ai2.org.apache.poi.ss.usermodel.PaperSize;
import ai2.org.apache.poi.ss.usermodel.PrintCellComments;
import ai2.org.apache.poi.ss.usermodel.PrintOrientation;
import ai2.org.apache.poi.ss.usermodel.PrintSetup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetup;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STOrientation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPageOrder;

public class XSSFPrintSetup
implements PrintSetup {
    private CTWorksheet ctWorksheet;
    private CTPageSetup pageSetup;
    private CTPageMargins pageMargins;

    protected XSSFPrintSetup(CTWorksheet cTWorksheet) {
        this.ctWorksheet = cTWorksheet;
        this.pageSetup = this.ctWorksheet.isSetPageSetup() ? this.ctWorksheet.getPageSetup() : this.ctWorksheet.addNewPageSetup();
        this.pageMargins = this.ctWorksheet.isSetPageMargins() ? this.ctWorksheet.getPageMargins() : this.ctWorksheet.addNewPageMargins();
    }

    public void setPaperSize(short s) {
        this.pageSetup.setPaperSize((long)s);
    }

    public void setPaperSize(PaperSize paperSize) {
        this.setPaperSize((short)(paperSize.ordinal() + 1));
    }

    public void setScale(short s) {
        if (s < 10 || s > 400) {
            throw new POIXMLException("Scale value not accepted: you must choose a value between 10 and 400.");
        }
        this.pageSetup.setScale((long)s);
    }

    public void setPageStart(short s) {
        this.pageSetup.setFirstPageNumber((long)s);
    }

    public void setFitWidth(short s) {
        this.pageSetup.setFitToWidth((long)s);
    }

    public void setFitHeight(short s) {
        this.pageSetup.setFitToHeight((long)s);
    }

    public void setLeftToRight(boolean bl) {
        if (bl) {
            this.setPageOrder(PageOrder.OVER_THEN_DOWN);
        } else {
            this.setPageOrder(PageOrder.DOWN_THEN_OVER);
        }
    }

    public void setLandscape(boolean bl) {
        if (bl) {
            this.setOrientation(PrintOrientation.LANDSCAPE);
        } else {
            this.setOrientation(PrintOrientation.PORTRAIT);
        }
    }

    public void setValidSettings(boolean bl) {
        this.pageSetup.setUsePrinterDefaults(bl);
    }

    public void setNoColor(boolean bl) {
        this.pageSetup.setBlackAndWhite(bl);
    }

    public void setDraft(boolean bl) {
        this.pageSetup.setDraft(bl);
    }

    public void setNotes(boolean bl) {
        if (bl) {
            this.pageSetup.setCellComments(STCellComments.AS_DISPLAYED);
        }
    }

    public void setNoOrientation(boolean bl) {
        if (bl) {
            this.setOrientation(PrintOrientation.DEFAULT);
        }
    }

    public void setUsePage(boolean bl) {
        this.pageSetup.setUseFirstPageNumber(bl);
    }

    public void setHResolution(short s) {
        this.pageSetup.setHorizontalDpi((long)s);
    }

    public void setVResolution(short s) {
        this.pageSetup.setVerticalDpi((long)s);
    }

    public void setHeaderMargin(double d) {
        this.pageMargins.setHeader(d);
    }

    public void setFooterMargin(double d) {
        this.pageMargins.setFooter(d);
    }

    public void setCopies(short s) {
        this.pageSetup.setCopies((long)s);
    }

    public void setOrientation(PrintOrientation printOrientation) {
        STOrientation.Enum enum_ = STOrientation.Enum.forInt((int)printOrientation.getValue());
        this.pageSetup.setOrientation(enum_);
    }

    public PrintOrientation getOrientation() {
        STOrientation.Enum enum_ = this.pageSetup.getOrientation();
        return enum_ == null ? PrintOrientation.DEFAULT : PrintOrientation.valueOf(enum_.intValue());
    }

    public PrintCellComments getCellComment() {
        STCellComments.Enum enum_ = this.pageSetup.getCellComments();
        return enum_ == null ? PrintCellComments.NONE : PrintCellComments.valueOf(enum_.intValue());
    }

    public void setPageOrder(PageOrder pageOrder) {
        STPageOrder.Enum enum_ = STPageOrder.Enum.forInt((int)pageOrder.getValue());
        this.pageSetup.setPageOrder(enum_);
    }

    public PageOrder getPageOrder() {
        return this.pageSetup.getPageOrder() == null ? null : PageOrder.valueOf(this.pageSetup.getPageOrder().intValue());
    }

    public short getPaperSize() {
        return (short)this.pageSetup.getPaperSize();
    }

    public PaperSize getPaperSizeEnum() {
        return PaperSize.values()[this.getPaperSize() - 1];
    }

    public short getScale() {
        return (short)this.pageSetup.getScale();
    }

    public short getPageStart() {
        return (short)this.pageSetup.getFirstPageNumber();
    }

    public short getFitWidth() {
        return (short)this.pageSetup.getFitToWidth();
    }

    public short getFitHeight() {
        return (short)this.pageSetup.getFitToHeight();
    }

    public boolean getLeftToRight() {
        return this.getPageOrder() == PageOrder.OVER_THEN_DOWN;
    }

    public boolean getLandscape() {
        return this.getOrientation() == PrintOrientation.LANDSCAPE;
    }

    public boolean getValidSettings() {
        return this.pageSetup.getUsePrinterDefaults();
    }

    public boolean getNoColor() {
        return this.pageSetup.getBlackAndWhite();
    }

    public boolean getDraft() {
        return this.pageSetup.getDraft();
    }

    public boolean getNotes() {
        return this.getCellComment() == PrintCellComments.AS_DISPLAYED;
    }

    public boolean getNoOrientation() {
        return this.getOrientation() == PrintOrientation.DEFAULT;
    }

    public boolean getUsePage() {
        return this.pageSetup.getUseFirstPageNumber();
    }

    public short getHResolution() {
        return (short)this.pageSetup.getHorizontalDpi();
    }

    public short getVResolution() {
        return (short)this.pageSetup.getVerticalDpi();
    }

    public double getHeaderMargin() {
        return this.pageMargins.getHeader();
    }

    public double getFooterMargin() {
        return this.pageMargins.getFooter();
    }

    public short getCopies() {
        return (short)this.pageSetup.getCopies();
    }
}

