/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.DataConsolidateFunction;
import ai2.org.apache.poi.ss.usermodel.Sheet;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCache;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCacheDefinition;
import ai2.org.apache.poi.xssf.usermodel.XSSFPivotCacheRecords;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheSource;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTItems;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLocation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotCacheDefinition;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotTableDefinition;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRowFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheetSource;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STAxis;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataConsolidateFunction;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STItemType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STSourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFPivotTable
extends POIXMLDocumentPart {
    protected static final short CREATED_VERSION = 3;
    protected static final short MIN_REFRESHABLE_VERSION = 3;
    protected static final short UPDATED_VERSION = 3;
    private CTPivotTableDefinition pivotTableDefinition;
    private XSSFPivotCacheDefinition pivotCacheDefinition;
    private XSSFPivotCache pivotCache;
    private XSSFPivotCacheRecords pivotCacheRecords;
    private Sheet parentSheet;
    private Sheet dataSheet;

    protected XSSFPivotTable() {
        this.pivotTableDefinition = CTPivotTableDefinition.Factory.newInstance();
        this.pivotCache = new XSSFPivotCache();
        this.pivotCacheDefinition = new XSSFPivotCacheDefinition();
        this.pivotCacheRecords = new XSSFPivotCacheRecords();
    }

    protected XSSFPivotTable(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException {
        super(packagePart, packageRelationship);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
            xmlOptions.setLoadReplaceDocumentElement(null);
            this.pivotTableDefinition = CTPivotTableDefinition.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions);
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getLocalizedMessage());
        }
    }

    public void setPivotCache(XSSFPivotCache xSSFPivotCache) {
        this.pivotCache = xSSFPivotCache;
    }

    public XSSFPivotCache getPivotCache() {
        return this.pivotCache;
    }

    public Sheet getParentSheet() {
        return this.parentSheet;
    }

    public void setParentSheet(XSSFSheet xSSFSheet) {
        this.parentSheet = xSSFSheet;
    }

    @Internal
    public CTPivotTableDefinition getCTPivotTableDefinition() {
        return this.pivotTableDefinition;
    }

    @Internal
    public void setCTPivotTableDefinition(CTPivotTableDefinition cTPivotTableDefinition) {
        this.pivotTableDefinition = cTPivotTableDefinition;
    }

    public XSSFPivotCacheDefinition getPivotCacheDefinition() {
        return this.pivotCacheDefinition;
    }

    public void setPivotCacheDefinition(XSSFPivotCacheDefinition xSSFPivotCacheDefinition) {
        this.pivotCacheDefinition = xSSFPivotCacheDefinition;
    }

    public XSSFPivotCacheRecords getPivotCacheRecords() {
        return this.pivotCacheRecords;
    }

    public void setPivotCacheRecords(XSSFPivotCacheRecords xSSFPivotCacheRecords) {
        this.pivotCacheRecords = xSSFPivotCacheRecords;
    }

    public Sheet getDataSheet() {
        return this.dataSheet;
    }

    private void setDataSheet(Sheet sheet) {
        this.dataSheet = sheet;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTPivotTableDefinition.type.getName().getNamespaceURI(), "pivotTableDefinition"));
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.pivotTableDefinition.save(outputStream, xmlOptions);
        outputStream.close();
    }

    protected void setDefaultPivotTableDefinition() {
        this.pivotTableDefinition.setMultipleFieldFilters(false);
        this.pivotTableDefinition.setIndent(0L);
        this.pivotTableDefinition.setCreatedVersion((short)3);
        this.pivotTableDefinition.setMinRefreshableVersion((short)3);
        this.pivotTableDefinition.setUpdatedVersion((short)3);
        this.pivotTableDefinition.setItemPrintTitles(true);
        this.pivotTableDefinition.setUseAutoFormatting(true);
        this.pivotTableDefinition.setApplyNumberFormats(false);
        this.pivotTableDefinition.setApplyWidthHeightFormats(true);
        this.pivotTableDefinition.setApplyAlignmentFormats(false);
        this.pivotTableDefinition.setApplyPatternFormats(false);
        this.pivotTableDefinition.setApplyFontFormats(false);
        this.pivotTableDefinition.setApplyBorderFormats(false);
        this.pivotTableDefinition.setCacheId(this.pivotCache.getCTPivotCache().getCacheId());
        this.pivotTableDefinition.setName("PivotTable" + this.pivotTableDefinition.getCacheId());
        this.pivotTableDefinition.setDataCaption("Values");
        CTPivotTableStyle cTPivotTableStyle = this.pivotTableDefinition.addNewPivotTableStyleInfo();
        cTPivotTableStyle.setName("PivotStyleLight16");
        cTPivotTableStyle.setShowLastColumn(true);
        cTPivotTableStyle.setShowColStripes(false);
        cTPivotTableStyle.setShowRowStripes(false);
        cTPivotTableStyle.setShowColHeaders(true);
        cTPivotTableStyle.setShowRowHeaders(true);
    }

    protected AreaReference getPivotArea() {
        AreaReference areaReference = new AreaReference(this.getPivotCacheDefinition().getCTPivotCacheDefinition().getCacheSource().getWorksheetSource().getRef());
        return areaReference;
    }

    public void addRowLabel(int n) {
        AreaReference areaReference = this.getPivotArea();
        int n2 = areaReference.getLastCell().getRow() - areaReference.getFirstCell().getRow();
        int n3 = areaReference.getLastCell().getCol() - areaReference.getFirstCell().getCol();
        if (n > n3) {
            throw new IndexOutOfBoundsException();
        }
        CTPivotFields cTPivotFields = this.pivotTableDefinition.getPivotFields();
        CTPivotField cTPivotField = CTPivotField.Factory.newInstance();
        CTItems cTItems = cTPivotField.addNewItems();
        cTPivotField.setAxis(STAxis.AXIS_ROW);
        cTPivotField.setShowAll(false);
        for (int i = 0; i <= n2; ++i) {
            cTItems.addNewItem().setT(STItemType.DEFAULT);
        }
        cTItems.setCount((long)cTItems.sizeOfItemArray());
        cTPivotFields.setPivotFieldArray(n, cTPivotField);
        CTRowFields cTRowFields = this.pivotTableDefinition.getRowFields() != null ? this.pivotTableDefinition.getRowFields() : this.pivotTableDefinition.addNewRowFields();
        cTRowFields.addNewField().setX(n);
        cTRowFields.setCount((long)cTRowFields.sizeOfFieldArray());
    }

    public List<Integer> getRowLabelColumns() {
        if (this.pivotTableDefinition.getRowFields() != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (CTField cTField : this.pivotTableDefinition.getRowFields().getFieldArray()) {
                arrayList.add(cTField.getX());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void addColumnLabel(DataConsolidateFunction dataConsolidateFunction, int n, String string) {
        AreaReference areaReference = this.getPivotArea();
        int n2 = areaReference.getLastCell().getCol() - areaReference.getFirstCell().getCol();
        if (n > n2 && n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.addDataColumn(n, true);
        this.addDataField(dataConsolidateFunction, n, string);
        if (this.pivotTableDefinition.getDataFields().getCount() == 2L) {
            CTColFields cTColFields = this.pivotTableDefinition.getColFields() != null ? this.pivotTableDefinition.getColFields() : this.pivotTableDefinition.addNewColFields();
            cTColFields.addNewField().setX(-2);
            cTColFields.setCount((long)cTColFields.sizeOfFieldArray());
        }
    }

    public void addColumnLabel(DataConsolidateFunction dataConsolidateFunction, int n) {
        this.addColumnLabel(dataConsolidateFunction, n, dataConsolidateFunction.getName());
    }

    private void addDataField(DataConsolidateFunction dataConsolidateFunction, int n, String string) {
        AreaReference areaReference = this.getPivotArea();
        int n2 = areaReference.getLastCell().getCol() - areaReference.getFirstCell().getCol();
        if (n > n2 && n < 0) {
            throw new IndexOutOfBoundsException();
        }
        CTDataFields cTDataFields = this.pivotTableDefinition.getDataFields() != null ? this.pivotTableDefinition.getDataFields() : this.pivotTableDefinition.addNewDataFields();
        CTDataField cTDataField = cTDataFields.addNewDataField();
        cTDataField.setSubtotal(STDataConsolidateFunction.Enum.forInt((int)dataConsolidateFunction.getValue()));
        Cell cell = this.getDataSheet().getRow(areaReference.getFirstCell().getRow()).getCell(n);
        cell.setCellType(1);
        cTDataField.setName(string);
        cTDataField.setFld((long)n);
        cTDataFields.setCount((long)cTDataFields.sizeOfDataFieldArray());
    }

    public void addDataColumn(int n, boolean bl) {
        AreaReference areaReference = this.getPivotArea();
        int n2 = areaReference.getLastCell().getCol() - areaReference.getFirstCell().getCol();
        if (n > n2 && n < 0) {
            throw new IndexOutOfBoundsException();
        }
        CTPivotFields cTPivotFields = this.pivotTableDefinition.getPivotFields();
        CTPivotField cTPivotField = CTPivotField.Factory.newInstance();
        cTPivotField.setDataField(bl);
        cTPivotField.setShowAll(false);
        cTPivotFields.setPivotFieldArray(n, cTPivotField);
    }

    public void addReportFilter(int n) {
        CTPageFields cTPageFields;
        AreaReference areaReference = this.getPivotArea();
        int n2 = areaReference.getLastCell().getCol() - areaReference.getFirstCell().getCol();
        int n3 = areaReference.getLastCell().getRow() - areaReference.getFirstCell().getRow();
        if (n > n2 && n < 0) {
            throw new IndexOutOfBoundsException();
        }
        CTPivotFields cTPivotFields = this.pivotTableDefinition.getPivotFields();
        CTPivotField cTPivotField = CTPivotField.Factory.newInstance();
        CTItems cTItems = cTPivotField.addNewItems();
        cTPivotField.setAxis(STAxis.AXIS_PAGE);
        cTPivotField.setShowAll(false);
        for (int i = 0; i <= n3; ++i) {
            cTItems.addNewItem().setT(STItemType.DEFAULT);
        }
        cTItems.setCount((long)cTItems.sizeOfItemArray());
        cTPivotFields.setPivotFieldArray(n, cTPivotField);
        if (this.pivotTableDefinition.getPageFields() != null) {
            cTPageFields = this.pivotTableDefinition.getPageFields();
            this.pivotTableDefinition.setMultipleFieldFilters(true);
        } else {
            cTPageFields = this.pivotTableDefinition.addNewPageFields();
        }
        CTPageField cTPageField = cTPageFields.addNewPageField();
        cTPageField.setHier(-1);
        cTPageField.setFld(n);
        cTPageFields.setCount((long)cTPageFields.sizeOfPageFieldArray());
        this.pivotTableDefinition.getLocation().setColPageCount(cTPageFields.getCount());
    }

    protected void createSourceReferences(AreaReference areaReference, CellReference cellReference, Sheet sheet) {
        CTLocation cTLocation;
        AreaReference areaReference2 = new AreaReference(cellReference, new CellReference(cellReference.getRow() + 1, cellReference.getCol() + 1));
        if (this.pivotTableDefinition.getLocation() == null) {
            cTLocation = this.pivotTableDefinition.addNewLocation();
            cTLocation.setFirstDataCol(1L);
            cTLocation.setFirstDataRow(1L);
            cTLocation.setFirstHeaderRow(1L);
        } else {
            cTLocation = this.pivotTableDefinition.getLocation();
        }
        cTLocation.setRef(areaReference2.formatAsString());
        this.pivotTableDefinition.setLocation(cTLocation);
        CTPivotCacheDefinition cTPivotCacheDefinition = this.getPivotCacheDefinition().getCTPivotCacheDefinition();
        CTCacheSource cTCacheSource = cTPivotCacheDefinition.addNewCacheSource();
        cTCacheSource.setType(STSourceType.WORKSHEET);
        CTWorksheetSource cTWorksheetSource = cTCacheSource.addNewWorksheetSource();
        cTWorksheetSource.setSheet(sheet.getSheetName());
        this.setDataSheet(sheet);
        String[] stringArray = areaReference.getFirstCell().getCellRefParts();
        String[] stringArray2 = areaReference.getLastCell().getCellRefParts();
        cTWorksheetSource.setRef(stringArray[2] + stringArray[1] + ':' + stringArray2[2] + stringArray2[1]);
    }

    protected void createDefaultDataColumns() {
        CTPivotFields cTPivotFields = this.pivotTableDefinition.getPivotFields() != null ? this.pivotTableDefinition.getPivotFields() : this.pivotTableDefinition.addNewPivotFields();
        AreaReference areaReference = this.getPivotArea();
        short s = areaReference.getFirstCell().getCol();
        short s2 = areaReference.getLastCell().getCol();
        for (int i = 0; i <= s2 - s; ++i) {
            CTPivotField cTPivotField = cTPivotFields.addNewPivotField();
            cTPivotField.setDataField(false);
            cTPivotField.setShowAll(false);
        }
        cTPivotFields.setCount((long)cTPivotFields.sizeOfPivotFieldArray());
    }
}

