/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.ss.usermodel.Picture;
import ai2.org.apache.poi.ss.util.ImageUtils;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.xssf.usermodel.XSSFAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFPictureData;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.awt.Dimension;
import java.io.IOException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPictureNonVisual;

public final class XSSFPicture
extends XSSFShape
implements Picture {
    private static final POILogger logger = POILogFactory.getLogger(XSSFPicture.class);
    private static CTPicture prototype = null;
    private CTPicture ctPicture;

    protected XSSFPicture(XSSFDrawing xSSFDrawing, CTPicture cTPicture) {
        this.drawing = xSSFDrawing;
        this.ctPicture = cTPicture;
    }

    protected static CTPicture prototype() {
        if (prototype == null) {
            CTPicture cTPicture = CTPicture.Factory.newInstance();
            CTPictureNonVisual cTPictureNonVisual = cTPicture.addNewNvPicPr();
            CTNonVisualDrawingProps cTNonVisualDrawingProps = cTPictureNonVisual.addNewCNvPr();
            cTNonVisualDrawingProps.setId(1L);
            cTNonVisualDrawingProps.setName("Picture 1");
            cTNonVisualDrawingProps.setDescr("Picture");
            CTNonVisualPictureProperties cTNonVisualPictureProperties = cTPictureNonVisual.addNewCNvPicPr();
            cTNonVisualPictureProperties.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties cTBlipFillProperties = cTPicture.addNewBlipFill();
            cTBlipFillProperties.addNewBlip().setEmbed("");
            cTBlipFillProperties.addNewStretch().addNewFillRect();
            CTShapeProperties cTShapeProperties = cTPicture.addNewSpPr();
            CTTransform2D cTTransform2D = cTShapeProperties.addNewXfrm();
            CTPositiveSize2D cTPositiveSize2D = cTTransform2D.addNewExt();
            cTPositiveSize2D.setCx(0L);
            cTPositiveSize2D.setCy(0L);
            CTPoint2D cTPoint2D = cTTransform2D.addNewOff();
            cTPoint2D.setX(0L);
            cTPoint2D.setY(0L);
            CTPresetGeometry2D cTPresetGeometry2D = cTShapeProperties.addNewPrstGeom();
            cTPresetGeometry2D.setPrst(STShapeType.RECT);
            cTPresetGeometry2D.addNewAvLst();
            prototype = cTPicture;
        }
        return prototype;
    }

    protected void setPictureReference(PackageRelationship packageRelationship) {
        this.ctPicture.getBlipFill().getBlip().setEmbed(packageRelationship.getId());
    }

    @Internal
    public CTPicture getCTPicture() {
        return this.ctPicture;
    }

    public void resize() {
        this.resize(Double.MAX_VALUE);
    }

    public void resize(double d) {
        this.resize(d, d);
    }

    public void resize(double d, double d2) {
        XSSFClientAnchor xSSFClientAnchor = this.getClientAnchor();
        XSSFClientAnchor xSSFClientAnchor2 = this.getPreferredSize(d, d2);
        int n = xSSFClientAnchor.getRow1() + (xSSFClientAnchor2.getRow2() - xSSFClientAnchor2.getRow1());
        int n2 = xSSFClientAnchor.getCol1() + (xSSFClientAnchor2.getCol2() - xSSFClientAnchor2.getCol1());
        xSSFClientAnchor.setCol2(n2);
        xSSFClientAnchor.setDx2(xSSFClientAnchor2.getDx2());
        xSSFClientAnchor.setRow2(n);
        xSSFClientAnchor.setDy2(xSSFClientAnchor2.getDy2());
    }

    public XSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public XSSFClientAnchor getPreferredSize(double d) {
        return this.getPreferredSize(d, d);
    }

    public XSSFClientAnchor getPreferredSize(double d, double d2) {
        Dimension dimension = ImageUtils.setPreferredSize(this, d, d2);
        CTPositiveSize2D cTPositiveSize2D = this.ctPicture.getSpPr().getXfrm().getExt();
        cTPositiveSize2D.setCx((long)((int)dimension.getWidth()));
        cTPositiveSize2D.setCy((long)((int)dimension.getHeight()));
        return this.getClientAnchor();
    }

    protected static Dimension getImageDimension(PackagePart packagePart, int n) {
        try {
            return ImageUtils.getImageDimension(packagePart.getInputStream(), n);
        }
        catch (IOException iOException) {
            logger.log(5, new Object[]{iOException});
            return new Dimension();
        }
    }

    public Dimension getImageDimension() {
        XSSFPictureData xSSFPictureData = this.getPictureData();
        return XSSFPicture.getImageDimension(xSSFPictureData.getPackagePart(), xSSFPictureData.getPictureType());
    }

    public XSSFPictureData getPictureData() {
        String string = this.ctPicture.getBlipFill().getBlip().getEmbed();
        return (XSSFPictureData)this.getDrawing().getRelationById(string);
    }

    protected CTShapeProperties getShapeProperties() {
        return this.ctPicture.getSpPr();
    }

    public XSSFClientAnchor getClientAnchor() {
        XSSFAnchor xSSFAnchor = this.getAnchor();
        return xSSFAnchor instanceof XSSFClientAnchor ? (XSSFClientAnchor)xSSFAnchor : null;
    }

    public XSSFSheet getSheet() {
        return (XSSFSheet)this.getDrawing().getParent();
    }
}

