/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.MapInfo;
import ai2.org.apache.poi.xssf.model.SingleXmlCells;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFTable;
import ai2.org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMap;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSchema;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFMap {
    private CTMap ctMap;
    private MapInfo mapInfo;

    public XSSFMap(CTMap cTMap, MapInfo mapInfo) {
        this.ctMap = cTMap;
        this.mapInfo = mapInfo;
    }

    @Internal
    public CTMap getCtMap() {
        return this.ctMap;
    }

    @Internal
    public CTSchema getCTSchema() {
        String string = this.ctMap.getSchemaID();
        return this.mapInfo.getCTSchemaById(string);
    }

    public Node getSchema() {
        Node node = null;
        CTSchema cTSchema = this.getCTSchema();
        node = cTSchema.getDomNode().getFirstChild();
        return node;
    }

    public List<XSSFSingleXmlCell> getRelatedSingleXMLCell() {
        ArrayList<XSSFSingleXmlCell> arrayList = new ArrayList<XSSFSingleXmlCell>();
        int n = this.mapInfo.getWorkbook().getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            XSSFSheet xSSFSheet = this.mapInfo.getWorkbook().getSheetAt(i);
            for (POIXMLDocumentPart pOIXMLDocumentPart : xSSFSheet.getRelations()) {
                if (!(pOIXMLDocumentPart instanceof SingleXmlCells)) continue;
                SingleXmlCells singleXmlCells = (SingleXmlCells)pOIXMLDocumentPart;
                for (XSSFSingleXmlCell xSSFSingleXmlCell : singleXmlCells.getAllSimpleXmlCell()) {
                    if (xSSFSingleXmlCell.getMapId() != this.ctMap.getID()) continue;
                    arrayList.add(xSSFSingleXmlCell);
                }
            }
        }
        return arrayList;
    }

    public List<XSSFTable> getRelatedTables() {
        ArrayList<XSSFTable> arrayList = new ArrayList<XSSFTable>();
        int n = this.mapInfo.getWorkbook().getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            XSSFSheet xSSFSheet = this.mapInfo.getWorkbook().getSheetAt(i);
            for (POIXMLDocumentPart pOIXMLDocumentPart : xSSFSheet.getRelations()) {
                XSSFTable xSSFTable;
                if (!pOIXMLDocumentPart.getPackageRelationship().getRelationshipType().equals(XSSFRelation.TABLE.getRelation()) || !(xSSFTable = (XSSFTable)pOIXMLDocumentPart).mapsTo(this.ctMap.getID())) continue;
                arrayList.add(xSSFTable);
            }
        }
        return arrayList;
    }
}

