/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGraphicalObjectFrameNonVisual;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;

public final class XSSFGraphicFrame
extends XSSFShape {
    private static CTGraphicalObjectFrame prototype = null;
    private CTGraphicalObjectFrame graphicFrame;
    private XSSFDrawing drawing;
    private XSSFClientAnchor anchor;

    protected XSSFGraphicFrame(XSSFDrawing xSSFDrawing, CTGraphicalObjectFrame cTGraphicalObjectFrame) {
        this.drawing = xSSFDrawing;
        this.graphicFrame = cTGraphicalObjectFrame;
    }

    @Internal
    public CTGraphicalObjectFrame getCTGraphicalObjectFrame() {
        return this.graphicFrame;
    }

    protected static CTGraphicalObjectFrame prototype() {
        if (prototype == null) {
            CTGraphicalObjectFrame cTGraphicalObjectFrame = CTGraphicalObjectFrame.Factory.newInstance();
            CTGraphicalObjectFrameNonVisual cTGraphicalObjectFrameNonVisual = cTGraphicalObjectFrame.addNewNvGraphicFramePr();
            CTNonVisualDrawingProps cTNonVisualDrawingProps = cTGraphicalObjectFrameNonVisual.addNewCNvPr();
            cTNonVisualDrawingProps.setId(0L);
            cTNonVisualDrawingProps.setName("Diagramm 1");
            cTGraphicalObjectFrameNonVisual.addNewCNvGraphicFramePr();
            CTTransform2D cTTransform2D = cTGraphicalObjectFrame.addNewXfrm();
            CTPositiveSize2D cTPositiveSize2D = cTTransform2D.addNewExt();
            CTPoint2D cTPoint2D = cTTransform2D.addNewOff();
            cTPositiveSize2D.setCx(0L);
            cTPositiveSize2D.setCy(0L);
            cTPoint2D.setX(0L);
            cTPoint2D.setY(0L);
            cTGraphicalObjectFrame.addNewGraphic();
            prototype = cTGraphicalObjectFrame;
        }
        return prototype;
    }

    public void setMacro(String string) {
        this.graphicFrame.setMacro(string);
    }

    public void setName(String string) {
        this.getNonVisualProperties().setName(string);
    }

    public String getName() {
        return this.getNonVisualProperties().getName();
    }

    private CTNonVisualDrawingProps getNonVisualProperties() {
        CTGraphicalObjectFrameNonVisual cTGraphicalObjectFrameNonVisual = this.graphicFrame.getNvGraphicFramePr();
        return cTGraphicalObjectFrameNonVisual.getCNvPr();
    }

    protected void setAnchor(XSSFClientAnchor xSSFClientAnchor) {
        this.anchor = xSSFClientAnchor;
    }

    public XSSFClientAnchor getAnchor() {
        return this.anchor;
    }

    protected void setChart(XSSFChart xSSFChart, String string) {
        CTGraphicalObjectData cTGraphicalObjectData = this.graphicFrame.getGraphic().addNewGraphicData();
        this.appendChartElement(cTGraphicalObjectData, string);
        xSSFChart.setGraphicFrame(this);
    }

    public long getId() {
        return this.graphicFrame.getNvGraphicFramePr().getCNvPr().getId();
    }

    protected void setId(long l) {
        this.graphicFrame.getNvGraphicFramePr().getCNvPr().setId(l);
    }

    private void appendChartElement(CTGraphicalObjectData cTGraphicalObjectData, String string) {
        String string2 = STRelationshipId.type.getName().getNamespaceURI();
        String string3 = "http://schemas.openxmlformats.org/drawingml/2006/chart";
        XmlCursor xmlCursor = cTGraphicalObjectData.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement(new QName(string3, "chart", "c"));
        xmlCursor.insertAttributeWithValue(new QName(string2, "id", "r"), string);
        xmlCursor.dispose();
        cTGraphicalObjectData.setUri(string3);
    }

    protected CTShapeProperties getShapeProperties() {
        return null;
    }
}

