/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.ss.usermodel.Font;
import ai2.org.apache.poi.ss.usermodel.FontCharset;
import ai2.org.apache.poi.ss.usermodel.FontFamily;
import ai2.org.apache.poi.ss.usermodel.FontScheme;
import ai2.org.apache.poi.ss.usermodel.FontUnderline;
import ai2.org.apache.poi.ss.usermodel.IndexedColors;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.model.ThemesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBooleanProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontName;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFontSize;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIntProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTUnderlineProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTVerticalAlignFontProperty;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFontScheme;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STUnderlineValues;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignRun;

public class XSSFFont
implements Font {
    public static final String DEFAULT_FONT_NAME = "Calibri";
    public static final short DEFAULT_FONT_SIZE = 11;
    public static final short DEFAULT_FONT_COLOR = IndexedColors.BLACK.getIndex();
    private ThemesTable _themes;
    private CTFont _ctFont;
    private short _index;

    public XSSFFont(CTFont cTFont) {
        this._ctFont = cTFont;
        this._index = 0;
    }

    public XSSFFont(CTFont cTFont, int n) {
        this._ctFont = cTFont;
        this._index = (short)n;
    }

    protected XSSFFont() {
        this._ctFont = CTFont.Factory.newInstance();
        this.setFontName(DEFAULT_FONT_NAME);
        this.setFontHeight(11.0);
    }

    @Internal
    public CTFont getCTFont() {
        return this._ctFont;
    }

    public boolean getBold() {
        CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfBArray() == 0 ? null : this._ctFont.getBArray(0);
        return cTBooleanProperty != null && cTBooleanProperty.getVal();
    }

    public int getCharSet() {
        CTIntProperty cTIntProperty = this._ctFont.sizeOfCharsetArray() == 0 ? null : this._ctFont.getCharsetArray(0);
        int n = cTIntProperty == null ? FontCharset.ANSI.getValue() : FontCharset.valueOf(cTIntProperty.getVal()).getValue();
        return n;
    }

    public short getColor() {
        CTColor cTColor;
        CTColor cTColor2 = cTColor = this._ctFont.sizeOfColorArray() == 0 ? null : this._ctFont.getColorArray(0);
        if (cTColor == null) {
            return IndexedColors.BLACK.getIndex();
        }
        long l = cTColor.getIndexed();
        if (l == (long)DEFAULT_FONT_COLOR) {
            return IndexedColors.BLACK.getIndex();
        }
        if (l == (long)IndexedColors.RED.getIndex()) {
            return IndexedColors.RED.getIndex();
        }
        return (short)l;
    }

    public XSSFColor getXSSFColor() {
        CTColor cTColor;
        CTColor cTColor2 = cTColor = this._ctFont.sizeOfColorArray() == 0 ? null : this._ctFont.getColorArray(0);
        if (cTColor != null) {
            XSSFColor xSSFColor = new XSSFColor(cTColor);
            if (this._themes != null) {
                this._themes.inheritFromThemeAsRequired(xSSFColor);
            }
            return xSSFColor;
        }
        return null;
    }

    public short getThemeColor() {
        CTColor cTColor = this._ctFont.sizeOfColorArray() == 0 ? null : this._ctFont.getColorArray(0);
        long l = cTColor == null ? 0L : cTColor.getTheme();
        return (short)l;
    }

    public short getFontHeight() {
        return (short)(this.getFontHeightRaw() * 20.0);
    }

    public short getFontHeightInPoints() {
        return (short)this.getFontHeightRaw();
    }

    private double getFontHeightRaw() {
        CTFontSize cTFontSize;
        CTFontSize cTFontSize2 = cTFontSize = this._ctFont.sizeOfSzArray() == 0 ? null : this._ctFont.getSzArray(0);
        if (cTFontSize != null) {
            double d = cTFontSize.getVal();
            return d;
        }
        return 11.0;
    }

    public String getFontName() {
        CTFontName cTFontName = this._ctFont.sizeOfNameArray() == 0 ? null : this._ctFont.getNameArray(0);
        return cTFontName == null ? DEFAULT_FONT_NAME : cTFontName.getVal();
    }

    public boolean getItalic() {
        CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfIArray() == 0 ? null : this._ctFont.getIArray(0);
        return cTBooleanProperty != null && cTBooleanProperty.getVal();
    }

    public boolean getStrikeout() {
        CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfStrikeArray() == 0 ? null : this._ctFont.getStrikeArray(0);
        return cTBooleanProperty != null && cTBooleanProperty.getVal();
    }

    public short getTypeOffset() {
        CTVerticalAlignFontProperty cTVerticalAlignFontProperty;
        CTVerticalAlignFontProperty cTVerticalAlignFontProperty2 = cTVerticalAlignFontProperty = this._ctFont.sizeOfVertAlignArray() == 0 ? null : this._ctFont.getVertAlignArray(0);
        if (cTVerticalAlignFontProperty == null) {
            return 0;
        }
        int n = cTVerticalAlignFontProperty.getVal().intValue();
        switch (n) {
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        throw new POIXMLException("Wrong offset value " + n);
    }

    public byte getUnderline() {
        CTUnderlineProperty cTUnderlineProperty;
        CTUnderlineProperty cTUnderlineProperty2 = cTUnderlineProperty = this._ctFont.sizeOfUArray() == 0 ? null : this._ctFont.getUArray(0);
        if (cTUnderlineProperty != null) {
            FontUnderline fontUnderline = FontUnderline.valueOf(cTUnderlineProperty.getVal().intValue());
            return fontUnderline.getByteValue();
        }
        return 0;
    }

    public void setBold(boolean bl) {
        if (bl) {
            CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfBArray() == 0 ? this._ctFont.addNewB() : this._ctFont.getBArray(0);
            cTBooleanProperty.setVal(bl);
        } else {
            this._ctFont.setBArray(null);
        }
    }

    public void setBoldweight(short s) {
        this.setBold(s == 700);
    }

    public short getBoldweight() {
        return this.getBold() ? (short)700 : 400;
    }

    public void setCharSet(byte by) {
        int n = by & 0xFF;
        this.setCharSet(n);
    }

    public void setCharSet(int n) {
        FontCharset fontCharset = FontCharset.valueOf(n);
        if (fontCharset == null) {
            throw new POIXMLException("Attention: an attempt to set a type of unknow charset and charset");
        }
        this.setCharSet(fontCharset);
    }

    public void setCharSet(FontCharset fontCharset) {
        CTIntProperty cTIntProperty = this._ctFont.sizeOfCharsetArray() == 0 ? this._ctFont.addNewCharset() : this._ctFont.getCharsetArray(0);
        cTIntProperty.setVal(fontCharset.getValue());
    }

    public void setColor(short s) {
        CTColor cTColor = this._ctFont.sizeOfColorArray() == 0 ? this._ctFont.addNewColor() : this._ctFont.getColorArray(0);
        switch (s) {
            case 32767: {
                cTColor.setIndexed((long)DEFAULT_FONT_COLOR);
                break;
            }
            case 10: {
                cTColor.setIndexed((long)IndexedColors.RED.getIndex());
                break;
            }
            default: {
                cTColor.setIndexed((long)s);
            }
        }
    }

    public void setColor(XSSFColor xSSFColor) {
        if (xSSFColor == null) {
            this._ctFont.setColorArray(null);
        } else {
            CTColor cTColor;
            CTColor cTColor2 = cTColor = this._ctFont.sizeOfColorArray() == 0 ? this._ctFont.addNewColor() : this._ctFont.getColorArray(0);
            if (cTColor.isSetIndexed()) {
                cTColor.unsetIndexed();
            }
            cTColor.setRgb(xSSFColor.getRGB());
        }
    }

    public void setFontHeight(short s) {
        this.setFontHeight((double)s / 20.0);
    }

    public void setFontHeight(double d) {
        CTFontSize cTFontSize = this._ctFont.sizeOfSzArray() == 0 ? this._ctFont.addNewSz() : this._ctFont.getSzArray(0);
        cTFontSize.setVal(d);
    }

    public void setFontHeightInPoints(short s) {
        this.setFontHeight((double)s);
    }

    public void setThemeColor(short s) {
        CTColor cTColor = this._ctFont.sizeOfColorArray() == 0 ? this._ctFont.addNewColor() : this._ctFont.getColorArray(0);
        cTColor.setTheme((long)s);
    }

    public void setFontName(String string) {
        CTFontName cTFontName = this._ctFont.sizeOfNameArray() == 0 ? this._ctFont.addNewName() : this._ctFont.getNameArray(0);
        cTFontName.setVal(string == null ? DEFAULT_FONT_NAME : string);
    }

    public void setItalic(boolean bl) {
        if (bl) {
            CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfIArray() == 0 ? this._ctFont.addNewI() : this._ctFont.getIArray(0);
            cTBooleanProperty.setVal(bl);
        } else {
            this._ctFont.setIArray(null);
        }
    }

    public void setStrikeout(boolean bl) {
        if (!bl) {
            this._ctFont.setStrikeArray(null);
        } else {
            CTBooleanProperty cTBooleanProperty = this._ctFont.sizeOfStrikeArray() == 0 ? this._ctFont.addNewStrike() : this._ctFont.getStrikeArray(0);
            cTBooleanProperty.setVal(bl);
        }
    }

    public void setTypeOffset(short s) {
        if (s == 0) {
            this._ctFont.setVertAlignArray(null);
        } else {
            CTVerticalAlignFontProperty cTVerticalAlignFontProperty = this._ctFont.sizeOfVertAlignArray() == 0 ? this._ctFont.addNewVertAlign() : this._ctFont.getVertAlignArray(0);
            switch (s) {
                case 0: {
                    cTVerticalAlignFontProperty.setVal(STVerticalAlignRun.BASELINE);
                    break;
                }
                case 2: {
                    cTVerticalAlignFontProperty.setVal(STVerticalAlignRun.SUBSCRIPT);
                    break;
                }
                case 1: {
                    cTVerticalAlignFontProperty.setVal(STVerticalAlignRun.SUPERSCRIPT);
                }
            }
        }
    }

    public void setUnderline(byte by) {
        this.setUnderline(FontUnderline.valueOf(by));
    }

    public void setUnderline(FontUnderline fontUnderline) {
        if (fontUnderline == FontUnderline.NONE && this._ctFont.sizeOfUArray() > 0) {
            this._ctFont.setUArray(null);
        } else {
            CTUnderlineProperty cTUnderlineProperty = this._ctFont.sizeOfUArray() == 0 ? this._ctFont.addNewU() : this._ctFont.getUArray(0);
            STUnderlineValues.Enum enum_ = STUnderlineValues.Enum.forInt((int)fontUnderline.getValue());
            cTUnderlineProperty.setVal(enum_);
        }
    }

    public String toString() {
        return this._ctFont.toString();
    }

    public long registerTo(StylesTable stylesTable) {
        short s;
        this._themes = stylesTable.getTheme();
        this._index = s = (short)stylesTable.putFont(this, true);
        return s;
    }

    public void setThemesTable(ThemesTable themesTable) {
        this._themes = themesTable;
    }

    public FontScheme getScheme() {
        CTFontScheme cTFontScheme = this._ctFont.sizeOfSchemeArray() == 0 ? null : this._ctFont.getSchemeArray(0);
        return cTFontScheme == null ? FontScheme.NONE : FontScheme.valueOf(cTFontScheme.getVal().intValue());
    }

    public void setScheme(FontScheme fontScheme) {
        CTFontScheme cTFontScheme = this._ctFont.sizeOfSchemeArray() == 0 ? this._ctFont.addNewScheme() : this._ctFont.getSchemeArray(0);
        STFontScheme.Enum enum_ = STFontScheme.Enum.forInt((int)fontScheme.getValue());
        cTFontScheme.setVal(enum_);
    }

    public int getFamily() {
        CTIntProperty cTIntProperty = this._ctFont.sizeOfFamilyArray() == 0 ? this._ctFont.addNewFamily() : this._ctFont.getFamilyArray(0);
        return cTIntProperty == null ? FontFamily.NOT_APPLICABLE.getValue() : FontFamily.valueOf(cTIntProperty.getVal()).getValue();
    }

    public void setFamily(int n) {
        CTIntProperty cTIntProperty = this._ctFont.sizeOfFamilyArray() == 0 ? this._ctFont.addNewFamily() : this._ctFont.getFamilyArray(0);
        cTIntProperty.setVal(n);
    }

    public void setFamily(FontFamily fontFamily) {
        this.setFamily(fontFamily.getValue());
    }

    public short getIndex() {
        return this._index;
    }

    public int hashCode() {
        return this._ctFont.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XSSFFont)) {
            return false;
        }
        XSSFFont xSSFFont = (XSSFFont)object;
        return this._ctFont.toString().equals(xSSFFont.getCTFont().toString());
    }
}

