/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLDocumentPart;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.ss.usermodel.ClientAnchor;
import ai2.org.apache.poi.ss.usermodel.Drawing;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFChart;
import ai2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import ai2.org.apache.poi.xssf.usermodel.XSSFConnector;
import ai2.org.apache.poi.xssf.usermodel.XSSFFactory;
import ai2.org.apache.poi.xssf.usermodel.XSSFGraphicFrame;
import ai2.org.apache.poi.xssf.usermodel.XSSFPicture;
import ai2.org.apache.poi.xssf.usermodel.XSSFPictureData;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xssf.usermodel.XSSFShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFShapeGroup;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import ai2.org.apache.poi.xssf.usermodel.XSSFTextBox;
import ai2.org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTConnector;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTGroupShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTOneCellAnchor;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.STEditAs;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFDrawing
extends POIXMLDocumentPart
implements Drawing {
    private CTDrawing drawing;
    private long numOfGraphicFrames = 0L;
    protected static final String NAMESPACE_A = "http://schemas.openxmlformats.org/drawingml/2006/main";
    protected static final String NAMESPACE_C = "http://schemas.openxmlformats.org/drawingml/2006/chart";

    protected XSSFDrawing() {
        this.drawing = XSSFDrawing.newDrawing();
    }

    public XSSFDrawing(PackagePart packagePart, PackageRelationship packageRelationship) throws IOException, XmlException {
        super(packagePart, packageRelationship);
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setLoadReplaceDocumentElement(null);
        this.drawing = CTDrawing.Factory.parse((InputStream)packagePart.getInputStream(), (XmlOptions)xmlOptions);
    }

    private static CTDrawing newDrawing() {
        return CTDrawing.Factory.newInstance();
    }

    @Internal
    public CTDrawing getCTDrawing() {
        return this.drawing;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDrawing.type.getName().getNamespaceURI(), "wsDr", "xdr"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(NAMESPACE_A, "a");
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        PackagePart packagePart = this.getPackagePart();
        OutputStream outputStream = packagePart.getOutputStream();
        this.drawing.save(outputStream, xmlOptions);
        outputStream.close();
    }

    @Override
    public XSSFClientAnchor createAnchor(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new XSSFClientAnchor(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public XSSFTextBox createTextbox(XSSFClientAnchor xSSFClientAnchor) {
        long l = this.newShapeId();
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTShape cTShape = cTTwoCellAnchor.addNewSp();
        cTShape.set((XmlObject)XSSFSimpleShape.prototype());
        cTShape.getNvSpPr().getCNvPr().setId(l);
        XSSFTextBox xSSFTextBox = new XSSFTextBox(this, cTShape);
        xSSFTextBox.anchor = xSSFClientAnchor;
        return xSSFTextBox;
    }

    public XSSFPicture createPicture(XSSFClientAnchor xSSFClientAnchor, int n) {
        PackageRelationship packageRelationship = this.addPictureReference(n);
        long l = this.newShapeId();
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTPicture cTPicture = cTTwoCellAnchor.addNewPic();
        cTPicture.set((XmlObject)XSSFPicture.prototype());
        cTPicture.getNvPicPr().getCNvPr().setId(l);
        XSSFPicture xSSFPicture = new XSSFPicture(this, cTPicture);
        xSSFPicture.anchor = xSSFClientAnchor;
        xSSFPicture.setPictureReference(packageRelationship);
        return xSSFPicture;
    }

    @Override
    public XSSFPicture createPicture(ClientAnchor clientAnchor, int n) {
        return this.createPicture((XSSFClientAnchor)clientAnchor, n);
    }

    public XSSFChart createChart(XSSFClientAnchor xSSFClientAnchor) {
        int n = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.CHART.getContentType()).size() + 1;
        XSSFChart xSSFChart = (XSSFChart)this.createRelationship(XSSFRelation.CHART, XSSFFactory.getInstance(), n);
        String string = xSSFChart.getPackageRelationship().getId();
        XSSFGraphicFrame xSSFGraphicFrame = this.createGraphicFrame(xSSFClientAnchor);
        xSSFGraphicFrame.setChart(xSSFChart, string);
        return xSSFChart;
    }

    @Override
    public XSSFChart createChart(ClientAnchor clientAnchor) {
        return this.createChart((XSSFClientAnchor)clientAnchor);
    }

    protected PackageRelationship addPictureReference(int n) {
        XSSFWorkbook xSSFWorkbook = (XSSFWorkbook)this.getParent().getParent();
        XSSFPictureData xSSFPictureData = xSSFWorkbook.getAllPictures().get(n);
        PackagePartName packagePartName = xSSFPictureData.getPackagePart().getPartName();
        PackageRelationship packageRelationship = this.getPackagePart().addRelationship(packagePartName, TargetMode.INTERNAL, XSSFRelation.IMAGES.getRelation());
        this.addRelation(packageRelationship.getId(), new XSSFPictureData(xSSFPictureData.getPackagePart(), packageRelationship));
        return packageRelationship;
    }

    public XSSFSimpleShape createSimpleShape(XSSFClientAnchor xSSFClientAnchor) {
        long l = this.newShapeId();
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTShape cTShape = cTTwoCellAnchor.addNewSp();
        cTShape.set((XmlObject)XSSFSimpleShape.prototype());
        cTShape.getNvSpPr().getCNvPr().setId(l);
        XSSFSimpleShape xSSFSimpleShape = new XSSFSimpleShape(this, cTShape);
        xSSFSimpleShape.anchor = xSSFClientAnchor;
        return xSSFSimpleShape;
    }

    public XSSFConnector createConnector(XSSFClientAnchor xSSFClientAnchor) {
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTConnector cTConnector = cTTwoCellAnchor.addNewCxnSp();
        cTConnector.set((XmlObject)XSSFConnector.prototype());
        XSSFConnector xSSFConnector = new XSSFConnector(this, cTConnector);
        xSSFConnector.anchor = xSSFClientAnchor;
        return xSSFConnector;
    }

    public XSSFShapeGroup createGroup(XSSFClientAnchor xSSFClientAnchor) {
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTGroupShape cTGroupShape = cTTwoCellAnchor.addNewGrpSp();
        cTGroupShape.set((XmlObject)XSSFShapeGroup.prototype());
        XSSFShapeGroup xSSFShapeGroup = new XSSFShapeGroup(this, cTGroupShape);
        xSSFShapeGroup.anchor = xSSFClientAnchor;
        return xSSFShapeGroup;
    }

    @Override
    public XSSFComment createCellComment(ClientAnchor clientAnchor) {
        String string;
        XSSFClientAnchor xSSFClientAnchor = (XSSFClientAnchor)clientAnchor;
        XSSFSheet xSSFSheet = (XSSFSheet)this.getParent();
        CommentsTable commentsTable = xSSFSheet.getCommentsTable(true);
        XSSFVMLDrawing xSSFVMLDrawing = xSSFSheet.getVMLDrawing(true);
        schemasMicrosoftComVml.CTShape cTShape = xSSFVMLDrawing.newCommentShape();
        if (xSSFClientAnchor.isSet()) {
            int n = xSSFClientAnchor.getDx1() / 9525;
            int n2 = xSSFClientAnchor.getDy1() / 9525;
            int n3 = xSSFClientAnchor.getDx2() / 9525;
            int n4 = xSSFClientAnchor.getDy2() / 9525;
            String string2 = xSSFClientAnchor.getCol1() + ", " + n + ", " + xSSFClientAnchor.getRow1() + ", " + n2 + ", " + xSSFClientAnchor.getCol2() + ", " + n3 + ", " + xSSFClientAnchor.getRow2() + ", " + n4;
            cTShape.getClientDataArray(0).setAnchorArray(0, string2);
        }
        if (commentsTable.findCellComment(string = new CellReference(xSSFClientAnchor.getRow1(), xSSFClientAnchor.getCol1()).formatAsString()) != null) {
            throw new IllegalArgumentException("Multiple cell comments in one cell are not allowed, cell: " + string);
        }
        return new XSSFComment(commentsTable, commentsTable.newComment(string), cTShape);
    }

    private XSSFGraphicFrame createGraphicFrame(XSSFClientAnchor xSSFClientAnchor) {
        CTTwoCellAnchor cTTwoCellAnchor = this.createTwoCellAnchor(xSSFClientAnchor);
        CTGraphicalObjectFrame cTGraphicalObjectFrame = cTTwoCellAnchor.addNewGraphicFrame();
        cTGraphicalObjectFrame.set((XmlObject)XSSFGraphicFrame.prototype());
        long l = this.numOfGraphicFrames++;
        XSSFGraphicFrame xSSFGraphicFrame = new XSSFGraphicFrame(this, cTGraphicalObjectFrame);
        xSSFGraphicFrame.setAnchor(xSSFClientAnchor);
        xSSFGraphicFrame.setId(l);
        xSSFGraphicFrame.setName("Diagramm" + l);
        return xSSFGraphicFrame;
    }

    public List<XSSFChart> getCharts() {
        ArrayList<XSSFChart> arrayList = new ArrayList<XSSFChart>();
        for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
            if (!(pOIXMLDocumentPart instanceof XSSFChart)) continue;
            arrayList.add((XSSFChart)pOIXMLDocumentPart);
        }
        return arrayList;
    }

    private CTTwoCellAnchor createTwoCellAnchor(XSSFClientAnchor xSSFClientAnchor) {
        STEditAs.Enum enum_;
        CTTwoCellAnchor cTTwoCellAnchor = this.drawing.addNewTwoCellAnchor();
        cTTwoCellAnchor.setFrom(xSSFClientAnchor.getFrom());
        cTTwoCellAnchor.setTo(xSSFClientAnchor.getTo());
        cTTwoCellAnchor.addNewClientData();
        xSSFClientAnchor.setTo(cTTwoCellAnchor.getTo());
        xSSFClientAnchor.setFrom(cTTwoCellAnchor.getFrom());
        switch (xSSFClientAnchor.getAnchorType()) {
            case 3: {
                enum_ = STEditAs.ABSOLUTE;
                break;
            }
            case 0: {
                enum_ = STEditAs.TWO_CELL;
                break;
            }
            case 2: {
                enum_ = STEditAs.ONE_CELL;
                break;
            }
            default: {
                enum_ = STEditAs.ONE_CELL;
            }
        }
        cTTwoCellAnchor.setEditAs(enum_);
        return cTTwoCellAnchor;
    }

    private long newShapeId() {
        return this.drawing.sizeOfTwoCellAnchorArray() + 1;
    }

    public List<XSSFShape> getShapes() {
        ArrayList<XSSFShape> arrayList = new ArrayList<XSSFShape>();
        for (XmlObject xmlObject : this.drawing.selectPath("./*/*")) {
            XSSFShape xSSFShape = null;
            if (xmlObject instanceof CTPicture) {
                xSSFShape = new XSSFPicture(this, (CTPicture)xmlObject);
            } else if (xmlObject instanceof CTConnector) {
                xSSFShape = new XSSFConnector(this, (CTConnector)xmlObject);
            } else if (xmlObject instanceof CTShape) {
                xSSFShape = new XSSFSimpleShape(this, (CTShape)xmlObject);
            } else if (xmlObject instanceof CTGraphicalObjectFrame) {
                xSSFShape = new XSSFGraphicFrame(this, (CTGraphicalObjectFrame)xmlObject);
            } else if (xmlObject instanceof CTGroupShape) {
                xSSFShape = new XSSFShapeGroup(this, (CTGroupShape)xmlObject);
            }
            if (xSSFShape == null) continue;
            xSSFShape.anchor = this.getAnchorFromParent(xmlObject);
            arrayList.add(xSSFShape);
        }
        return arrayList;
    }

    private XSSFAnchor getAnchorFromParent(XmlObject xmlObject) {
        XSSFClientAnchor xSSFClientAnchor = null;
        XmlObject xmlObject2 = null;
        XmlCursor xmlCursor = xmlObject.newCursor();
        if (xmlCursor.toParent()) {
            xmlObject2 = xmlCursor.getObject();
        }
        xmlCursor.dispose();
        if (xmlObject2 != null) {
            if (xmlObject2 instanceof CTTwoCellAnchor) {
                CTTwoCellAnchor cTTwoCellAnchor = (CTTwoCellAnchor)xmlObject2;
                xSSFClientAnchor = new XSSFClientAnchor(cTTwoCellAnchor.getFrom(), cTTwoCellAnchor.getTo());
            } else if (xmlObject2 instanceof CTOneCellAnchor) {
                CTOneCellAnchor cTOneCellAnchor = (CTOneCellAnchor)xmlObject2;
                xSSFClientAnchor = new XSSFClientAnchor(cTOneCellAnchor.getFrom(), CTMarker.Factory.newInstance());
            }
        }
        return xSSFClientAnchor;
    }
}

