/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.DataValidationConstraint;
import ai2.org.apache.poi.xssf.usermodel.XSSFDataValidation;
import java.util.Arrays;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;

public class XSSFDataValidationConstraint
implements DataValidationConstraint {
    private String formula1;
    private String formula2;
    private int validationType = -1;
    private int operator = -1;
    private String[] explicitListOfValues;

    public XSSFDataValidationConstraint(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("List validation with explicit values must specify at least one value");
        }
        this.validationType = 3;
        this.setExplicitListValues(stringArray);
        this.validate();
    }

    public XSSFDataValidationConstraint(int n, String string) {
        this.setFormula1(string);
        this.validationType = n;
        this.validate();
    }

    public XSSFDataValidationConstraint(int n, int n2, String string) {
        this.setFormula1(string);
        this.validationType = n;
        this.operator = n2;
        this.validate();
    }

    public XSSFDataValidationConstraint(int n, int n2, String string, String string2) {
        this.setFormula1(string);
        this.setFormula2(string2);
        this.validationType = n;
        this.operator = n2;
        this.validate();
        if (3 == n) {
            this.explicitListOfValues = string.split(",");
        }
    }

    public String[] getExplicitListValues() {
        return this.explicitListOfValues;
    }

    public String getFormula1() {
        return this.formula1;
    }

    public String getFormula2() {
        return this.formula2;
    }

    public int getOperator() {
        return this.operator;
    }

    public int getValidationType() {
        return this.validationType;
    }

    public void setExplicitListValues(String[] stringArray) {
        this.explicitListOfValues = stringArray;
        if (this.explicitListOfValues != null && this.explicitListOfValues.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("\"");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("\"");
            this.setFormula1(stringBuilder.toString());
        }
    }

    public void setFormula1(String string) {
        this.formula1 = this.removeLeadingEquals(string);
    }

    protected String removeLeadingEquals(String string) {
        return this.isFormulaEmpty(string) ? string : (string.charAt(0) == '=' ? string.substring(1) : string);
    }

    public void setFormula2(String string) {
        this.formula2 = this.removeLeadingEquals(string);
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public void validate() {
        if (this.validationType == 0) {
            return;
        }
        if (this.validationType == 3) {
            if (this.isFormulaEmpty(this.formula1)) {
                throw new IllegalArgumentException("A valid formula or a list of values must be specified for list validation.");
            }
        } else {
            if (this.isFormulaEmpty(this.formula1)) {
                throw new IllegalArgumentException("Formula is not specified. Formula is required for all validation types except explicit list validation.");
            }
            if (this.validationType != 7) {
                if (this.operator == -1) {
                    throw new IllegalArgumentException("This validation type requires an operator to be specified.");
                }
                if ((this.operator == 0 || this.operator == 1) && this.isFormulaEmpty(this.formula2)) {
                    throw new IllegalArgumentException("Between and not between comparisons require two formulae to be specified.");
                }
            }
        }
    }

    protected boolean isFormulaEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        STDataValidationType.Enum enum_ = XSSFDataValidation.validationTypeMappings.get(this.validationType);
        STDataValidationOperator.Enum enum_2 = XSSFDataValidation.operatorTypeMappings.get(this.operator);
        stringBuilder.append(enum_);
        stringBuilder.append(' ');
        if (this.validationType != 0) {
            if (this.validationType != 3 && this.validationType != 0 && this.validationType != 7) {
                stringBuilder.append(",").append(enum_2).append(", ");
            }
            if (this.validationType == 3 && this.explicitListOfValues != null) {
                stringBuilder.append("").append(Arrays.asList(this.explicitListOfValues)).append("").append(' ');
            } else {
                stringBuilder.append("").append(this.formula1).append("").append(' ');
            }
            if (this.formula2 != null) {
                stringBuilder.append("").append(this.formula2).append("").append(' ');
            }
        }
        return stringBuilder.toString();
    }
}

