/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.ClientAnchor;
import ai2.org.apache.poi.ss.usermodel.Comment;
import ai2.org.apache.poi.ss.usermodel.RichTextString;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.xssf.model.CommentsTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.math.BigInteger;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import schemasMicrosoftComVml.CTShape;

public class XSSFComment
implements Comment {
    private final CTComment _comment;
    private final CommentsTable _comments;
    private final CTShape _vmlShape;
    private XSSFRichTextString _str;

    public XSSFComment(CommentsTable commentsTable, CTComment cTComment, CTShape cTShape) {
        this._comment = cTComment;
        this._comments = commentsTable;
        this._vmlShape = cTShape;
        if (cTShape != null && cTShape.sizeOfClientDataArray() > 0) {
            CellReference cellReference = new CellReference(cTComment.getRef());
            cTShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(cellReference.getRow())));
            cTShape.getClientDataArray(0).setColumnArray(0, new BigInteger(String.valueOf(cellReference.getCol())));
            cTShape.getClientDataList().toString();
        }
    }

    public String getAuthor() {
        return this._comments.getAuthor((int)this._comment.getAuthorId());
    }

    public void setAuthor(String string) {
        this._comment.setAuthorId((long)this._comments.findAuthor(string));
    }

    public int getColumn() {
        return new CellReference(this._comment.getRef()).getCol();
    }

    public int getRow() {
        return new CellReference(this._comment.getRef()).getRow();
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this._vmlShape != null) {
            String string = this._vmlShape.getStyle();
            bl = string != null && string.indexOf("visibility:visible") != -1;
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        if (this._vmlShape != null) {
            String string = bl ? "position:absolute;visibility:visible" : "position:absolute;visibility:hidden";
            this._vmlShape.setStyle(string);
        }
    }

    public void setColumn(int n) {
        String string = this._comment.getRef();
        CellReference cellReference = new CellReference(this.getRow(), n);
        this._comment.setRef(cellReference.formatAsString());
        this._comments.referenceUpdated(string, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setColumnArray(new BigInteger[]{new BigInteger(String.valueOf(n))});
            this._vmlShape.getClientDataList().toString();
        }
    }

    public void setRow(int n) {
        String string = this._comment.getRef();
        String string2 = new CellReference(n, this.getColumn()).formatAsString();
        this._comment.setRef(string2);
        this._comments.referenceUpdated(string, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(n)));
            this._vmlShape.getClientDataList().toString();
        }
    }

    public XSSFRichTextString getString() {
        CTRst cTRst;
        if (this._str == null && (cTRst = this._comment.getText()) != null) {
            this._str = new XSSFRichTextString(this._comment.getText());
        }
        return this._str;
    }

    public void setString(RichTextString richTextString) {
        if (!(richTextString instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this._str = (XSSFRichTextString)richTextString;
        this._comment.setText(this._str.getCTRst());
    }

    public void setString(String string) {
        this.setString(new XSSFRichTextString(string));
    }

    public ClientAnchor getClientAnchor() {
        String string = this._vmlShape.getClientDataArray(0).getAnchorArray(0);
        int[] nArray = new int[8];
        int n = 0;
        for (String string2 : string.split(",")) {
            nArray[n++] = Integer.parseInt(string2.trim());
        }
        XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(nArray[1] * 9525, nArray[3] * 9525, nArray[5] * 9525, nArray[7] * 9525, nArray[0], nArray[2], nArray[4], nArray[6]);
        return xSSFClientAnchor;
    }

    protected CTComment getCTComment() {
        return this._comment;
    }

    protected CTShape getCTShape() {
        return this._vmlShape;
    }
}

