/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.ColorScaleFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import ai2.org.apache.poi.xssf.usermodel.XSSFColor;
import ai2.org.apache.poi.xssf.usermodel.XSSFConditionalFormattingThreshold;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;

public class XSSFColorScaleFormatting
implements ColorScaleFormatting {
    CTColorScale _scale;

    XSSFColorScaleFormatting(CTColorScale cTColorScale) {
        this._scale = cTColorScale;
    }

    public int getNumControlPoints() {
        return this._scale.sizeOfCfvoArray();
    }

    public void setNumControlPoints(int n) {
        while (n < this._scale.sizeOfCfvoArray()) {
            this._scale.removeCfvo(this._scale.sizeOfCfvoArray() - 1);
            this._scale.removeColor(this._scale.sizeOfColorArray() - 1);
        }
        while (n > this._scale.sizeOfCfvoArray()) {
            this._scale.addNewCfvo();
            this._scale.addNewColor();
        }
    }

    public XSSFColor[] getColors() {
        CTColor[] cTColorArray = this._scale.getColorArray();
        XSSFColor[] xSSFColorArray = new XSSFColor[cTColorArray.length];
        for (int i = 0; i < cTColorArray.length; ++i) {
            xSSFColorArray[i] = new XSSFColor(cTColorArray[i]);
        }
        return xSSFColorArray;
    }

    public void setColors(Color[] colorArray) {
        CTColor[] cTColorArray = new CTColor[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            cTColorArray[i] = ((XSSFColor)colorArray[i]).getCTColor();
        }
        this._scale.setColorArray(cTColorArray);
    }

    public XSSFConditionalFormattingThreshold[] getThresholds() {
        CTCfvo[] cTCfvoArray = this._scale.getCfvoArray();
        XSSFConditionalFormattingThreshold[] xSSFConditionalFormattingThresholdArray = new XSSFConditionalFormattingThreshold[cTCfvoArray.length];
        for (int i = 0; i < cTCfvoArray.length; ++i) {
            xSSFConditionalFormattingThresholdArray[i] = new XSSFConditionalFormattingThreshold(cTCfvoArray[i]);
        }
        return xSSFConditionalFormattingThresholdArray;
    }

    public void setThresholds(ConditionalFormattingThreshold[] conditionalFormattingThresholdArray) {
        CTCfvo[] cTCfvoArray = new CTCfvo[conditionalFormattingThresholdArray.length];
        for (int i = 0; i < conditionalFormattingThresholdArray.length; ++i) {
            cTCfvoArray[i] = ((XSSFConditionalFormattingThreshold)conditionalFormattingThresholdArray[i]).getCTCfvo();
        }
        this._scale.setCfvoArray(cTCfvoArray);
    }

    public XSSFColor createColor() {
        return new XSSFColor(this._scale.addNewColor());
    }

    public XSSFConditionalFormattingThreshold createThreshold() {
        return new XSSFConditionalFormattingThreshold(this._scale.addNewCfvo());
    }
}

