/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.POIXMLException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTChartsheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.ChartsheetDocument;

public class XSSFChartSheet
extends XSSFSheet {
    private static final byte[] BLANK_WORKSHEET = XSSFChartSheet.blankWorksheet();
    protected CTChartsheet chartsheet;

    protected XSSFChartSheet(PackagePart packagePart, PackageRelationship packageRelationship) {
        super(packagePart, packageRelationship);
    }

    protected void read(InputStream inputStream) throws IOException {
        super.read(new ByteArrayInputStream(BLANK_WORKSHEET));
        try {
            this.chartsheet = ChartsheetDocument.Factory.parse((InputStream)inputStream).getChartsheet();
        }
        catch (XmlException xmlException) {
            throw new POIXMLException(xmlException);
        }
    }

    public CTChartsheet getCTChartsheet() {
        return this.chartsheet;
    }

    protected CTDrawing getCTDrawing() {
        return this.chartsheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.chartsheet.getLegacyDrawing();
    }

    protected void write(OutputStream outputStream) throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartsheet.type.getName().getNamespaceURI(), "chartsheet"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(hashMap);
        this.chartsheet.save(outputStream, xmlOptions);
    }

    private static byte[] blankWorksheet() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new XSSFSheet().write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

