/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.FormulaParser;
import ai2.org.apache.poi.ss.formula.FormulaRenderer;
import ai2.org.apache.poi.ss.formula.SharedFormula;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.usermodel.Comment;
import ai2.org.apache.poi.ss.usermodel.DateUtil;
import ai2.org.apache.poi.ss.usermodel.FormulaError;
import ai2.org.apache.poi.ss.usermodel.Hyperlink;
import ai2.org.apache.poi.ss.usermodel.RichTextString;
import ai2.org.apache.poi.ss.usermodel.Row;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.xssf.model.SharedStringsTable;
import ai2.org.apache.poi.xssf.model.StylesTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import ai2.org.apache.poi.xssf.usermodel.XSSFComment;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import ai2.org.apache.poi.xssf.usermodel.XSSFHyperlink;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import ai2.org.apache.poi.xssf.usermodel.XSSFRow;
import ai2.org.apache.poi.xssf.usermodel.XSSFSheet;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public final class XSSFCell
implements Cell {
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private CTCell _cell;
    private final XSSFRow _row;
    private int _cellNum;
    private SharedStringsTable _sharedStringSource;
    private StylesTable _stylesSource;

    protected XSSFCell(XSSFRow xSSFRow, CTCell cTCell) {
        this._cell = cTCell;
        this._row = xSSFRow;
        if (cTCell.getR() != null) {
            this._cellNum = new CellReference(cTCell.getR()).getCol();
        } else {
            short s = xSSFRow.getLastCellNum();
            if (s != -1) {
                this._cellNum = xSSFRow.getCell(s - 1, Row.RETURN_NULL_AND_BLANK).getColumnIndex() + 1;
            }
        }
        this._sharedStringSource = xSSFRow.getSheet().getWorkbook().getSharedStringSource();
        this._stylesSource = xSSFRow.getSheet().getWorkbook().getStylesSource();
    }

    protected SharedStringsTable getSharedStringSource() {
        return this._sharedStringSource;
    }

    protected StylesTable getStylesSource() {
        return this._stylesSource;
    }

    public XSSFSheet getSheet() {
        return this.getRow().getSheet();
    }

    public XSSFRow getRow() {
        return this._row;
    }

    public boolean getBooleanCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return false;
            }
            case 4: {
                return this._cell.isSetV() && TRUE_AS_STRING.equals(this._cell.getV());
            }
            case 2: {
                return this._cell.isSetV() && TRUE_AS_STRING.equals(this._cell.getV());
            }
        }
        throw XSSFCell.typeMismatch(4, n, false);
    }

    public void setCellValue(boolean bl) {
        this._cell.setT(STCellType.B);
        this._cell.setV(bl ? TRUE_AS_STRING : FALSE_AS_STRING);
    }

    public double getNumericCellValue() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return 0.0;
            }
            case 0: 
            case 2: {
                if (this._cell.isSetV()) {
                    String string = this._cell.getV();
                    if (string.isEmpty()) {
                        return 0.0;
                    }
                    try {
                        return Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw XSSFCell.typeMismatch(0, 1, false);
                    }
                }
                return 0.0;
            }
        }
        throw XSSFCell.typeMismatch(0, n, false);
    }

    public void setCellValue(double d) {
        if (Double.isInfinite(d)) {
            this._cell.setT(STCellType.E);
            this._cell.setV(FormulaError.DIV0.getString());
        } else if (Double.isNaN(d)) {
            this._cell.setT(STCellType.E);
            this._cell.setV(FormulaError.NUM.getString());
        } else {
            this._cell.setT(STCellType.N);
            this._cell.setV(String.valueOf(d));
        }
    }

    public String getStringCellValue() {
        XSSFRichTextString xSSFRichTextString = this.getRichStringCellValue();
        return xSSFRichTextString == null ? null : xSSFRichTextString.getString();
    }

    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString xSSFRichTextString;
        int n = this.getCellType();
        switch (n) {
            case 3: {
                xSSFRichTextString = new XSSFRichTextString("");
                break;
            }
            case 1: {
                if (this._cell.getT() == STCellType.INLINE_STR) {
                    if (this._cell.isSetIs()) {
                        xSSFRichTextString = new XSSFRichTextString(this._cell.getIs());
                        break;
                    }
                    if (this._cell.isSetV()) {
                        xSSFRichTextString = new XSSFRichTextString(this._cell.getV());
                        break;
                    }
                    xSSFRichTextString = new XSSFRichTextString("");
                    break;
                }
                if (this._cell.getT() == STCellType.STR) {
                    xSSFRichTextString = new XSSFRichTextString(this._cell.isSetV() ? this._cell.getV() : "");
                    break;
                }
                if (this._cell.isSetV()) {
                    int n2 = Integer.parseInt(this._cell.getV());
                    xSSFRichTextString = new XSSFRichTextString(this._sharedStringSource.getEntryAt(n2));
                    break;
                }
                xSSFRichTextString = new XSSFRichTextString("");
                break;
            }
            case 2: {
                XSSFCell.checkFormulaCachedValueType(1, this.getBaseCellType(false));
                xSSFRichTextString = new XSSFRichTextString(this._cell.isSetV() ? this._cell.getV() : "");
                break;
            }
            default: {
                throw XSSFCell.typeMismatch(1, n, false);
            }
        }
        xSSFRichTextString.setStylesTableReference(this._stylesSource);
        return xSSFRichTextString;
    }

    private static void checkFormulaCachedValueType(int n, int n2) {
        if (n2 != n) {
            throw XSSFCell.typeMismatch(n, n2, true);
        }
    }

    public void setCellValue(String string) {
        this.setCellValue(string == null ? null : new XSSFRichTextString(string));
    }

    public void setCellValue(RichTextString richTextString) {
        if (richTextString == null || richTextString.getString() == null) {
            this.setCellType(3);
            return;
        }
        if (richTextString.length() > SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        int n = this.getCellType();
        switch (n) {
            case 2: {
                this._cell.setV(richTextString.getString());
                this._cell.setT(STCellType.STR);
                break;
            }
            default: {
                if (this._cell.getT() == STCellType.INLINE_STR) {
                    this._cell.setV(richTextString.getString());
                    break;
                }
                this._cell.setT(STCellType.S);
                XSSFRichTextString xSSFRichTextString = (XSSFRichTextString)richTextString;
                xSSFRichTextString.setStylesTableReference(this._stylesSource);
                int n2 = this._sharedStringSource.addEntry(xSSFRichTextString.getCTRst());
                this._cell.setV(Integer.toString(n2));
            }
        }
    }

    public String getCellFormula() {
        int n = this.getCellType();
        if (n != 2) {
            throw XSSFCell.typeMismatch(2, n, false);
        }
        CTCellFormula cTCellFormula = this._cell.getF();
        if (this.isPartOfArrayFormulaGroup() && cTCellFormula == null) {
            XSSFCell xSSFCell = this.getSheet().getFirstCellInArrayFormula(this);
            return xSSFCell.getCellFormula();
        }
        if (cTCellFormula.getT() == STCellFormulaType.SHARED) {
            return this.convertSharedFormula((int)cTCellFormula.getSi());
        }
        return cTCellFormula.getStringValue();
    }

    private String convertSharedFormula(int n) {
        XSSFSheet xSSFSheet = this.getSheet();
        CTCellFormula cTCellFormula = xSSFSheet.getSharedFormula(n);
        if (cTCellFormula == null) {
            throw new IllegalStateException("Master cell of a shared formula with sid=" + n + " was not found");
        }
        String string = cTCellFormula.getStringValue();
        String string2 = cTCellFormula.getRef();
        CellRangeAddress cellRangeAddress = CellRangeAddress.valueOf(string2);
        int n2 = xSSFSheet.getWorkbook().getSheetIndex(xSSFSheet);
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(xSSFSheet.getWorkbook());
        SharedFormula sharedFormula = new SharedFormula(SpreadsheetVersion.EXCEL2007);
        Ptg[] ptgArray = FormulaParser.parse(string, xSSFEvaluationWorkbook, 0, n2);
        Ptg[] ptgArray2 = sharedFormula.convertSharedFormulas(ptgArray, this.getRowIndex() - cellRangeAddress.getFirstRow(), this.getColumnIndex() - cellRangeAddress.getFirstColumn());
        return FormulaRenderer.toFormulaString(xSSFEvaluationWorkbook, ptgArray2);
    }

    public void setCellFormula(String string) {
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        this.setFormula(string, 0);
    }

    void setCellArrayFormula(String string, CellRangeAddress cellRangeAddress) {
        this.setFormula(string, 2);
        CTCellFormula cTCellFormula = this._cell.getF();
        cTCellFormula.setT(STCellFormulaType.ARRAY);
        cTCellFormula.setRef(cellRangeAddress.formatAsString());
    }

    private void setFormula(String string, int n) {
        XSSFWorkbook xSSFWorkbook = this._row.getSheet().getWorkbook();
        if (string == null) {
            xSSFWorkbook.onDeleteFormula(this);
            if (this._cell.isSetF()) {
                this._cell.unsetF();
            }
            return;
        }
        XSSFEvaluationWorkbook xSSFEvaluationWorkbook = XSSFEvaluationWorkbook.create(xSSFWorkbook);
        FormulaParser.parse(string, xSSFEvaluationWorkbook, n, xSSFWorkbook.getSheetIndex(this.getSheet()));
        CTCellFormula cTCellFormula = CTCellFormula.Factory.newInstance();
        cTCellFormula.setStringValue(string);
        this._cell.setF(cTCellFormula);
        if (this._cell.isSetV()) {
            this._cell.unsetV();
        }
    }

    public int getColumnIndex() {
        return this._cellNum;
    }

    public int getRowIndex() {
        return this._row.getRowNum();
    }

    public String getReference() {
        String string = this._cell.getR();
        if (string == null) {
            return new CellReference(this).formatAsString();
        }
        return string;
    }

    public XSSFCellStyle getCellStyle() {
        XSSFCellStyle xSSFCellStyle = null;
        if (this._stylesSource.getNumCellStyles() > 0) {
            long l = this._cell.isSetS() ? this._cell.getS() : 0L;
            xSSFCellStyle = this._stylesSource.getStyleAt((int)l);
        }
        return xSSFCellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        if (cellStyle == null) {
            if (this._cell.isSetS()) {
                this._cell.unsetS();
            }
        } else {
            XSSFCellStyle xSSFCellStyle = (XSSFCellStyle)cellStyle;
            xSSFCellStyle.verifyBelongsToStylesSource(this._stylesSource);
            long l = this._stylesSource.putStyle(xSSFCellStyle);
            this._cell.setS(l);
        }
    }

    private boolean isFormulaCell() {
        return this._cell.getF() != null || this.getSheet().isCellInArrayFormulaContext(this);
    }

    public int getCellType() {
        if (this.isFormulaCell()) {
            return 2;
        }
        return this.getBaseCellType(true);
    }

    public int getCachedFormulaResultType() {
        if (!this.isFormulaCell()) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return this.getBaseCellType(false);
    }

    private int getBaseCellType(boolean bl) {
        switch (this._cell.getT().intValue()) {
            case 1: {
                return 4;
            }
            case 2: {
                if (!this._cell.isSetV() && bl) {
                    return 3;
                }
                return 0;
            }
            case 3: {
                return 5;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalStateException("Illegal cell type: " + this._cell.getT());
    }

    public Date getDateCellValue() {
        int n = this.getCellType();
        if (n == 3) {
            return null;
        }
        double d = this.getNumericCellValue();
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        return DateUtil.getJavaDate(d, bl);
    }

    public void setCellValue(Date date) {
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate(date, bl));
    }

    public void setCellValue(Calendar calendar) {
        boolean bl = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate(calendar, bl));
    }

    public String getErrorCellString() {
        int n = this.getBaseCellType(true);
        if (n != 5) {
            throw XSSFCell.typeMismatch(5, n, false);
        }
        return this._cell.getV();
    }

    public byte getErrorCellValue() {
        String string = this.getErrorCellString();
        if (string == null) {
            return 0;
        }
        return FormulaError.forString(string).getCode();
    }

    public void setCellErrorValue(byte by) {
        FormulaError formulaError = FormulaError.forInt(by);
        this.setCellErrorValue(formulaError);
    }

    public void setCellErrorValue(FormulaError formulaError) {
        this._cell.setT(STCellType.E);
        this._cell.setV(formulaError.getString());
    }

    public void setAsActiveCell() {
        this.getSheet().setActiveCell(this.getReference());
    }

    private void setBlank() {
        CTCell cTCell = CTCell.Factory.newInstance();
        cTCell.setR(this._cell.getR());
        if (this._cell.isSetS()) {
            cTCell.setS(this._cell.getS());
        }
        this._cell.set((XmlObject)cTCell);
    }

    protected void setCellNum(int n) {
        XSSFCell.checkBounds(n);
        this._cellNum = n;
        String string = new CellReference(this.getRowIndex(), this.getColumnIndex()).formatAsString();
        this._cell.setR(string);
    }

    public void setCellType(int n) {
        int n2 = this.getCellType();
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        if (n2 == 2 && n != 2) {
            this.getSheet().getWorkbook().onDeleteFormula(this);
        }
        switch (n) {
            case 3: {
                this.setBlank();
                break;
            }
            case 4: {
                String string = this.convertCellValueToBoolean() ? TRUE_AS_STRING : FALSE_AS_STRING;
                this._cell.setT(STCellType.B);
                this._cell.setV(string);
                break;
            }
            case 0: {
                this._cell.setT(STCellType.N);
                break;
            }
            case 5: {
                this._cell.setT(STCellType.E);
                break;
            }
            case 1: {
                if (n2 != 1) {
                    String string = this.convertCellValueToString();
                    XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(string);
                    xSSFRichTextString.setStylesTableReference(this._stylesSource);
                    int n3 = this._sharedStringSource.addEntry(xSSFRichTextString.getCTRst());
                    this._cell.setV(Integer.toString(n3));
                }
                this._cell.setT(STCellType.S);
                break;
            }
            case 2: {
                if (this._cell.isSetF()) break;
                CTCellFormula cTCellFormula = CTCellFormula.Factory.newInstance();
                cTCellFormula.setStringValue(FALSE_AS_STRING);
                this._cell.setF(cTCellFormula);
                if (!this._cell.isSetT()) break;
                this._cell.unsetT();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal cell type: " + n);
            }
        }
        if (n != 2 && this._cell.isSetF()) {
            this._cell.unsetF();
        }
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(this.getErrorCellValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", LocaleUtil.getUserLocale());
                    simpleDateFormat.setTimeZone(LocaleUtil.getUserTimeZone());
                    return simpleDateFormat.format(this.getDateCellValue());
                }
                return Double.toString(this.getNumericCellValue());
            }
            case 1: {
                return this.getRichStringCellValue().toString();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public String getRawValue() {
        return this._cell.getV();
    }

    private static String getCellTypeName(int n) {
        switch (n) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + n + ")#";
    }

    private static RuntimeException typeMismatch(int n, int n2, boolean bl) {
        String string = "Cannot get a " + XSSFCell.getCellTypeName(n) + " value from a " + XSSFCell.getCellTypeName(n2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static void checkBounds(int n) {
        SpreadsheetVersion spreadsheetVersion = SpreadsheetVersion.EXCEL2007;
        int n2 = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid column index (" + n + ").  Allowable column range for " + spreadsheetVersion.name() + " is (0.." + n2 + ") or ('A'..'" + spreadsheetVersion.getLastColumnName() + "')");
        }
    }

    public XSSFComment getCellComment() {
        return this.getSheet().getCellComment(this._row.getRowNum(), this.getColumnIndex());
    }

    public void setCellComment(Comment comment) {
        if (comment == null) {
            this.removeCellComment();
            return;
        }
        comment.setRow(this.getRowIndex());
        comment.setColumn(this.getColumnIndex());
    }

    public void removeCellComment() {
        XSSFComment xSSFComment = this.getCellComment();
        if (xSSFComment != null) {
            String string = this.getReference();
            XSSFSheet xSSFSheet = this.getSheet();
            xSSFSheet.getCommentsTable(false).removeComment(string);
            xSSFSheet.getVMLDrawing(false).removeCommentShape(this.getRowIndex(), this.getColumnIndex());
        }
    }

    public XSSFHyperlink getHyperlink() {
        return this.getSheet().getHyperlink(this._row.getRowNum(), this._cellNum);
    }

    public void setHyperlink(Hyperlink hyperlink) {
        if (hyperlink == null) {
            this.removeHyperlink();
            return;
        }
        XSSFHyperlink xSSFHyperlink = (XSSFHyperlink)hyperlink;
        xSSFHyperlink.setCellReference(new CellReference(this._row.getRowNum(), this._cellNum).formatAsString());
        this.getSheet().addHyperlink(xSSFHyperlink);
    }

    public void removeHyperlink() {
        this.getSheet().removeHyperlink(this._row.getRowNum(), this._cellNum);
    }

    @Internal
    public CTCell getCTCell() {
        return this._cell;
    }

    @Internal
    public void setCTCell(CTCell cTCell) {
        this._cell = cTCell;
    }

    private boolean convertCellValueToBoolean() {
        int n = this.getCellType();
        if (n == 2) {
            n = this.getBaseCellType(false);
        }
        switch (n) {
            case 4: {
                return TRUE_AS_STRING.equals(this._cell.getV());
            }
            case 1: {
                int n2 = Integer.parseInt(this._cell.getV());
                XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this._sharedStringSource.getEntryAt(n2));
                String string = xSSFRichTextString.getString();
                return Boolean.parseBoolean(string);
            }
            case 0: {
                return Double.parseDouble(this._cell.getV()) != 0.0;
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + n + ")");
    }

    private String convertCellValueToString() {
        int n = this.getCellType();
        switch (n) {
            case 3: {
                return "";
            }
            case 4: {
                return TRUE_AS_STRING.equals(this._cell.getV()) ? "TRUE" : "FALSE";
            }
            case 1: {
                int n2 = Integer.parseInt(this._cell.getV());
                XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(this._sharedStringSource.getEntryAt(n2));
                return xSSFRichTextString.getString();
            }
            case 0: 
            case 5: {
                return this._cell.getV();
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell type (" + n + ")");
            }
        }
        n = this.getBaseCellType(false);
        String string = this._cell.getV();
        switch (n) {
            case 4: {
                if (TRUE_AS_STRING.equals(string)) {
                    return "TRUE";
                }
                if (FALSE_AS_STRING.equals(string)) {
                    return "FALSE";
                }
                throw new IllegalStateException("Unexpected boolean cached formula value '" + string + "'.");
            }
            case 0: 
            case 1: 
            case 5: {
                return string;
            }
        }
        throw new IllegalStateException("Unexpected formula result type (" + n + ")");
    }

    public CellRangeAddress getArrayFormulaRange() {
        XSSFCell xSSFCell = this.getSheet().getFirstCellInArrayFormula(this);
        if (xSSFCell == null) {
            throw new IllegalStateException("Cell " + this.getReference() + " is not part of an array formula.");
        }
        String string = xSSFCell._cell.getF().getRef();
        return CellRangeAddress.valueOf(string);
    }

    public boolean isPartOfArrayFormulaGroup() {
        return this.getSheet().isCellInArrayFormulaContext(this);
    }

    void notifyArrayFormulaChanging(String string) {
        if (this.isPartOfArrayFormulaGroup()) {
            CellRangeAddress cellRangeAddress = this.getArrayFormulaRange();
            if (cellRangeAddress.getNumberOfCells() > 1) {
                throw new IllegalStateException(string);
            }
            this.getRow().getSheet().removeArrayFormula(this);
        }
    }

    void notifyArrayFormulaChanging() {
        CellReference cellReference = new CellReference(this);
        String string = "Cell " + cellReference.formatAsString() + " is part of a multi-cell array formula. " + "You cannot change part of an array.";
        this.notifyArrayFormulaChanging(string);
    }
}

