/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import ai2.org.apache.poi.ss.formula.EvaluationCell;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai2.org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import ai2.org.apache.poi.ss.formula.eval.BoolEval;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.formula.eval.NumberEval;
import ai2.org.apache.poi.ss.formula.eval.StringEval;
import ai2.org.apache.poi.ss.formula.eval.ValueEval;
import ai2.org.apache.poi.ss.usermodel.Cell;
import ai2.org.apache.poi.ss.usermodel.CellValue;
import ai2.org.apache.poi.ss.usermodel.FormulaEvaluator;
import ai2.org.apache.poi.xssf.usermodel.XSSFCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import ai2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXSSFFormulaEvaluator
implements FormulaEvaluator,
WorkbookEvaluatorProvider {
    private WorkbookEvaluator _bookEvaluator;

    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator workbookEvaluator) {
        this._bookEvaluator = workbookEvaluator;
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    @Override
    public int evaluateFormulaCell(Cell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cellValue = this.evaluateFormulaCellValue(cell);
        BaseXSSFFormulaEvaluator.setCellValue(cell, cellValue);
        return cellValue.getCellType();
    }

    protected void doEvaluateInCell(Cell cell) {
        if (cell == null) {
            return;
        }
        if (cell.getCellType() == 2) {
            CellValue cellValue = this.evaluateFormulaCellValue(cell);
            BaseXSSFFormulaEvaluator.setCellType(cell, cellValue);
            BaseXSSFFormulaEvaluator.setCellValue(cell, cellValue);
        }
    }

    private static void setCellType(Cell cell, CellValue cellValue) {
        int n = cellValue.getCellType();
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(n);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + n + ")");
    }

    private static void setCellValue(Cell cell, CellValue cellValue) {
        int n = cellValue.getCellType();
        switch (n) {
            case 4: {
                cell.setCellValue(cellValue.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cellValue.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cellValue.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(new XSSFRichTextString(cellValue.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + n + ")");
            }
        }
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    private CellValue evaluateFormulaCellValue(Cell cell) {
        EvaluationCell evaluationCell = this.toEvaluationCell(cell);
        ValueEval valueEval = this._bookEvaluator.evaluate(evaluationCell);
        if (valueEval instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            return new CellValue(numberEval.getNumberValue());
        }
        if (valueEval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            return CellValue.valueOf(boolEval.getBooleanValue());
        }
        if (valueEval instanceof StringEval) {
            StringEval stringEval = (StringEval)valueEval;
            return new CellValue(stringEval.getStringValue());
        }
        if (valueEval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)valueEval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + valueEval.getClass().getName() + ")");
    }

    @Override
    public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> map) {
        CollaboratingWorkbooksEnvironment.setupFormulaEvaluator(map);
    }

    @Override
    public WorkbookEvaluator _getWorkbookEvaluator() {
        return this._bookEvaluator;
    }

    @Override
    public void setIgnoreMissingWorkbooks(boolean bl) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(bl);
    }

    @Override
    public void setDebugEvaluationOutputForNextEval(boolean bl) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(bl);
    }
}

