/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.xssf.usermodel;

import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.formula.EvaluationName;
import ai2.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaParser;
import ai2.org.apache.poi.ss.formula.FormulaParsingWorkbook;
import ai2.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai2.org.apache.poi.ss.formula.SheetIdentifier;
import ai2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai2.org.apache.poi.ss.formula.ptg.Area3DPxg;
import ai2.org.apache.poi.ss.formula.ptg.NamePtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai2.org.apache.poi.ss.formula.ptg.NameXPxg;
import ai2.org.apache.poi.ss.formula.ptg.Ptg;
import ai2.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import ai2.org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import ai2.org.apache.poi.ss.formula.udf.UDFFinder;
import ai2.org.apache.poi.ss.util.AreaReference;
import ai2.org.apache.poi.ss.util.CellReference;
import ai2.org.apache.poi.xssf.model.ExternalLinksTable;
import ai2.org.apache.poi.xssf.usermodel.XSSFName;
import ai2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXSSFEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    protected final XSSFWorkbook _uBook;

    protected BaseXSSFEvaluationWorkbook(XSSFWorkbook xSSFWorkbook) {
        this._uBook = xSSFWorkbook;
    }

    private int convertFromExternalSheetIndex(int n) {
        return n;
    }

    @Override
    public int convertFromExternSheetIndex(int n) {
        return n;
    }

    private int convertToExternalSheetIndex(int n) {
        return n;
    }

    @Override
    public int getExternalSheetIndex(String string) {
        int n = this._uBook.getSheetIndex(string);
        return this.convertToExternalSheetIndex(n);
    }

    private int resolveBookIndex(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 2);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            List<ExternalLinksTable> list = this._uBook.getExternalLinksTable();
            int n = this.findExternalLinkIndex(string, list);
            if (n != -1) {
                return n;
            }
            if (string.startsWith("'file:///") && string.endsWith("'")) {
                String string2 = string.substring(string.lastIndexOf(47) + 1);
                n = this.findExternalLinkIndex(string2 = string2.substring(0, string2.length() - 1), list);
                if (n != -1) {
                    return n;
                }
                FakeExternalLinksTable fakeExternalLinksTable = new FakeExternalLinksTable(string2);
                list.add(fakeExternalLinksTable);
                return list.size();
            }
            throw new RuntimeException("Book not linked for filename " + string);
        }
    }

    private int findExternalLinkIndex(String string, List<ExternalLinksTable> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getLinkedFileName().equals(string)) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public EvaluationName getName(String string, int n) {
        for (int i = 0; i < this._uBook.getNumberOfNames(); ++i) {
            XSSFName xSSFName = this._uBook.getNameAt(i);
            String string2 = xSSFName.getNameName();
            int n2 = xSSFName.getSheetIndex();
            if (!string.equalsIgnoreCase(string2) || n2 != -1 && n2 != n) continue;
            return new Name(this._uBook.getNameAt(i), i, this);
        }
        return n == -1 ? null : this.getName(string, -1);
    }

    @Override
    public String getSheetName(int n) {
        return this._uBook.getSheetName(n);
    }

    @Override
    public EvaluationWorkbook.ExternalName getExternalName(int n, int n2) {
        throw new IllegalStateException("HSSF-style external references are not supported for XSSF");
    }

    @Override
    public EvaluationWorkbook.ExternalName getExternalName(String string, String string2, int n) {
        if (n > 0) {
            int n2 = n - 1;
            ExternalLinksTable externalLinksTable = this._uBook.getExternalLinksTable().get(n2);
            for (ai2.org.apache.poi.ss.usermodel.Name name : externalLinksTable.getDefinedNames()) {
                if (!name.getNameName().equals(string)) continue;
                int n3 = name.getSheetIndex() + 1;
                return new EvaluationWorkbook.ExternalName(string, -1, n3);
            }
            throw new IllegalArgumentException("Name '" + string + "' not found in " + "reference to " + externalLinksTable.getLinkedFileName());
        }
        int n4 = this._uBook.getNameIndex(string);
        return new EvaluationWorkbook.ExternalName(string, n4, 0);
    }

    @Override
    public NameXPxg getNameXPtg(String string, SheetIdentifier sheetIdentifier) {
        IndexedUDFFinder indexedUDFFinder = (IndexedUDFFinder)this.getUDFFinder();
        FreeRefFunction freeRefFunction = indexedUDFFinder.findFunction(string);
        if (freeRefFunction != null) {
            return new NameXPxg(null, string);
        }
        if (sheetIdentifier == null) {
            if (this._uBook.getNameIndex(string) > -1) {
                return new NameXPxg(null, string);
            }
            return null;
        }
        if (sheetIdentifier._sheetIdentifier == null) {
            int n = this.resolveBookIndex(sheetIdentifier._bookName);
            return new NameXPxg(n, null, string);
        }
        String string2 = sheetIdentifier._sheetIdentifier.getName();
        if (sheetIdentifier._bookName != null) {
            int n = this.resolveBookIndex(sheetIdentifier._bookName);
            return new NameXPxg(n, string2, string);
        }
        return new NameXPxg(string2, string);
    }

    @Override
    public Ptg get3DReferencePtg(CellReference cellReference, SheetIdentifier sheetIdentifier) {
        if (sheetIdentifier._bookName != null) {
            int n = this.resolveBookIndex(sheetIdentifier._bookName);
            return new Ref3DPxg(n, sheetIdentifier, cellReference);
        }
        return new Ref3DPxg(sheetIdentifier, cellReference);
    }

    @Override
    public Ptg get3DReferencePtg(AreaReference areaReference, SheetIdentifier sheetIdentifier) {
        if (sheetIdentifier._bookName != null) {
            int n = this.resolveBookIndex(sheetIdentifier._bookName);
            return new Area3DPxg(n, sheetIdentifier, areaReference);
        }
        return new Area3DPxg(sheetIdentifier, areaReference);
    }

    @Override
    public String resolveNameXText(NameXPtg nameXPtg) {
        int n = nameXPtg.getNameIndex();
        String string = null;
        IndexedUDFFinder indexedUDFFinder = (IndexedUDFFinder)this.getUDFFinder();
        string = indexedUDFFinder.getFunctionName(n);
        if (string != null) {
            return string;
        }
        XSSFName xSSFName = this._uBook.getNameAt(n);
        if (xSSFName != null) {
            string = xSSFName.getNameName();
        }
        return string;
    }

    @Override
    public EvaluationWorkbook.ExternalSheet getExternalSheet(int n) {
        throw new IllegalStateException("HSSF-style external references are not supported for XSSF");
    }

    @Override
    public EvaluationWorkbook.ExternalSheet getExternalSheet(String string, String string2, int n) {
        String string3;
        if (n > 0) {
            int n2 = n - 1;
            ExternalLinksTable externalLinksTable = this._uBook.getExternalLinksTable().get(n2);
            string3 = externalLinksTable.getLinkedFileName();
        } else {
            string3 = null;
        }
        if (string2 == null || string.equals(string2)) {
            return new EvaluationWorkbook.ExternalSheet(string3, string);
        }
        return new EvaluationWorkbook.ExternalSheetRange(string3, string, string2);
    }

    @Override
    public int getExternalSheetIndex(String string, String string2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public int getSheetIndex(String string) {
        return this._uBook.getSheetIndex(string);
    }

    @Override
    public String getSheetFirstNameByExternSheet(int n) {
        int n2 = this.convertFromExternalSheetIndex(n);
        return this._uBook.getSheetName(n2);
    }

    @Override
    public String getSheetLastNameByExternSheet(int n) {
        return this.getSheetFirstNameByExternSheet(n);
    }

    @Override
    public String getNameText(NamePtg namePtg) {
        return this._uBook.getNameAt(namePtg.getIndex()).getNameName();
    }

    @Override
    public EvaluationName getName(NamePtg namePtg) {
        int n = namePtg.getIndex();
        return new Name(this._uBook.getNameAt(n), n, this);
    }

    @Override
    public UDFFinder getUDFFinder() {
        return this._uBook.getUDFFinder();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    private static final class Name
    implements EvaluationName {
        private final XSSFName _nameRecord;
        private final int _index;
        private final FormulaParsingWorkbook _fpBook;

        public Name(XSSFName xSSFName, int n, FormulaParsingWorkbook formulaParsingWorkbook) {
            this._nameRecord = xSSFName;
            this._index = n;
            this._fpBook = formulaParsingWorkbook;
        }

        public Ptg[] getNameDefinition() {
            return FormulaParser.parse(this._nameRecord.getRefersToFormula(), this._fpBook, 4, this._nameRecord.getSheetIndex());
        }

        public String getNameText() {
            return this._nameRecord.getNameName();
        }

        public boolean hasFormula() {
            CTDefinedName cTDefinedName = this._nameRecord.getCTName();
            String string = cTDefinedName.getStringValue();
            return !cTDefinedName.getFunction() && string != null && string.length() > 0;
        }

        public boolean isFunctionName() {
            return this._nameRecord.isFunctionName();
        }

        public boolean isRange() {
            return this.hasFormula();
        }

        public NamePtg createPtg() {
            return new NamePtg(this._index);
        }
    }

    private static class FakeExternalLinksTable
    extends ExternalLinksTable {
        private final String fileName;

        private FakeExternalLinksTable(String string) {
            this.fileName = string;
        }

        public String getLinkedFileName() {
            return this.fileName;
        }
    }
}

